/*
 * Decompiled with CFR 0.152.
 */
package shadows.apotheosis.util;

import com.mojang.datafixers.kinds.App;
import com.mojang.datafixers.kinds.Applicative;
import com.mojang.serialization.Codec;
import com.mojang.serialization.codecs.RecordCodecBuilder;
import java.util.List;
import java.util.Map;
import java.util.Optional;
import java.util.function.Predicate;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.util.ExtraCodecs;
import net.minecraft.util.RandomSource;
import net.minecraft.util.random.WeightedRandom;
import net.minecraft.world.entity.EquipmentSlot;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.Mob;
import net.minecraft.world.item.ItemStack;
import shadows.apotheosis.util.Weighted;
import shadows.placebo.json.ItemAdapter;
import shadows.placebo.json.PSerializer;
import shadows.placebo.json.TypeKeyed;
import shadows.placebo.json.WeightedJsonReloadListener;

public class GearSet
extends TypeKeyed.TypeKeyedBase<GearSet>
implements WeightedJsonReloadListener.ILuckyWeighted {
    public static final Codec<GearSet> CODEC = RecordCodecBuilder.create(inst -> inst.group((App)Codec.intRange((int)0, (int)Integer.MAX_VALUE).fieldOf("weight").forGetter(WeightedJsonReloadListener.ILuckyWeighted::getWeight), (App)Codec.floatRange((float)0.0f, (float)Float.MAX_VALUE).optionalFieldOf("quality", (Object)Float.valueOf(0.0f)).forGetter(WeightedJsonReloadListener.ILuckyWeighted::getQuality), (App)WeightedItemStack.LIST_CODEC.fieldOf("mainhands").forGetter(g -> g.mainhands), (App)WeightedItemStack.LIST_CODEC.fieldOf("offhands").forGetter(g -> g.offhands), (App)WeightedItemStack.LIST_CODEC.fieldOf("boots").forGetter(g -> g.boots), (App)WeightedItemStack.LIST_CODEC.fieldOf("leggings").forGetter(g -> g.leggings), (App)WeightedItemStack.LIST_CODEC.fieldOf("chestplates").forGetter(g -> g.chestplates), (App)WeightedItemStack.LIST_CODEC.fieldOf("helmets").forGetter(g -> g.helmets), (App)Codec.STRING.listOf().fieldOf("tags").forGetter(g -> g.tags)).apply((Applicative)inst, GearSet::new));
    public static final PSerializer<GearSet> SERIALIZER = PSerializer.fromCodec((String)"Gear Set", CODEC);
    protected final int weight;
    protected final float quality;
    protected final List<WeightedItemStack> mainhands;
    protected final List<WeightedItemStack> offhands;
    protected final List<WeightedItemStack> boots;
    protected final List<WeightedItemStack> leggings;
    protected final List<WeightedItemStack> chestplates;
    protected final List<WeightedItemStack> helmets;
    protected final List<String> tags;
    protected transient Map<EquipmentSlot, List<WeightedItemStack>> slotToStacks;

    public GearSet(int weight, float quality, List<WeightedItemStack> mainhands, List<WeightedItemStack> offhands, List<WeightedItemStack> boots, List<WeightedItemStack> leggings, List<WeightedItemStack> chestplates, List<WeightedItemStack> helmets, List<String> tags) {
        this.weight = weight;
        this.quality = quality;
        this.mainhands = mainhands;
        this.offhands = offhands;
        this.boots = boots;
        this.leggings = leggings;
        this.chestplates = chestplates;
        this.helmets = helmets;
        this.tags = tags;
    }

    public int getWeight() {
        return this.weight;
    }

    public float getQuality() {
        return this.quality;
    }

    public LivingEntity apply(LivingEntity entity) {
        for (EquipmentSlot slot : EquipmentSlot.values()) {
            GearSet.getRandomStack(this.getPotentials(slot), entity.f_19796_).ifPresent(s -> s.apply(entity, slot));
        }
        return entity;
    }

    public List<WeightedItemStack> getPotentials(EquipmentSlot slot) {
        switch (slot) {
            case MAINHAND: {
                return this.mainhands;
            }
            case OFFHAND: {
                return this.offhands;
            }
            case FEET: {
                return this.boots;
            }
            case LEGS: {
                return this.leggings;
            }
            case CHEST: {
                return this.chestplates;
            }
            case HEAD: {
                return this.helmets;
            }
        }
        throw new RuntimeException("invalid slot");
    }

    public PSerializer<? extends GearSet> getSerializer() {
        return SERIALIZER;
    }

    public static Optional<WeightedItemStack> getRandomStack(List<WeightedItemStack> stacks, RandomSource random) {
        if (stacks.isEmpty()) {
            return Optional.empty();
        }
        return Optional.of((WeightedItemStack)WeightedRandom.m_216822_((RandomSource)random, stacks).get());
    }

    public static class WeightedItemStack
    extends Weighted {
        public static final Codec<WeightedItemStack> CODEC = RecordCodecBuilder.create(inst -> inst.group((App)ItemAdapter.CODEC.fieldOf("stack").forGetter(w -> w.stack), (App)Codec.INT.fieldOf("weight").forGetter(w -> w.weight), (App)Codec.FLOAT.optionalFieldOf("drop_chance", (Object)Float.valueOf(-1.0f)).forGetter(w -> Float.valueOf(w.dropChance))).apply((Applicative)inst, WeightedItemStack::new));
        public static final Codec<List<WeightedItemStack>> LIST_CODEC = CODEC.listOf();
        final ItemStack stack;
        final float dropChance;

        public WeightedItemStack(ItemStack stack, int weight, float dropChance) {
            super(weight);
            this.stack = stack;
            this.dropChance = dropChance;
        }

        public ItemStack getStack() {
            return this.stack;
        }

        public String toString() {
            return "Stack: " + this.stack.toString() + " @ Weight: " + this.weight;
        }

        public void apply(LivingEntity entity, EquipmentSlot slot) {
            entity.m_8061_(slot, this.stack.m_41777_());
            if (this.dropChance >= 0.0f && entity instanceof Mob) {
                Mob mob = (Mob)entity;
                mob.m_21409_(slot, this.dropChance);
            }
        }
    }

    public static class SetPredicate
    implements Predicate<GearSet> {
        public static final Codec<SetPredicate> CODEC = ExtraCodecs.m_184405_(s -> s.key, SetPredicate::new);
        protected final String key;
        protected final Predicate<GearSet> internal;

        public SetPredicate(String key) {
            this.key = key;
            if (key.startsWith("#")) {
                String tag = key.substring(1);
                this.internal = t -> t.tags.contains(tag);
            } else {
                ResourceLocation id = new ResourceLocation(key);
                this.internal = t -> ((GearSet)t).id.equals((Object)id);
            }
        }

        @Override
        public boolean test(GearSet t) {
            return this.internal.test(t);
        }

        public String toString() {
            return "SetPredicate[" + this.key + "]";
        }
    }
}

