/*
 * Decompiled with CFR 0.152.
 */
package shadows.apotheosis.ench;

import com.google.common.collect.ImmutableSet;
import it.unimi.dsi.fastutil.objects.Object2IntMap;
import it.unimi.dsi.fastutil.objects.Object2IntOpenHashMap;
import java.io.File;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Set;
import net.minecraft.core.dispenser.DispenseItemBehavior;
import net.minecraft.core.dispenser.ShearsDispenseItemBehavior;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.world.damagesource.DamageSource;
import net.minecraft.world.entity.EquipmentSlot;
import net.minecraft.world.entity.MobType;
import net.minecraft.world.inventory.MenuType;
import net.minecraft.world.item.BlockItem;
import net.minecraft.world.item.HoeItem;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.Items;
import net.minecraft.world.item.ShearsItem;
import net.minecraft.world.item.ShieldItem;
import net.minecraft.world.item.alchemy.Potions;
import net.minecraft.world.item.crafting.Ingredient;
import net.minecraft.world.item.crafting.RecipeSerializer;
import net.minecraft.world.item.enchantment.Enchantment;
import net.minecraft.world.item.enchantment.EnchantmentCategory;
import net.minecraft.world.item.enchantment.EnchantmentInstance;
import net.minecraft.world.item.enchantment.ProtectionEnchantment;
import net.minecraft.world.level.ItemLike;
import net.minecraft.world.level.block.AnvilBlock;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.block.Blocks;
import net.minecraft.world.level.block.DispenserBlock;
import net.minecraft.world.level.block.SoundType;
import net.minecraft.world.level.block.entity.BlockEntityType;
import net.minecraft.world.level.block.state.BlockBehaviour;
import net.minecraft.world.level.material.Material;
import net.minecraftforge.common.MinecraftForge;
import net.minecraftforge.common.ToolActions;
import net.minecraftforge.eventbus.api.SubscribeEvent;
import net.minecraftforge.fml.ModList;
import net.minecraftforge.fml.event.lifecycle.FMLClientSetupEvent;
import net.minecraftforge.fml.event.lifecycle.FMLCommonSetupEvent;
import net.minecraftforge.fml.event.lifecycle.InterModProcessEvent;
import net.minecraftforge.registries.ForgeRegistries;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;
import shadows.apotheosis.Apoth;
import shadows.apotheosis.Apotheosis;
import shadows.apotheosis.ench.EnchModuleClient;
import shadows.apotheosis.ench.EnchModuleEvents;
import shadows.apotheosis.ench.EnchantmentInfo;
import shadows.apotheosis.ench.anvil.AnvilTile;
import shadows.apotheosis.ench.anvil.ApothAnvilBlock;
import shadows.apotheosis.ench.anvil.ApothAnvilItem;
import shadows.apotheosis.ench.anvil.ObliterationEnchant;
import shadows.apotheosis.ench.anvil.SplittingEnchant;
import shadows.apotheosis.ench.compat.EnchTOPPlugin;
import shadows.apotheosis.ench.enchantments.ChromaticEnchant;
import shadows.apotheosis.ench.enchantments.IcyThornsEnchant;
import shadows.apotheosis.ench.enchantments.InertEnchantment;
import shadows.apotheosis.ench.enchantments.NaturesBlessingEnchant;
import shadows.apotheosis.ench.enchantments.ReboundingEnchant;
import shadows.apotheosis.ench.enchantments.ReflectiveEnchant;
import shadows.apotheosis.ench.enchantments.ShieldBashEnchant;
import shadows.apotheosis.ench.enchantments.SpearfishingEnchant;
import shadows.apotheosis.ench.enchantments.StableFootingEnchant;
import shadows.apotheosis.ench.enchantments.TemptingEnchant;
import shadows.apotheosis.ench.enchantments.corrupted.BerserkersFuryEnchant;
import shadows.apotheosis.ench.enchantments.corrupted.LifeMendingEnchant;
import shadows.apotheosis.ench.enchantments.masterwork.ChainsawEnchant;
import shadows.apotheosis.ench.enchantments.masterwork.CrescendoEnchant;
import shadows.apotheosis.ench.enchantments.masterwork.EarthsBoonEnchant;
import shadows.apotheosis.ench.enchantments.masterwork.EndlessQuiverEnchant;
import shadows.apotheosis.ench.enchantments.masterwork.GrowthSerumEnchant;
import shadows.apotheosis.ench.enchantments.masterwork.KnowledgeEnchant;
import shadows.apotheosis.ench.enchantments.masterwork.ScavengerEnchant;
import shadows.apotheosis.ench.enchantments.twisted.ExploitationEnchant;
import shadows.apotheosis.ench.enchantments.twisted.MinersFervorEnchant;
import shadows.apotheosis.ench.library.EnchLibraryBlock;
import shadows.apotheosis.ench.library.EnchLibraryContainer;
import shadows.apotheosis.ench.library.EnchLibraryTile;
import shadows.apotheosis.ench.objects.ExtractionTomeItem;
import shadows.apotheosis.ench.objects.GlowyBlockItem;
import shadows.apotheosis.ench.objects.ImprovedScrappingTomeItem;
import shadows.apotheosis.ench.objects.ScrappingTomeItem;
import shadows.apotheosis.ench.objects.TomeItem;
import shadows.apotheosis.ench.replacements.BaneEnchant;
import shadows.apotheosis.ench.replacements.DefenseEnchant;
import shadows.apotheosis.ench.table.ApothEnchantBlock;
import shadows.apotheosis.ench.table.ApothEnchantContainer;
import shadows.apotheosis.ench.table.ApothEnchantTile;
import shadows.apotheosis.ench.table.EnchantingRecipe;
import shadows.apotheosis.ench.table.EnchantingStatManager;
import shadows.apotheosis.ench.table.KeepNBTEnchantingRecipe;
import shadows.placebo.config.Configuration;
import shadows.placebo.container.ContainerUtil;
import shadows.placebo.loot.LootSystem;
import shadows.placebo.util.PlaceboUtil;
import shadows.placebo.util.RegistryEvent;

public class EnchModule {
    public static final Map<Enchantment, EnchantmentInfo> ENCHANTMENT_INFO = new HashMap<Enchantment, EnchantmentInfo>();
    public static final Object2IntMap<Enchantment> ENCH_HARD_CAPS = new Object2IntOpenHashMap();
    public static final String ENCH_HARD_CAP_IMC = "set_ench_hard_cap";
    public static final Logger LOGGER = LogManager.getLogger((String)"Apotheosis : Enchantment");
    public static final List<TomeItem> TYPED_BOOKS = new ArrayList<TomeItem>();
    public static final DamageSource CORRUPTED = new DamageSource("apoth_corrupted").m_19380_().m_19382_();
    public static final EquipmentSlot[] ARMOR = new EquipmentSlot[]{EquipmentSlot.HEAD, EquipmentSlot.CHEST, EquipmentSlot.LEGS, EquipmentSlot.FEET};
    public static final EnchantmentCategory HOE = EnchantmentCategory.create((String)"HOE", i -> i instanceof HoeItem);
    public static final EnchantmentCategory SHIELD = EnchantmentCategory.create((String)"SHIELD", i -> i instanceof ShieldItem);
    public static final EnchantmentCategory ANVIL = EnchantmentCategory.create((String)"ANVIL", i -> i instanceof BlockItem && ((BlockItem)i).m_40614_() instanceof AnvilBlock);
    public static final EnchantmentCategory SHEARS = EnchantmentCategory.create((String)"SHEARS", i -> i instanceof ShearsItem);
    public static final EnchantmentCategory PICKAXE = EnchantmentCategory.create((String)"PICKAXE", i -> i.canPerformAction(new ItemStack((ItemLike)i), ToolActions.PICKAXE_DIG));
    public static final EnchantmentCategory AXE = EnchantmentCategory.create((String)"AXE", i -> i.canPerformAction(new ItemStack((ItemLike)i), ToolActions.AXE_DIG));
    public static final EnchantmentCategory ARMOR_CHEST_LEGS = EnchantmentCategory.create((String)"ARMOR_CHEST_LEGS", i -> EnchantmentCategory.ARMOR_CHEST.m_7454_(i) || EnchantmentCategory.ARMOR_LEGS.m_7454_(i));
    static Configuration enchInfoConfig;

    @SubscribeEvent
    public void init(FMLCommonSetupEvent e) {
        this.reload(null);
        Apotheosis.HELPER.registerProvider(factory -> {
            Ingredient pot = Apotheosis.potionIngredient(Potions.f_43587_);
            factory.addShaped(Apoth.Blocks.HELLSHELF.get(), 3, 3, new Object[]{Blocks.f_50197_, Blocks.f_50197_, Blocks.f_50197_, Items.f_42585_, "forge:bookshelves", pot, Blocks.f_50197_, Blocks.f_50197_, Blocks.f_50197_});
            factory.addShaped(Apoth.Items.PRISMATIC_WEB, 3, 3, new Object[]{null, Items.f_42695_, null, Items.f_42695_, Blocks.f_50033_, Items.f_42695_, null, Items.f_42695_, null});
            ItemStack book = new ItemStack((ItemLike)Items.f_42517_);
            ItemStack stick = new ItemStack((ItemLike)Items.f_42398_);
            ItemStack blaze = new ItemStack((ItemLike)Items.f_42585_);
            factory.addShaped((Object)new ItemStack((ItemLike)Apoth.Items.HELMET_TOME.get(), 5), 3, 2, new Object[]{book, book, book, book, blaze, book});
            factory.addShaped((Object)new ItemStack((ItemLike)Apoth.Items.CHESTPLATE_TOME.get(), 8), 3, 3, new Object[]{book, blaze, book, book, book, book, book, book, book});
            factory.addShaped((Object)new ItemStack((ItemLike)Apoth.Items.LEGGINGS_TOME.get(), 7), 3, 3, new Object[]{book, null, book, book, blaze, book, book, book, book});
            factory.addShaped((Object)new ItemStack((ItemLike)Apoth.Items.BOOTS_TOME.get(), 4), 3, 2, new Object[]{book, null, book, book, blaze, book});
            factory.addShaped((Object)new ItemStack((ItemLike)Apoth.Items.WEAPON_TOME.get(), 2), 1, 3, new Object[]{book, book, new ItemStack((ItemLike)Items.f_42593_)});
            factory.addShaped((Object)new ItemStack((ItemLike)Apoth.Items.PICKAXE_TOME.get(), 3), 3, 3, new Object[]{book, book, book, null, blaze, null, null, stick, null});
            factory.addShaped((Object)new ItemStack((ItemLike)Apoth.Items.FISHING_TOME.get(), 2), 3, 3, new Object[]{null, null, blaze, null, stick, book, stick, null, book});
            factory.addShaped((Object)new ItemStack((ItemLike)Apoth.Items.BOW_TOME.get(), 3), 3, 3, new Object[]{null, stick, book, blaze, null, book, null, stick, book});
            factory.addShapeless((Object)new ItemStack((ItemLike)Apoth.Items.OTHER_TOME.get(), 6), new Object[]{book, book, book, book, book, book, blaze});
            factory.addShaped((Object)new ItemStack((ItemLike)Apoth.Items.SCRAP_TOME.get(), 8), 3, 3, new Object[]{book, book, book, book, Blocks.f_50322_, book, book, book, book});
            Ingredient maxHellshelf = Ingredient.m_43929_((ItemLike[])new ItemLike[]{(ItemLike)Apoth.Blocks.INFUSED_HELLSHELF.get()});
            factory.addShaped(Apoth.Blocks.BLAZING_HELLSHELF.get(), 3, 3, new Object[]{null, Items.f_42613_, null, Items.f_42613_, maxHellshelf, Items.f_42613_, Items.f_42593_, Items.f_42593_, Items.f_42593_});
            factory.addShaped(Apoth.Blocks.GLOWING_HELLSHELF.get(), 3, 3, new Object[]{null, Blocks.f_50141_, null, null, maxHellshelf, null, Blocks.f_50141_, null, Blocks.f_50141_});
            factory.addShaped(Apoth.Blocks.SEASHELF.get(), 3, 3, new Object[]{Blocks.f_50378_, Blocks.f_50378_, Blocks.f_50378_, Apotheosis.potionIngredient(Potions.f_43599_), "forge:bookshelves", Items.f_42529_, Blocks.f_50378_, Blocks.f_50378_, Blocks.f_50378_});
            Ingredient maxSeashelf = Ingredient.m_43929_((ItemLike[])new ItemLike[]{(ItemLike)Apoth.Blocks.INFUSED_SEASHELF.get()});
            factory.addShaped(Apoth.Blocks.CRYSTAL_SEASHELF.get(), 3, 3, new Object[]{null, Items.f_42696_, null, null, maxSeashelf, null, Items.f_42696_, null, Items.f_42696_});
            factory.addShaped(Apoth.Blocks.HEART_SEASHELF.get(), 3, 3, new Object[]{null, Items.f_42716_, null, Items.f_42695_, maxSeashelf, Items.f_42695_, Items.f_42695_, Items.f_42695_, Items.f_42695_});
            factory.addShaped(Apoth.Blocks.ENDSHELF.get(), 3, 3, new Object[]{Blocks.f_50443_, Blocks.f_50443_, Blocks.f_50443_, Items.f_42735_, "forge:bookshelves", Items.f_42584_, Blocks.f_50443_, Blocks.f_50443_, Blocks.f_50443_});
            factory.addShaped(Apoth.Blocks.PEARL_ENDSHELF.get(), 3, 3, new Object[]{Items.f_42001_, null, Items.f_42001_, Items.f_42584_, Apoth.Blocks.ENDSHELF.get(), Items.f_42584_, Items.f_42001_, null, Items.f_42001_});
            factory.addShaped(Apoth.Blocks.DRACONIC_ENDSHELF.get(), 3, 3, new Object[]{null, Items.f_42683_, null, Items.f_42584_, Apoth.Blocks.ENDSHELF.get(), Items.f_42584_, Items.f_42584_, Items.f_42584_, Items.f_42584_});
            factory.addShaped(Apoth.Blocks.BEESHELF.get(), 3, 3, new Object[]{Items.f_42784_, Items.f_42786_, Items.f_42784_, Items.f_42788_, "forge:bookshelves", Items.f_42788_, Items.f_42784_, Items.f_42786_, Items.f_42784_});
            factory.addShaped(Apoth.Blocks.MELONSHELF.get(), 3, 3, new Object[]{Items.f_42028_, Items.f_42028_, Items.f_42028_, Items.f_42546_, "forge:bookshelves", Items.f_42546_, Items.f_42028_, Items.f_42028_, Items.f_42028_});
            factory.addShaped(Apoth.Blocks.LIBRARY.get(), 3, 3, new Object[]{Blocks.f_50265_, Apoth.Blocks.INFUSED_HELLSHELF.get(), Blocks.f_50265_, Apoth.Blocks.INFUSED_HELLSHELF.get(), Blocks.f_50201_, Apoth.Blocks.INFUSED_HELLSHELF.get(), Blocks.f_50265_, Apoth.Blocks.INFUSED_HELLSHELF.get(), Blocks.f_50265_});
        });
        LootSystem.defaultBlockTable((Block)((Block)Apoth.Blocks.HELLSHELF.get()));
        LootSystem.defaultBlockTable((Block)((Block)Apoth.Blocks.INFUSED_HELLSHELF.get()));
        LootSystem.defaultBlockTable((Block)((Block)Apoth.Blocks.BLAZING_HELLSHELF.get()));
        LootSystem.defaultBlockTable((Block)((Block)Apoth.Blocks.GLOWING_HELLSHELF.get()));
        LootSystem.defaultBlockTable((Block)((Block)Apoth.Blocks.SEASHELF.get()));
        LootSystem.defaultBlockTable((Block)((Block)Apoth.Blocks.INFUSED_SEASHELF.get()));
        LootSystem.defaultBlockTable((Block)((Block)Apoth.Blocks.CRYSTAL_SEASHELF.get()));
        LootSystem.defaultBlockTable((Block)((Block)Apoth.Blocks.HEART_SEASHELF.get()));
        LootSystem.defaultBlockTable((Block)((Block)Apoth.Blocks.ENDSHELF.get()));
        LootSystem.defaultBlockTable((Block)((Block)Apoth.Blocks.PEARL_ENDSHELF.get()));
        LootSystem.defaultBlockTable((Block)((Block)Apoth.Blocks.DRACONIC_ENDSHELF.get()));
        LootSystem.defaultBlockTable((Block)((Block)Apoth.Blocks.BEESHELF.get()));
        LootSystem.defaultBlockTable((Block)((Block)Apoth.Blocks.MELONSHELF.get()));
        LootSystem.defaultBlockTable((Block)((Block)Apoth.Blocks.LIBRARY.get()));
        LootSystem.defaultBlockTable((Block)((Block)Apoth.Blocks.RECTIFIER.get()));
        LootSystem.defaultBlockTable((Block)((Block)Apoth.Blocks.RECTIFIER_T2.get()));
        LootSystem.defaultBlockTable((Block)((Block)Apoth.Blocks.RECTIFIER_T3.get()));
        LootSystem.defaultBlockTable((Block)((Block)Apoth.Blocks.SIGHTSHELF.get()));
        LootSystem.defaultBlockTable((Block)((Block)Apoth.Blocks.SIGHTSHELF_T2.get()));
        LootSystem.defaultBlockTable((Block)((Block)Apoth.Blocks.ENDER_LIBRARY.get()));
        MinecraftForge.EVENT_BUS.register((Object)new EnchModuleEvents());
        MinecraftForge.EVENT_BUS.addListener(this::reload);
        e.enqueueWork(() -> DispenserBlock.m_52672_((ItemLike)Items.f_42574_, (DispenseItemBehavior)new ShearsDispenseItemBehavior()));
        if (ModList.get().isLoaded("theoneprobe")) {
            EnchTOPPlugin.register();
        }
        EnchantingStatManager.INSTANCE.registerToBus();
    }

    @SubscribeEvent
    public void client(FMLClientSetupEvent e) {
        MinecraftForge.EVENT_BUS.register((Object)new EnchModuleClient());
        e.enqueueWork(EnchModuleClient::init);
    }

    @SubscribeEvent
    public void tiles(RegistryEvent.Register<BlockEntityType<?>> e) {
        e.getRegistry().register((Object)new BlockEntityType(AnvilTile::new, (Set)ImmutableSet.of((Object)Blocks.f_50322_, (Object)Blocks.f_50323_, (Object)Blocks.f_50324_), null), "anvil");
        BlockEntityType.f_58928_.f_58914_ = ApothEnchantTile::new;
        BlockEntityType.f_58928_.f_58915_ = ImmutableSet.of((Object)Blocks.f_50201_);
        e.getRegistry().register((Object)new BlockEntityType(EnchLibraryTile.BasicLibraryTile::new, (Set)ImmutableSet.of((Object)((Block)Apoth.Blocks.LIBRARY.get())), null), "library");
        e.getRegistry().register((Object)new BlockEntityType(EnchLibraryTile.EnderLibraryTile::new, (Set)ImmutableSet.of((Object)((Block)Apoth.Blocks.ENDER_LIBRARY.get())), null), "ender_library");
    }

    @SubscribeEvent
    public void containers(RegistryEvent.Register<MenuType<?>> e) {
        e.getRegistry().register((Object)new MenuType(ApothEnchantContainer::new), "enchanting_table");
        e.getRegistry().register((Object)ContainerUtil.makeType(EnchLibraryContainer::new), "library");
    }

    @SubscribeEvent
    public void recipeSerializers(RegistryEvent.Register<RecipeSerializer<?>> e) {
        e.getRegistry().register((Object)EnchantingRecipe.SERIALIZER, "enchanting");
        e.getRegistry().register((Object)KeepNBTEnchantingRecipe.SERIALIZER, "keep_nbt_enchanting");
    }

    @SubscribeEvent
    public void handleIMC(InterModProcessEvent e) {
        e.getIMCStream(ENCH_HARD_CAP_IMC::equals).forEach(msg -> {
            try {
                EnchantmentInstance data = (EnchantmentInstance)msg.messageSupplier().get();
                if (data != null && data.f_44947_ != null && data.f_44948_ > 0) {
                    ENCH_HARD_CAPS.put((Object)data.f_44947_, data.f_44948_);
                } else {
                    LOGGER.error("Failed to process IMC message with method {} from {} (invalid values passed).", (Object)msg.method(), (Object)msg.senderModId());
                }
            }
            catch (Exception ex) {
                LOGGER.error("Exception thrown during IMC message with method {} from {}.", (Object)msg.method(), (Object)msg.senderModId());
                ex.printStackTrace();
            }
        });
    }

    @SubscribeEvent
    public void blocks(RegistryEvent.Register<Block> e) {
        e.getRegistry().registerAll(new Object[]{new ApothAnvilBlock(), new ResourceLocation("minecraft", "anvil"), new ApothAnvilBlock(), new ResourceLocation("minecraft", "chipped_anvil"), new ApothAnvilBlock(), new ResourceLocation("minecraft", "damaged_anvil"), new Block(BlockBehaviour.Properties.m_60939_((Material)Material.f_76278_).m_60978_(1.5f).m_60918_(SoundType.f_56742_)), "hellshelf", new Block(BlockBehaviour.Properties.m_60939_((Material)Material.f_76278_).m_60978_(1.5f).m_60918_(SoundType.f_56742_)), "infused_hellshelf", new Block(BlockBehaviour.Properties.m_60939_((Material)Material.f_76278_).m_60978_(1.5f).m_60918_(SoundType.f_56742_)), "blazing_hellshelf", new Block(BlockBehaviour.Properties.m_60939_((Material)Material.f_76278_).m_60978_(1.5f).m_60918_(SoundType.f_56742_)), "glowing_hellshelf", new Block(BlockBehaviour.Properties.m_60939_((Material)Material.f_76278_).m_60978_(1.5f).m_60918_(SoundType.f_56742_)), "seashelf", new Block(BlockBehaviour.Properties.m_60939_((Material)Material.f_76278_).m_60978_(1.5f).m_60918_(SoundType.f_56742_)), "infused_seashelf", new Block(BlockBehaviour.Properties.m_60939_((Material)Material.f_76278_).m_60978_(1.5f).m_60918_(SoundType.f_56742_)), "crystal_seashelf", new Block(BlockBehaviour.Properties.m_60939_((Material)Material.f_76278_).m_60978_(1.5f).m_60918_(SoundType.f_56742_)), "heart_seashelf", new Block(BlockBehaviour.Properties.m_60939_((Material)Material.f_76278_).m_60978_(1.5f).m_60918_(SoundType.f_56742_)), "endshelf", new Block(BlockBehaviour.Properties.m_60939_((Material)Material.f_76278_).m_60978_(1.5f).m_60918_(SoundType.f_56742_)), "pearl_endshelf", new Block(BlockBehaviour.Properties.m_60939_((Material)Material.f_76278_).m_60978_(1.5f).m_60918_(SoundType.f_56742_)), "draconic_endshelf", new Block(BlockBehaviour.Properties.m_60939_((Material)Material.f_76320_).m_60978_(1.5f).m_60918_(SoundType.f_56736_)), "beeshelf", new Block(BlockBehaviour.Properties.m_60939_((Material)Material.f_76285_).m_60978_(1.5f).m_60918_(SoundType.f_56736_)), "melonshelf", new EnchLibraryBlock((BlockEntityType.BlockEntitySupplier<? extends EnchLibraryTile>)((BlockEntityType.BlockEntitySupplier)EnchLibraryTile.BasicLibraryTile::new), 16), "library", new EnchLibraryBlock((BlockEntityType.BlockEntitySupplier<? extends EnchLibraryTile>)((BlockEntityType.BlockEntitySupplier)EnchLibraryTile.EnderLibraryTile::new), 31), "ender_library", new Block(BlockBehaviour.Properties.m_60939_((Material)Material.f_76278_).m_60978_(1.5f).m_60918_(SoundType.f_56742_)), "rectifier", new Block(BlockBehaviour.Properties.m_60939_((Material)Material.f_76278_).m_60978_(1.5f).m_60918_(SoundType.f_56742_)), "rectifier_t2", new Block(BlockBehaviour.Properties.m_60939_((Material)Material.f_76278_).m_60978_(1.5f).m_60918_(SoundType.f_56742_)), "rectifier_t3", new Block(BlockBehaviour.Properties.m_60939_((Material)Material.f_76278_).m_60978_(1.5f).m_60918_(SoundType.f_56742_)), "sightshelf", new Block(BlockBehaviour.Properties.m_60939_((Material)Material.f_76278_).m_60978_(1.5f).m_60918_(SoundType.f_56742_)), "sightshelf_t2"});
        PlaceboUtil.registerOverride((Block)Blocks.f_50201_, (Block)new ApothEnchantBlock(), (String)"apotheosis");
    }

    @SubscribeEvent
    public void items(RegistryEvent.Register<Item> e) {
        e.getRegistry().registerAll(new Object[]{new Item(new Item.Properties().m_41491_(Apotheosis.APOTH_GROUP)), "prismatic_web", new ApothAnvilItem(Blocks.f_50322_), new ResourceLocation("minecraft", "anvil"), new ApothAnvilItem(Blocks.f_50323_), new ResourceLocation("minecraft", "chipped_anvil"), new ApothAnvilItem(Blocks.f_50324_), new ResourceLocation("minecraft", "damaged_anvil"), new TomeItem(Items.f_41852_, null), "other_tome", new TomeItem(Items.f_42472_, EnchantmentCategory.ARMOR_HEAD), "helmet_tome", new TomeItem(Items.f_42473_, EnchantmentCategory.ARMOR_CHEST), "chestplate_tome", new TomeItem(Items.f_42474_, EnchantmentCategory.ARMOR_LEGS), "leggings_tome", new TomeItem(Items.f_42475_, EnchantmentCategory.ARMOR_FEET), "boots_tome", new TomeItem(Items.f_42388_, EnchantmentCategory.WEAPON), "weapon_tome", new TomeItem(Items.f_42390_, EnchantmentCategory.DIGGER), "pickaxe_tome", new TomeItem(Items.f_42523_, EnchantmentCategory.FISHING_ROD), "fishing_tome", new TomeItem(Items.f_42411_, EnchantmentCategory.BOW), "bow_tome", new ScrappingTomeItem(), "scrap_tome", new BlockItem((Block)Apoth.Blocks.HELLSHELF.get(), new Item.Properties().m_41491_(Apotheosis.APOTH_GROUP)), "hellshelf", new GlowyBlockItem((Block)Apoth.Blocks.INFUSED_HELLSHELF.get(), new Item.Properties().m_41491_(Apotheosis.APOTH_GROUP)), "infused_hellshelf", new BlockItem((Block)Apoth.Blocks.BLAZING_HELLSHELF.get(), new Item.Properties().m_41491_(Apotheosis.APOTH_GROUP)), "blazing_hellshelf", new BlockItem((Block)Apoth.Blocks.GLOWING_HELLSHELF.get(), new Item.Properties().m_41491_(Apotheosis.APOTH_GROUP)), "glowing_hellshelf", new BlockItem((Block)Apoth.Blocks.SEASHELF.get(), new Item.Properties().m_41491_(Apotheosis.APOTH_GROUP)), "seashelf", new GlowyBlockItem((Block)Apoth.Blocks.INFUSED_SEASHELF.get(), new Item.Properties().m_41491_(Apotheosis.APOTH_GROUP)), "infused_seashelf", new BlockItem((Block)Apoth.Blocks.CRYSTAL_SEASHELF.get(), new Item.Properties().m_41491_(Apotheosis.APOTH_GROUP)), "crystal_seashelf", new BlockItem((Block)Apoth.Blocks.HEART_SEASHELF.get(), new Item.Properties().m_41491_(Apotheosis.APOTH_GROUP)), "heart_seashelf", new BlockItem((Block)Apoth.Blocks.ENDSHELF.get(), new Item.Properties().m_41491_(Apotheosis.APOTH_GROUP)), "endshelf", new BlockItem((Block)Apoth.Blocks.DRACONIC_ENDSHELF.get(), new Item.Properties().m_41491_(Apotheosis.APOTH_GROUP)), "draconic_endshelf", new BlockItem((Block)Apoth.Blocks.PEARL_ENDSHELF.get(), new Item.Properties().m_41491_(Apotheosis.APOTH_GROUP)), "pearl_endshelf", new BlockItem((Block)Apoth.Blocks.BEESHELF.get(), new Item.Properties().m_41491_(Apotheosis.APOTH_GROUP)), "beeshelf", new BlockItem((Block)Apoth.Blocks.MELONSHELF.get(), new Item.Properties().m_41491_(Apotheosis.APOTH_GROUP)), "melonshelf", new BlockItem((Block)Apoth.Blocks.LIBRARY.get(), new Item.Properties().m_41491_(Apotheosis.APOTH_GROUP)), "library", new BlockItem((Block)Apoth.Blocks.RECTIFIER.get(), new Item.Properties().m_41491_(Apotheosis.APOTH_GROUP)), "rectifier", new BlockItem((Block)Apoth.Blocks.RECTIFIER_T2.get(), new Item.Properties().m_41491_(Apotheosis.APOTH_GROUP)), "rectifier_t2", new BlockItem((Block)Apoth.Blocks.RECTIFIER_T3.get(), new Item.Properties().m_41491_(Apotheosis.APOTH_GROUP)), "rectifier_t3", new BlockItem((Block)Apoth.Blocks.SIGHTSHELF.get(), new Item.Properties().m_41491_(Apotheosis.APOTH_GROUP)), "sightshelf", new BlockItem((Block)Apoth.Blocks.SIGHTSHELF_T2.get(), new Item.Properties().m_41491_(Apotheosis.APOTH_GROUP)), "sightshelf_t2", new Item(new Item.Properties().m_41487_(1).m_41491_(Apotheosis.APOTH_GROUP)), "inert_trident", new BlockItem((Block)Apoth.Blocks.ENDER_LIBRARY.get(), new Item.Properties().m_41491_(Apotheosis.APOTH_GROUP)), "ender_library", new ImprovedScrappingTomeItem(), "improved_scrap_tome", new ExtractionTomeItem(), "extraction_tome"});
    }

    @SubscribeEvent
    public void enchants(RegistryEvent.Register<Enchantment> e) {
        e.getRegistry().registerAll(new Object[]{new MinersFervorEnchant(), "miners_fervor", new StableFootingEnchant(), "stable_footing", new ScavengerEnchant(), "scavenger", new LifeMendingEnchant(), "life_mending", new IcyThornsEnchant(), "icy_thorns", new TemptingEnchant(), "tempting", new ShieldBashEnchant(), "shield_bash", new ReflectiveEnchant(), "reflective", new BerserkersFuryEnchant(), "berserkers_fury", new KnowledgeEnchant(), "knowledge", new SplittingEnchant(), "splitting", new NaturesBlessingEnchant(), "natures_blessing", new ReboundingEnchant(), "rebounding", new BaneEnchant(Enchantment.Rarity.UNCOMMON, MobType.f_21642_, EquipmentSlot.MAINHAND), new ResourceLocation("minecraft", "bane_of_arthropods"), new BaneEnchant(Enchantment.Rarity.UNCOMMON, MobType.f_21641_, EquipmentSlot.MAINHAND), new ResourceLocation("minecraft", "smite"), new BaneEnchant(Enchantment.Rarity.COMMON, MobType.f_21640_, EquipmentSlot.MAINHAND), new ResourceLocation("minecraft", "sharpness"), new BaneEnchant(Enchantment.Rarity.UNCOMMON, MobType.f_21643_, EquipmentSlot.MAINHAND), "bane_of_illagers", new DefenseEnchant(Enchantment.Rarity.COMMON, ProtectionEnchantment.Type.ALL, ARMOR), new ResourceLocation("minecraft", "protection"), new DefenseEnchant(Enchantment.Rarity.UNCOMMON, ProtectionEnchantment.Type.FIRE, ARMOR), new ResourceLocation("minecraft", "fire_protection"), new DefenseEnchant(Enchantment.Rarity.RARE, ProtectionEnchantment.Type.EXPLOSION, ARMOR), new ResourceLocation("minecraft", "blast_protection"), new DefenseEnchant(Enchantment.Rarity.UNCOMMON, ProtectionEnchantment.Type.PROJECTILE, ARMOR), new ResourceLocation("minecraft", "projectile_protection"), new DefenseEnchant(Enchantment.Rarity.UNCOMMON, ProtectionEnchantment.Type.FALL, EquipmentSlot.FEET), new ResourceLocation("minecraft", "feather_falling"), new ObliterationEnchant(), "obliteration", new CrescendoEnchant(), "crescendo", new InertEnchantment(), "infusion", new EndlessQuiverEnchant(), "endless_quiver", new ChromaticEnchant(), "chromatic", new ExploitationEnchant(), "exploitation", new GrowthSerumEnchant(), "growth_serum", new EarthsBoonEnchant(), "earths_boon", new ChainsawEnchant(), "chainsaw", new SpearfishingEnchant(), "spearfishing"});
    }

    public static EnchantmentInfo getEnchInfo(Enchantment ench) {
        if (!Apotheosis.enableEnch) {
            return ENCHANTMENT_INFO.computeIfAbsent(ench, EnchantmentInfo::new);
        }
        EnchantmentInfo info = ENCHANTMENT_INFO.get(ench);
        if (enchInfoConfig == null) {
            return new EnchantmentInfo(ench);
        }
        if (info == null) {
            info = EnchantmentInfo.load(ench, enchInfoConfig);
            ENCHANTMENT_INFO.put(ench, info);
            if (enchInfoConfig.hasChanged()) {
                enchInfoConfig.save();
            }
            LOGGER.error("Had to late load enchantment info for {}, this is a bug in the mod {} as they are registering late!", (Object)ForgeRegistries.ENCHANTMENTS.getKey((Object)ench), (Object)ForgeRegistries.ENCHANTMENTS.getKey((Object)ench).m_135827_());
        }
        return info;
    }

    public static int getDefaultMax(Enchantment ench) {
        int level = ench.m_6586_();
        if (level == 1) {
            return 1;
        }
        EnchantmentInfo.PowerFunc minFunc = EnchantmentInfo.defaultMin(ench);
        int max = (int)(EnchantingStatManager.getAbsoluteMaxEterna() * 4.0f);
        int minPower = minFunc.getPower(level);
        if (minPower >= max) {
            return level;
        }
        int lastPower = minPower;
        while (minPower < max) {
            if (lastPower == (minPower = minFunc.getPower(++level))) {
                return level;
            }
            if (minPower > max) {
                return level - 1;
            }
            lastPower = minPower;
        }
        return level;
    }

    public void reload(Apotheosis.ApotheosisReloadEvent e) {
        enchInfoConfig = new Configuration(new File(Apotheosis.configDir, "enchantments.cfg"));
        enchInfoConfig.setTitle("Apotheosis Enchantment Information");
        enchInfoConfig.setComment("This file contains configurable data for each enchantment.\nThe names of each category correspond to the registry names of every loaded enchantment.");
        ENCHANTMENT_INFO.clear();
        for (Enchantment ench : ForgeRegistries.ENCHANTMENTS) {
            ENCHANTMENT_INFO.put(ench, EnchantmentInfo.load(ench, enchInfoConfig));
        }
        for (Enchantment ench : ForgeRegistries.ENCHANTMENTS) {
            EnchantmentInfo info = ENCHANTMENT_INFO.get(ench);
            for (int i = 1; i <= info.getMaxLevel(); ++i) {
                if (info.getMinPower(i) <= info.getMaxPower(i)) continue;
                LOGGER.warn("Enchantment {} has min/max power {}/{} at level {}, making this level unobtainable.", (Object)ForgeRegistries.ENCHANTMENTS.getKey((Object)ench), (Object)info.getMinPower(i), (Object)info.getMaxPower(i), (Object)i);
            }
        }
        if (e == null && enchInfoConfig.hasChanged()) {
            enchInfoConfig.save();
        }
    }
}

