/*
 * Decompiled with CFR 0.152.
 */
package shadows.apotheosis.adventure.loot;

import com.mojang.datafixers.kinds.App;
import com.mojang.datafixers.kinds.Applicative;
import com.mojang.serialization.Codec;
import com.mojang.serialization.codecs.RecordCodecBuilder;
import java.util.Optional;
import java.util.Set;
import javax.annotation.Nullable;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.world.item.ItemStack;
import shadows.apotheosis.adventure.compat.GameStagesCompat;
import shadows.apotheosis.adventure.loot.LootCategory;
import shadows.apotheosis.adventure.loot.LootRarity;
import shadows.placebo.codec.PlaceboCodecs;
import shadows.placebo.json.ItemAdapter;
import shadows.placebo.json.PSerializer;
import shadows.placebo.json.TypeKeyed;
import shadows.placebo.json.WeightedJsonReloadListener;

public final class AffixLootEntry
extends TypeKeyed.TypeKeyedBase<AffixLootEntry>
implements WeightedJsonReloadListener.ILuckyWeighted,
WeightedJsonReloadListener.IDimensional,
LootRarity.Clamped,
GameStagesCompat.IStaged {
    public static final Codec<AffixLootEntry> CODEC = RecordCodecBuilder.create(inst -> inst.group((App)Codec.intRange((int)0, (int)Integer.MAX_VALUE).fieldOf("weight").forGetter(WeightedJsonReloadListener.ILuckyWeighted::getWeight), (App)Codec.floatRange((float)0.0f, (float)Float.MAX_VALUE).optionalFieldOf("quality", (Object)Float.valueOf(0.0f)).forGetter(WeightedJsonReloadListener.ILuckyWeighted::getQuality), (App)ItemAdapter.CODEC.fieldOf("stack").forGetter(a -> a.stack), (App)PlaceboCodecs.setCodec((Codec)ResourceLocation.f_135803_).fieldOf("dimensions").forGetter(a -> a.dimensions), (App)LootRarity.CODEC.optionalFieldOf("min_rarity", (Object)LootRarity.COMMON).forGetter(a -> a.minRarity), (App)LootRarity.CODEC.optionalFieldOf("max_rarity", (Object)LootRarity.MYTHIC).forGetter(a -> a.maxRarity), (App)PlaceboCodecs.setCodec((Codec)Codec.STRING).optionalFieldOf("stages").forGetter(a -> Optional.ofNullable(a.stages))).apply((Applicative)inst, AffixLootEntry::new));
    public static final PSerializer<AffixLootEntry> SERIALIZER = PSerializer.fromCodec((String)"Affix Loot Entry", CODEC);
    protected final int weight;
    protected final float quality;
    protected final ItemStack stack;
    protected final Set<ResourceLocation> dimensions;
    protected final LootRarity minRarity;
    protected final LootRarity maxRarity;
    @Nullable
    protected final Set<String> stages;

    public AffixLootEntry(int weight, float quality, ItemStack stack, Set<ResourceLocation> dimensions, LootRarity min, LootRarity max, Optional<Set<String>> stages) {
        this.weight = weight;
        this.quality = quality;
        this.stack = stack;
        this.dimensions = dimensions;
        this.minRarity = min;
        this.maxRarity = max;
        this.stages = stages.orElse(null);
    }

    public AffixLootEntry(int weight, float quality, ItemStack stack, Set<ResourceLocation> dimensions, LootRarity min, LootRarity max) {
        this(weight, quality, stack, dimensions, min, max, Optional.empty());
    }

    public int getWeight() {
        return this.weight;
    }

    public float getQuality() {
        return this.quality;
    }

    public ItemStack getStack() {
        return this.stack.m_41777_();
    }

    public Set<ResourceLocation> getDimensions() {
        return this.dimensions;
    }

    @Override
    public LootRarity getMinRarity() {
        return this.minRarity;
    }

    @Override
    public LootRarity getMaxRarity() {
        return this.maxRarity;
    }

    public LootCategory getType() {
        return LootCategory.forItem(this.stack);
    }

    @Override
    public Set<String> getStages() {
        return this.stages;
    }

    public PSerializer<? extends AffixLootEntry> getSerializer() {
        return SERIALIZER;
    }
}

