/*
 * Decompiled with CFR 0.152.
 */
package shadows.apotheosis.adventure.client;

import com.mojang.blaze3d.systems.RenderSystem;
import com.mojang.blaze3d.vertex.PoseStack;
import com.mojang.math.Matrix4f;
import java.util.List;
import java.util.Objects;
import net.minecraft.client.Minecraft;
import net.minecraft.client.gui.Font;
import net.minecraft.client.gui.GuiComponent;
import net.minecraft.client.gui.screens.inventory.tooltip.ClientTooltipComponent;
import net.minecraft.client.renderer.GameRenderer;
import net.minecraft.client.renderer.MultiBufferSource;
import net.minecraft.client.renderer.entity.ItemRenderer;
import net.minecraft.network.chat.Component;
import net.minecraft.network.chat.FormattedText;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.world.inventory.tooltip.TooltipComponent;
import net.minecraft.world.item.ItemStack;
import shadows.apotheosis.adventure.affix.socket.gem.Gem;
import shadows.apotheosis.adventure.affix.socket.gem.GemItem;

public class SocketTooltipRenderer
implements ClientTooltipComponent {
    public static final ResourceLocation SOCKET = new ResourceLocation("apotheosis", "textures/gui/socket.png");
    private final SocketComponent comp;
    private final int spacing;

    public SocketTooltipRenderer(SocketComponent comp) {
        Objects.requireNonNull(Minecraft.m_91087_().f_91062_);
        this.spacing = 9 + 2;
        this.comp = comp;
    }

    public int m_142103_() {
        return this.spacing * this.comp.gems.size();
    }

    public int m_142069_(Font font) {
        int maxWidth = 0;
        for (ItemStack gem : this.comp.gems) {
            maxWidth = Math.max(maxWidth, font.m_92852_((FormattedText)SocketTooltipRenderer.getSocketDesc(this.comp.socketed, gem)) + 12);
        }
        return maxWidth;
    }

    public void m_183452_(Font pFont, int x, int y, PoseStack stack, ItemRenderer itemRenderer, int pBlitOffset) {
        RenderSystem.m_157427_(GameRenderer::m_172817_);
        RenderSystem.m_157429_((float)1.0f, (float)1.0f, (float)1.0f, (float)1.0f);
        RenderSystem.m_157456_((int)0, (ResourceLocation)SOCKET);
        for (int i = 0; i < this.comp.gems.size(); ++i) {
            GuiComponent.m_93143_((PoseStack)stack, (int)x, (int)(y + this.spacing * i), (int)pBlitOffset, (float)0.0f, (float)0.0f, (int)9, (int)9, (int)9, (int)9);
        }
        for (ItemStack gem : this.comp.gems()) {
            if (!gem.m_41619_()) {
                PoseStack mvStack = RenderSystem.m_157191_();
                mvStack.m_85836_();
                mvStack.m_85841_(0.5f, 0.5f, 1.0f);
                itemRenderer.m_115218_(gem, 2 * x + 1, 2 * y + 1);
                mvStack.m_85849_();
                RenderSystem.m_157182_();
            }
            y += this.spacing;
        }
    }

    public void m_142440_(Font pFont, int pX, int pY, Matrix4f pMatrix4f, MultiBufferSource.BufferSource pBufferSource) {
        for (int i = 0; i < this.comp.gems.size(); ++i) {
            pFont.m_92841_(SocketTooltipRenderer.getSocketDesc(this.comp.socketed, this.comp.gems.get(i)), (float)(pX + 12), (float)(pY + 1 + this.spacing * i), 0xAABBCC, true, pMatrix4f, (MultiBufferSource)pBufferSource, false, 0, 0xF000F0);
        }
    }

    public static Component getSocketDesc(ItemStack socketed, ItemStack gemStack) {
        Gem gem = GemItem.getGem(gemStack);
        if (gem == null) {
            return Component.m_237115_((String)"socket.apotheosis.empty");
        }
        return gem.getSocketBonusTooltip(socketed, gemStack, GemItem.getLootRarity(gemStack), GemItem.getFacets(gemStack));
    }

    public record SocketComponent(ItemStack socketed, List<ItemStack> gems) implements TooltipComponent
    {
    }
}

