/*
 * Decompiled with CFR 0.152.
 */
package shadows.apotheosis.adventure.client;

import com.google.common.collect.Multimap;
import com.google.common.collect.TreeMultimap;
import com.mojang.blaze3d.vertex.BufferBuilder;
import com.mojang.blaze3d.vertex.DefaultVertexFormat;
import com.mojang.blaze3d.vertex.PoseStack;
import com.mojang.blaze3d.vertex.Tesselator;
import com.mojang.blaze3d.vertex.VertexConsumer;
import com.mojang.blaze3d.vertex.VertexFormat;
import com.mojang.datafixers.util.Either;
import com.mojang.math.Vector3f;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Comparator;
import java.util.HashMap;
import java.util.HashSet;
import java.util.LinkedList;
import java.util.List;
import java.util.ListIterator;
import java.util.Map;
import java.util.Optional;
import java.util.Set;
import java.util.UUID;
import java.util.function.BiFunction;
import java.util.function.Consumer;
import javax.annotation.Nullable;
import net.minecraft.ChatFormatting;
import net.minecraft.Util;
import net.minecraft.client.Minecraft;
import net.minecraft.client.gui.screens.MenuScreens;
import net.minecraft.client.gui.screens.Screen;
import net.minecraft.client.player.LocalPlayer;
import net.minecraft.client.renderer.MultiBufferSource;
import net.minecraft.client.renderer.RenderStateShard;
import net.minecraft.client.renderer.RenderType;
import net.minecraft.client.renderer.blockentity.BeaconRenderer;
import net.minecraft.client.renderer.blockentity.BlockEntityRenderers;
import net.minecraft.client.resources.model.BakedModel;
import net.minecraft.client.resources.model.ModelResourceLocation;
import net.minecraft.client.resources.sounds.SimpleSoundInstance;
import net.minecraft.client.resources.sounds.SoundInstance;
import net.minecraft.core.BlockPos;
import net.minecraft.network.chat.Component;
import net.minecraft.network.chat.ComponentContents;
import net.minecraft.network.chat.MutableComponent;
import net.minecraft.network.chat.Style;
import net.minecraft.network.chat.TextColor;
import net.minecraft.network.chat.contents.LiteralContents;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.sounds.SoundEvents;
import net.minecraft.sounds.SoundSource;
import net.minecraft.util.Mth;
import net.minecraft.world.entity.EquipmentSlot;
import net.minecraft.world.entity.MobType;
import net.minecraft.world.entity.ai.attributes.Attribute;
import net.minecraft.world.entity.ai.attributes.AttributeModifier;
import net.minecraft.world.entity.ai.attributes.Attributes;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.inventory.MenuType;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.Items;
import net.minecraft.world.item.enchantment.Enchantment;
import net.minecraft.world.item.enchantment.EnchantmentHelper;
import net.minecraft.world.level.block.entity.BlockEntityType;
import net.minecraft.world.phys.Vec3;
import net.minecraftforge.api.distmarker.Dist;
import net.minecraftforge.client.event.ModelEvent;
import net.minecraftforge.client.event.RegisterClientTooltipComponentFactoriesEvent;
import net.minecraftforge.client.event.RenderLevelStageEvent;
import net.minecraftforge.client.event.RenderTooltipEvent;
import net.minecraftforge.client.model.geometry.IGeometryLoader;
import net.minecraftforge.common.MinecraftForge;
import net.minecraftforge.event.TickEvent;
import net.minecraftforge.event.entity.player.ItemTooltipEvent;
import net.minecraftforge.eventbus.api.EventPriority;
import net.minecraftforge.eventbus.api.SubscribeEvent;
import net.minecraftforge.fml.ModList;
import net.minecraftforge.fml.common.Mod;
import net.minecraftforge.registries.ForgeRegistries;
import org.apache.commons.lang3.mutable.MutableInt;
import shadows.apotheosis.Apoth;
import shadows.apotheosis.Apotheosis;
import shadows.apotheosis.adventure.AdventureConfig;
import shadows.apotheosis.adventure.AdventureModule;
import shadows.apotheosis.adventure.affix.Affix;
import shadows.apotheosis.adventure.affix.AffixHelper;
import shadows.apotheosis.adventure.affix.AffixInstance;
import shadows.apotheosis.adventure.affix.reforging.ReforgingScreen;
import shadows.apotheosis.adventure.affix.reforging.ReforgingTableTileRenderer;
import shadows.apotheosis.adventure.affix.salvaging.SalvagingScreen;
import shadows.apotheosis.adventure.affix.socket.SocketHelper;
import shadows.apotheosis.adventure.affix.socket.gem.GemItem;
import shadows.apotheosis.adventure.affix.socket.gem.cutting.GemCuttingScreen;
import shadows.apotheosis.adventure.client.BossSpawnMessage;
import shadows.apotheosis.adventure.client.FItemLayerModel;
import shadows.apotheosis.adventure.client.GemModel;
import shadows.apotheosis.adventure.client.SocketTooltipRenderer;
import shadows.apotheosis.util.ItemAccess;

public class AdventureModuleClient {
    public static List<BossSpawnMessage.BossSpawnData> BOSS_SPAWNS = new ArrayList<BossSpawnMessage.BossSpawnData>();

    public static void init() {
        MinecraftForge.EVENT_BUS.register(AdventureModuleClient.class);
        MenuScreens.m_96206_((MenuType)((MenuType)Apoth.Menus.REFORGING.get()), ReforgingScreen::new);
        MenuScreens.m_96206_((MenuType)((MenuType)Apoth.Menus.SALVAGE.get()), SalvagingScreen::new);
        MenuScreens.m_96206_((MenuType)((MenuType)Apoth.Menus.GEM_CUTTING.get()), GemCuttingScreen::new);
        BlockEntityRenderers.m_173590_((BlockEntityType)((BlockEntityType)Apoth.Tiles.REFORGING_TABLE.get()), k -> new ReforgingTableTileRenderer());
    }

    public static void onBossSpawn(BlockPos pos, float[] color) {
        BOSS_SPAWNS.add(new BossSpawnMessage.BossSpawnData(pos, color, new MutableInt()));
        Minecraft.m_91087_().m_91106_().m_120367_((SoundInstance)new SimpleSoundInstance(SoundEvents.f_11860_, SoundSource.HOSTILE, AdventureConfig.bossAnnounceVolume, 1.25f, Minecraft.m_91087_().f_91074_.f_19796_, Minecraft.m_91087_().f_91074_.m_20183_()));
    }

    @SubscribeEvent
    public static void render(RenderLevelStageEvent e) {
        if (e.getStage() != RenderLevelStageEvent.Stage.AFTER_TRIPWIRE_BLOCKS) {
            return;
        }
        PoseStack stack = e.getPoseStack();
        MultiBufferSource.BufferSource buf = MultiBufferSource.m_109898_((BufferBuilder)Tesselator.m_85913_().m_85915_());
        LocalPlayer p = Minecraft.m_91087_().f_91074_;
        for (int i = 0; i < BOSS_SPAWNS.size(); ++i) {
            BossSpawnMessage.BossSpawnData data = BOSS_SPAWNS.get(i);
            stack.m_85836_();
            float partials = e.getPartialTick();
            Vec3 vec = Minecraft.m_91087_().m_91288_().m_20299_(partials);
            stack.m_85837_(-vec.f_82479_, -vec.f_82480_, -vec.f_82481_);
            stack.m_85837_((double)data.pos().m_123341_(), (double)data.pos().m_123342_(), (double)data.pos().m_123343_());
            BeaconRenderer.m_112184_((PoseStack)stack, (MultiBufferSource)buf, (ResourceLocation)BeaconRenderer.f_112102_, (float)partials, (float)1.0f, (long)p.f_19853_.m_46467_(), (int)0, (int)64, (float[])data.color(), (float)0.166f, (float)0.33f);
            stack.m_85849_();
        }
        buf.m_109911_();
    }

    @SubscribeEvent
    public static void time(TickEvent.ClientTickEvent e) {
        if (e.phase != TickEvent.Phase.END) {
            return;
        }
        for (int i = 0; i < BOSS_SPAWNS.size(); ++i) {
            BossSpawnMessage.BossSpawnData data = BOSS_SPAWNS.get(i);
            if (data.ticks().getAndIncrement() <= 400) continue;
            BOSS_SPAWNS.remove(i--);
        }
    }

    @SubscribeEvent(priority=EventPriority.HIGHEST)
    public static void tooltips(ItemTooltipEvent e) {
        ItemStack stack = e.getItemStack();
        List list = e.getToolTip();
        int markIdx1 = -1;
        int markIdx2 = -1;
        for (int i = 0; i < list.size(); ++i) {
            ComponentContents componentContents = ((Component)list.get(i)).m_214077_();
            if (!(componentContents instanceof LiteralContents)) continue;
            LiteralContents tc = (LiteralContents)componentContents;
            if (tc.f_237368_().equals("APOTH_REMOVE_MARKER")) {
                markIdx1 = i;
            }
            if (!tc.f_237368_().equals("APOTH_REMOVE_MARKER_2")) continue;
            markIdx2 = i;
            break;
        }
        if (markIdx1 == -1 || markIdx2 == -1) {
            return;
        }
        ListIterator<MutableComponent> it = list.listIterator(markIdx1);
        for (int i = markIdx1; i < markIdx2 + 1; ++i) {
            it.next();
            it.remove();
        }
        int flags = AdventureModuleClient.getHideFlags(stack);
        if (AdventureModuleClient.shouldShowInTooltip(flags, ItemStack.TooltipPart.MODIFIERS)) {
            AdventureModuleClient.applyModifierTooltips(e.getEntity(), stack, it::add);
        }
        if (AffixHelper.getAffixes(stack).containsKey(Apoth.Affixes.SOCKET.get())) {
            it.add(Component.m_237113_((String)"APOTH_REMOVE_MARKER"));
        }
    }

    @SubscribeEvent
    public static void comps(RenderTooltipEvent.GatherComponents e) {
        AffixInstance socket = AffixHelper.getAffixes(e.getItemStack()).get(Apoth.Affixes.SOCKET.get());
        if (socket == null) {
            return;
        }
        List list = e.getTooltipElements();
        int rmvIdx = -1;
        for (int i = 0; i < list.size(); ++i) {
            LiteralContents tc;
            Component comp;
            Object object;
            Optional o = ((Either)list.get(i)).left();
            if (!o.isPresent() || !((object = o.get()) instanceof Component) || !((object = (comp = (Component)object).m_214077_()) instanceof LiteralContents) || !(tc = (LiteralContents)object).f_237368_().equals("APOTH_REMOVE_MARKER")) continue;
            rmvIdx = i;
            list.remove(i);
            break;
        }
        if (rmvIdx == -1) {
            return;
        }
        int size = (int)socket.level();
        e.getTooltipElements().add(rmvIdx, Either.right((Object)new SocketTooltipRenderer.SocketComponent(e.getItemStack(), SocketHelper.getGems(e.getItemStack(), size))));
    }

    @SubscribeEvent(priority=EventPriority.HIGH)
    public static void affixTooltips(ItemTooltipEvent e) {
        Enchantment ench;
        Map enchMap;
        ItemStack stack = e.getItemStack();
        if (stack.m_41782_()) {
            Map<Affix, AffixInstance> affixes = AffixHelper.getAffixes(stack);
            ArrayList components = new ArrayList();
            affixes.values().stream().sorted(Comparator.comparingInt(a -> a.affix().getType().ordinal())).forEach(inst -> inst.addInformation(components::add));
            e.getToolTip().addAll(1, components);
        }
        if (stack.m_41720_() == Items.f_42690_ && !ModList.get().isLoaded("enchdesc") && (enchMap = EnchantmentHelper.m_44831_((ItemStack)stack)).size() == 1 && ForgeRegistries.ENCHANTMENTS.getKey((Object)(ench = (Enchantment)enchMap.keySet().iterator().next())).m_135827_().equals("apotheosis")) {
            e.getToolTip().add(Component.m_237115_((String)(ench.m_44704_() + ".desc")).m_130940_(ChatFormatting.DARK_GRAY));
        }
    }

    public static Multimap<Attribute, AttributeModifier> sortedMap() {
        return TreeMultimap.create((k1, k2) -> AdventureModuleClient.id(k1).compareTo(AdventureModuleClient.id(k2)), (v1, v2) -> {
            int compOp = Integer.compare(v1.m_22217_().ordinal(), v2.m_22217_().ordinal());
            int compValue = Double.compare(v2.m_22218_(), v1.m_22218_());
            return compOp == 0 ? (compValue == 0 ? v1.m_22209_().compareTo(v2.m_22209_()) : compValue) : compOp;
        });
    }

    private static ResourceLocation id(Attribute attr) {
        return ForgeRegistries.ATTRIBUTES.getKey((Object)attr);
    }

    public static Multimap<Attribute, AttributeModifier> getSortedModifiers(ItemStack stack, EquipmentSlot slot) {
        Multimap unsorted = stack.m_41638_(slot);
        Multimap<Attribute, AttributeModifier> map = AdventureModuleClient.sortedMap();
        for (Map.Entry ent : unsorted.entries()) {
            if (ent.getKey() != null && ent.getValue() != null) {
                map.put((Object)((Attribute)ent.getKey()), (Object)((AttributeModifier)ent.getValue()));
                continue;
            }
            AdventureModule.LOGGER.debug("Detected broken attribute modifier entry on item {}.  Attr={}, Modif={}", (Object)stack, ent.getKey(), ent.getValue());
        }
        return map;
    }

    private static boolean shouldShowInTooltip(int pHideFlags, ItemStack.TooltipPart pPart) {
        return (pHideFlags & pPart.m_41809_()) == 0;
    }

    private static int getHideFlags(ItemStack stack) {
        return stack.m_41782_() && stack.m_41783_().m_128425_("HideFlags", 99) ? stack.m_41783_().m_128451_("HideFlags") : stack.m_41720_().getDefaultTooltipHideFlags(stack);
    }

    private static void applyModifierTooltips(@Nullable Player player, ItemStack stack, Consumer<Component> tooltip) {
        Multimap<Attribute, AttributeModifier> mainhand = AdventureModuleClient.getSortedModifiers(stack, EquipmentSlot.MAINHAND);
        Multimap<Attribute, AttributeModifier> offhand = AdventureModuleClient.getSortedModifiers(stack, EquipmentSlot.OFFHAND);
        Multimap<Attribute, AttributeModifier> dualHand = AdventureModuleClient.sortedMap();
        for (Attribute atr : mainhand.keys()) {
            Collection modifMh = mainhand.get((Object)atr);
            Collection modifOh = offhand.get((Object)atr);
            modifMh.stream().filter(a1 -> modifOh.stream().anyMatch(a2 -> a1.m_22214_().equals(a2.m_22214_()))).forEach(modif -> dualHand.put((Object)atr, modif));
        }
        dualHand.values().forEach(m -> {
            mainhand.values().remove(m);
            offhand.values().removeIf(m1 -> m1.m_22214_().equals(m.m_22214_()));
        });
        int sockets = SocketHelper.getSockets(stack);
        HashSet<UUID> skips = new HashSet<UUID>();
        if (sockets > 0) {
            for (ItemStack gem : SocketHelper.getGems(stack, sockets)) {
                skips.addAll(GemItem.getUUIDs(gem));
            }
        }
        AdventureModuleClient.applyTextFor(player, stack, tooltip, dualHand, "both_hands", skips);
        AdventureModuleClient.applyTextFor(player, stack, tooltip, mainhand, EquipmentSlot.MAINHAND.m_20751_(), skips);
        AdventureModuleClient.applyTextFor(player, stack, tooltip, offhand, EquipmentSlot.OFFHAND.m_20751_(), skips);
        for (EquipmentSlot slot : EquipmentSlot.values()) {
            if (slot.ordinal() < 2) continue;
            Multimap<Attribute, AttributeModifier> modifiers = AdventureModuleClient.getSortedModifiers(stack, slot);
            AdventureModuleClient.applyTextFor(player, stack, tooltip, modifiers, slot.m_20751_(), skips);
        }
    }

    private static MutableComponent padded(String padding, Component comp) {
        return Component.m_237113_((String)padding).m_7220_(comp);
    }

    private static MutableComponent list() {
        return Component.m_237113_((String)" \u2507 ").m_130940_(ChatFormatting.GRAY);
    }

    /*
     * WARNING - void declaration
     */
    private static void applyTextFor(@Nullable Player player, ItemStack stack, Consumer<Component> tooltip, Multimap<Attribute, AttributeModifier> modifierMap, String group, Set<UUID> skips) {
        if (!modifierMap.isEmpty()) {
            Object text;
            double amt;
            double rawBase;
            modifierMap.values().removeIf(m -> skips.contains(m.m_22209_()));
            tooltip.accept((Component)Component.m_237119_());
            tooltip.accept((Component)Component.m_237115_((String)("item.modifiers." + group)).m_130940_(ChatFormatting.GRAY));
            if (modifierMap.isEmpty()) {
                return;
            }
            AttributeModifier baseAD = null;
            AttributeModifier baseAS = null;
            ArrayList<AttributeModifier> dmgModifs = new ArrayList<AttributeModifier>();
            ArrayList<AttributeModifier> spdModifs = new ArrayList<AttributeModifier>();
            for (AttributeModifier modif2 : modifierMap.get((Object)Attributes.f_22281_)) {
                if (modif2.m_22209_() == ItemAccess.getBaseAD()) {
                    baseAD = modif2;
                    continue;
                }
                dmgModifs.add(modif2);
            }
            for (AttributeModifier modif2 : modifierMap.get((Object)Attributes.f_22283_)) {
                if (modif2.m_22209_() == ItemAccess.getBaseAS()) {
                    baseAS = modif2;
                    continue;
                }
                spdModifs.add(modif2);
            }
            if (baseAD != null) {
                double base;
                rawBase = base = baseAD.m_22218_() + (player == null ? 0.0 : player.m_21172_(Attributes.f_22281_));
                amt = base;
                for (AttributeModifier attributeModifier : dmgModifs) {
                    if (attributeModifier.m_22217_() == AttributeModifier.Operation.ADDITION) {
                        base = amt += attributeModifier.m_22218_();
                        continue;
                    }
                    if (attributeModifier.m_22217_() == AttributeModifier.Operation.MULTIPLY_BASE) {
                        amt += attributeModifier.m_22218_() * base;
                        continue;
                    }
                    amt *= 1.0 + attributeModifier.m_22218_();
                }
                text = Component.m_237110_((String)"attribute.modifier.equals.0", (Object[])new Object[]{ItemStack.f_41584_.format(amt += (double)EnchantmentHelper.m_44833_((ItemStack)stack, (MobType)MobType.f_21640_)), Component.m_237115_((String)Attributes.f_22281_.m_22087_())});
                tooltip.accept((Component)AdventureModuleClient.padded(" ", (Component)text).m_130940_(dmgModifs.isEmpty() ? ChatFormatting.DARK_GREEN : ChatFormatting.GOLD));
                if (Screen.m_96638_() && !dmgModifs.isEmpty()) {
                    text = Component.m_237110_((String)"attribute.modifier.equals.0", (Object[])new Object[]{ItemStack.f_41584_.format(rawBase), Component.m_237115_((String)Attributes.f_22281_.m_22087_())});
                    tooltip.accept((Component)AdventureModuleClient.list().m_7220_((Component)text.m_130940_(ChatFormatting.DARK_GREEN)));
                    for (AttributeModifier modifier : dmgModifs) {
                        tooltip.accept((Component)AdventureModuleClient.list().m_7220_(GemItem.toComponent(Attributes.f_22281_, modifier)));
                    }
                    float f = EnchantmentHelper.m_44833_((ItemStack)stack, (MobType)MobType.f_21640_);
                    if (f > 0.0f) {
                        tooltip.accept((Component)AdventureModuleClient.list().m_7220_((Component)Component.m_237110_((String)"attribute.modifier.plus.0", (Object[])new Object[]{ItemStack.f_41584_.format(f), Component.m_237115_((String)Attributes.f_22281_.m_22087_())}).m_130940_(ChatFormatting.BLUE)));
                    }
                }
            }
            if (baseAS != null) {
                double base;
                rawBase = base = baseAS.m_22218_() + (player == null ? 0.0 : player.m_21172_(Attributes.f_22283_));
                amt = base;
                for (AttributeModifier attributeModifier : spdModifs) {
                    if (attributeModifier.m_22217_() == AttributeModifier.Operation.ADDITION) {
                        base = amt += attributeModifier.m_22218_();
                        continue;
                    }
                    if (attributeModifier.m_22217_() == AttributeModifier.Operation.MULTIPLY_BASE) {
                        amt += attributeModifier.m_22218_() * base;
                        continue;
                    }
                    amt *= 1.0 + attributeModifier.m_22218_();
                }
                text = Component.m_237110_((String)"attribute.modifier.equals.0", (Object[])new Object[]{ItemStack.f_41584_.format(amt), Component.m_237115_((String)Attributes.f_22283_.m_22087_())});
                tooltip.accept((Component)Component.m_237113_((String)" ").m_7220_((Component)text).m_130940_(spdModifs.isEmpty() ? ChatFormatting.DARK_GREEN : ChatFormatting.GOLD));
                if (Screen.m_96638_() && !spdModifs.isEmpty()) {
                    text = Component.m_237110_((String)"attribute.modifier.equals.0", (Object[])new Object[]{ItemStack.f_41584_.format(rawBase), Component.m_237115_((String)Attributes.f_22283_.m_22087_())});
                    tooltip.accept((Component)AdventureModuleClient.list().m_7220_((Component)text.m_130940_(ChatFormatting.DARK_GREEN)));
                    for (AttributeModifier modifier : spdModifs) {
                        tooltip.accept((Component)AdventureModuleClient.list().m_7220_(GemItem.toComponent(Attributes.f_22283_, modifier)));
                    }
                }
            }
            for (Attribute attr : modifierMap.keySet()) {
                if (baseAD != null && attr == Attributes.f_22281_ || baseAS != null && attr == Attributes.f_22283_) continue;
                Collection modifs = modifierMap.get((Object)attr);
                if (modifs.size() > 1) {
                    double[] sums = new double[3];
                    boolean[] merged = new boolean[3];
                    HashMap<AttributeModifier.Operation, List> shiftExpands = new HashMap<AttributeModifier.Operation, List>();
                    for (AttributeModifier attributeModifier : modifs) {
                        if (attributeModifier.m_22218_() == 0.0) continue;
                        if (sums[attributeModifier.m_22217_().ordinal()] != 0.0) {
                            merged[attributeModifier.m_22217_().ordinal()] = true;
                        }
                        int n = attributeModifier.m_22217_().ordinal();
                        sums[n] = sums[n] + attributeModifier.m_22218_();
                        shiftExpands.computeIfAbsent(attributeModifier.m_22217_(), k -> new LinkedList()).add(attributeModifier);
                    }
                    for (int i = 0; i < 3; ++i) {
                        void var17_29;
                        Style style;
                        if (sums[i] == 0.0) continue;
                        String string = "attribute.modifier." + (sums[i] < 0.0 ? "take." : "plus.") + i;
                        if (i != 0) {
                            String string2 = "attribute.modifier.apotheosis." + (sums[i] < 0.0 ? "take." : "plus.") + i;
                        }
                        if (merged[i]) {
                            style = sums[i] < 0.0 ? Style.f_131099_.m_131148_(TextColor.m_131266_((int)16331057)) : Style.f_131099_.m_131148_(TextColor.m_131266_((int)8026873));
                        } else {
                            Style style2 = style = sums[i] < 0.0 ? Style.f_131099_.m_131140_(ChatFormatting.RED) : Style.f_131099_.m_131140_(ChatFormatting.BLUE);
                        }
                        if (sums[i] < 0.0) {
                            int n = i;
                            sums[n] = sums[n] * -1.0;
                        }
                        if (attr == Attributes.f_22278_) {
                            int n = i;
                            sums[n] = sums[n] * 10.0;
                        }
                        tooltip.accept((Component)Component.m_237110_((String)var17_29, (Object[])new Object[]{ItemStack.f_41584_.format(sums[i]), Component.m_237115_((String)attr.m_22087_())}).m_130948_(style));
                        if (!merged[i] || !Screen.m_96638_()) continue;
                        ((List)shiftExpands.get(AttributeModifier.Operation.m_22236_((int)i))).forEach(modif -> tooltip.accept((Component)AdventureModuleClient.list().m_7220_(GemItem.toComponent(attr, modif))));
                    }
                    continue;
                }
                modifs.forEach(m -> {
                    if (m.m_22218_() != 0.0) {
                        tooltip.accept(GemItem.toComponent(attr, m));
                    }
                });
            }
        }
    }

    static final RenderType beaconBeam(ResourceLocation tex, boolean color) {
        return CustomBeacon.BEACON_BEAM.apply(tex, color);
    }

    public static void renderBeaconBeam(PoseStack pPoseStack, MultiBufferSource pBufferSource, ResourceLocation pBeamLocation, float pPartialTick, float pTextureScale, long pGameTime, int pYOffset, int pHeight, float[] pColors, float pBeamRadius, float pGlowRadius) {
        int i = pYOffset + pHeight;
        pPoseStack.m_85836_();
        pPoseStack.m_85837_(0.5, 0.0, 0.5);
        float f = (float)Math.floorMod(pGameTime, 40) + pPartialTick;
        float f1 = pHeight < 0 ? f : -f;
        float f2 = Mth.m_14187_((float)(f1 * 0.2f - (float)Mth.m_14143_((float)(f1 * 0.1f))));
        float f3 = pColors[0];
        float f4 = pColors[1];
        float f5 = pColors[2];
        pPoseStack.m_85836_();
        pPoseStack.m_85845_(Vector3f.f_122225_.m_122240_(f * 2.25f - 45.0f));
        float f6 = 0.0f;
        float f8 = 0.0f;
        float f9 = -pBeamRadius;
        float f12 = -pBeamRadius;
        float f15 = -1.0f + f2;
        float f16 = (float)pHeight * pTextureScale * (0.5f / pBeamRadius) + f15;
        BeaconRenderer.m_112155_((PoseStack)pPoseStack, (VertexConsumer)pBufferSource.m_6299_(AdventureModuleClient.beaconBeam(pBeamLocation, false)), (float)f3, (float)f4, (float)f5, (float)1.0f, (int)pYOffset, (int)i, (float)0.0f, (float)pBeamRadius, (float)pBeamRadius, (float)0.0f, (float)f9, (float)0.0f, (float)0.0f, (float)f12, (float)0.0f, (float)1.0f, (float)f16, (float)f15);
        pPoseStack.m_85849_();
        f6 = -pGlowRadius;
        float f7 = -pGlowRadius;
        f8 = -pGlowRadius;
        f9 = -pGlowRadius;
        f15 = -1.0f + f2;
        f16 = (float)pHeight * pTextureScale + f15;
        BeaconRenderer.m_112155_((PoseStack)pPoseStack, (VertexConsumer)pBufferSource.m_6299_(AdventureModuleClient.beaconBeam(pBeamLocation, true)), (float)f3, (float)f4, (float)f5, (float)0.125f, (int)pYOffset, (int)i, (float)f6, (float)f7, (float)pGlowRadius, (float)f8, (float)f9, (float)pGlowRadius, (float)pGlowRadius, (float)pGlowRadius, (float)0.0f, (float)1.0f, (float)f16, (float)f15);
        pPoseStack.m_85849_();
    }

    private static abstract class CustomBeacon
    extends RenderStateShard {
        static final BiFunction<ResourceLocation, Boolean, RenderType> BEACON_BEAM = Util.m_143821_((p_173224_, p_173225_) -> {
            RenderType.CompositeState rendertype$compositestate = RenderType.CompositeState.m_110628_().m_173292_(f_173068_).m_173290_((RenderStateShard.EmptyTextureStateShard)new RenderStateShard.TextureStateShard(p_173224_, false, false)).m_110685_(p_173225_ != false ? f_110139_ : f_110134_).m_110687_(p_173225_ != false ? f_110115_ : f_110115_).m_110663_(f_110111_).m_110661_(f_110110_).m_110691_(false);
            return RenderType.m_173215_((String)"custom_beacon_beam", (VertexFormat)DefaultVertexFormat.f_85811_, (VertexFormat.Mode)VertexFormat.Mode.QUADS, (int)256, (boolean)false, (boolean)true, (RenderType.CompositeState)rendertype$compositestate);
        });

        public CustomBeacon(String pName, Runnable pSetupState, Runnable pClearState) {
            super(pName, pSetupState, pClearState);
        }
    }

    @Mod.EventBusSubscriber(modid="apotheosis", value={Dist.CLIENT}, bus=Mod.EventBusSubscriber.Bus.MOD)
    public static class ModBusSub {
        @SubscribeEvent
        public static void models(ModelEvent.RegisterAdditional e) {
            e.register(new ResourceLocation("apotheosis", "item/hammer"));
        }

        @SubscribeEvent
        public static void onRegisterGeometryLoaders(ModelEvent.RegisterGeometryLoaders e) {
            e.register("item_layers", (IGeometryLoader)FItemLayerModel.Loader.INSTANCE);
        }

        @SubscribeEvent
        public static void tooltipComps(RegisterClientTooltipComponentFactoriesEvent e) {
            e.register(SocketTooltipRenderer.SocketComponent.class, SocketTooltipRenderer::new);
        }

        @SubscribeEvent
        public static void addGemModels(ModelEvent.RegisterAdditional e) {
            Set locs = Minecraft.m_91087_().m_91098_().m_214159_("models", loc -> loc.m_135827_().equals("apotheosis") && loc.m_135815_().contains("/gems/") && loc.m_135815_().endsWith(".json")).keySet();
            for (ResourceLocation s : locs) {
                String path = s.m_135815_().substring("models/".length(), s.m_135815_().length() - ".json".length());
                e.register(new ResourceLocation("apotheosis", path));
            }
        }

        @SubscribeEvent
        public static void replaceGemModel(ModelEvent.BakingCompleted e) {
            ModelResourceLocation key = new ModelResourceLocation(Apotheosis.loc("gem"), "inventory");
            BakedModel oldModel = (BakedModel)e.getModels().get(key);
            if (oldModel != null) {
                e.getModels().put(key, new GemModel(oldModel, e.getModelBakery()));
            }
        }
    }
}

