/*
 * Decompiled with CFR 0.152.
 */
package shadows.apotheosis.adventure.boss;

import com.google.common.base.Preconditions;
import com.google.common.base.Strings;
import com.mojang.datafixers.kinds.App;
import com.mojang.datafixers.kinds.Applicative;
import com.mojang.serialization.Codec;
import com.mojang.serialization.codecs.RecordCodecBuilder;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Optional;
import java.util.Set;
import java.util.function.Function;
import java.util.stream.Collectors;
import javax.annotation.Nullable;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.nbt.ListTag;
import net.minecraft.network.chat.Component;
import net.minecraft.network.chat.ComponentContents;
import net.minecraft.network.chat.MutableComponent;
import net.minecraft.network.chat.Style;
import net.minecraft.network.chat.contents.TranslatableContents;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.util.ExtraCodecs;
import net.minecraft.util.Mth;
import net.minecraft.util.RandomSource;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.EntityType;
import net.minecraft.world.entity.EquipmentSlot;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.Mob;
import net.minecraft.world.entity.MobSpawnType;
import net.minecraft.world.entity.monster.Creeper;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.enchantment.Enchantment;
import net.minecraft.world.item.enchantment.EnchantmentHelper;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.ServerLevelAccessor;
import net.minecraft.world.phys.Vec3;
import net.minecraftforge.registries.ForgeRegistries;
import shadows.apotheosis.Apotheosis;
import shadows.apotheosis.adventure.AdventureConfig;
import shadows.apotheosis.adventure.AdventureModule;
import shadows.apotheosis.adventure.affix.AffixHelper;
import shadows.apotheosis.adventure.boss.BossArmorManager;
import shadows.apotheosis.adventure.boss.BossItem;
import shadows.apotheosis.adventure.boss.BossStats;
import shadows.apotheosis.adventure.boss.Exclusion;
import shadows.apotheosis.adventure.boss.MinibossManager;
import shadows.apotheosis.adventure.compat.GameStagesCompat;
import shadows.apotheosis.adventure.loot.LootCategory;
import shadows.apotheosis.adventure.loot.LootController;
import shadows.apotheosis.adventure.loot.LootRarity;
import shadows.apotheosis.ench.asm.EnchHooks;
import shadows.apotheosis.util.ChancedEffectInstance;
import shadows.apotheosis.util.GearSet;
import shadows.apotheosis.util.NameHelper;
import shadows.apotheosis.util.SupportingEntity;
import shadows.placebo.codec.PlaceboCodecs;
import shadows.placebo.json.NBTAdapter;
import shadows.placebo.json.PSerializer;
import shadows.placebo.json.RandomAttributeModifier;
import shadows.placebo.json.TypeKeyed;
import shadows.placebo.json.WeightedJsonReloadListener;

public final class MinibossItem
extends TypeKeyed.TypeKeyedBase<MinibossItem>
implements WeightedJsonReloadListener.ILuckyWeighted,
WeightedJsonReloadListener.IDimensional,
GameStagesCompat.IStaged,
MinibossManager.IEntityMatch {
    public static final String NAME_GEN = "use_name_generation";
    public static final Codec<MinibossItem> CODEC = RecordCodecBuilder.create(inst -> inst.group((App)Codec.intRange((int)0, (int)Integer.MAX_VALUE).fieldOf("weight").forGetter(WeightedJsonReloadListener.ILuckyWeighted::getWeight), (App)Codec.floatRange((float)0.0f, (float)Float.MAX_VALUE).optionalFieldOf("quality", (Object)Float.valueOf(0.0f)).forGetter(WeightedJsonReloadListener.ILuckyWeighted::getQuality), (App)ExtraCodecs.f_184349_.fieldOf("chance").forGetter(a -> Float.valueOf(a.chance)), (App)Codec.STRING.optionalFieldOf("name", (Object)"").forGetter(a -> a.name), (App)PlaceboCodecs.setCodec((Codec)ForgeRegistries.ENTITY_TYPES.getCodec()).fieldOf("entities").forGetter(a -> a.entities), (App)BossStats.CODEC.fieldOf("stats").forGetter(a -> a.stats), (App)PlaceboCodecs.setCodec((Codec)Codec.STRING).optionalFieldOf("stages").forGetter(a -> Optional.ofNullable(a.stages)), (App)PlaceboCodecs.setCodec((Codec)ResourceLocation.f_135803_).fieldOf("dimensions").forGetter(a -> a.dimensions), (App)Codec.BOOL.optionalFieldOf("affixed", (Object)false).forGetter(a -> a.affixed), (App)GearSet.SetPredicate.CODEC.listOf().optionalFieldOf("valid_gear_sets", Collections.emptyList()).forGetter(a -> a.gearSets), (App)NBTAdapter.EITHER_CODEC.optionalFieldOf("nbt").forGetter(a -> Optional.ofNullable(a.nbt)), (App)SupportingEntity.CODEC.listOf().optionalFieldOf("supporting_entities", Collections.emptyList()).forGetter(a -> a.support), (App)SupportingEntity.CODEC.optionalFieldOf("mount").forGetter(a -> Optional.ofNullable(a.mount)), (App)Exclusion.CODEC.listOf().optionalFieldOf("exclusions", Collections.emptyList()).forGetter(a -> a.exclusions)).apply((Applicative)inst, MinibossItem::new));
    public static final PSerializer<MinibossItem> SERIALIZER = PSerializer.fromCodec((String)"Apotheotic Miniboss", CODEC);
    protected final int weight;
    protected final float quality;
    protected final float chance;
    protected final String name;
    protected final Set<EntityType<?>> entities;
    protected final BossStats stats;
    @Nullable
    protected final Set<String> stages;
    protected final Set<ResourceLocation> dimensions;
    protected final boolean affixed;
    protected final List<GearSet.SetPredicate> gearSets;
    @Nullable
    protected final CompoundTag nbt;
    protected final List<SupportingEntity> support;
    @Nullable
    protected final SupportingEntity mount;
    protected final List<Exclusion> exclusions;

    public MinibossItem(int weight, float quality, float chance, String name, Set<EntityType<?>> entities, BossStats stats, Optional<Set<String>> stages, Set<ResourceLocation> dimensions, boolean affixed, List<GearSet.SetPredicate> gearSets, Optional<CompoundTag> nbt, List<SupportingEntity> support, Optional<SupportingEntity> mount, List<Exclusion> exclusions) {
        this.weight = weight;
        this.quality = quality;
        this.chance = chance;
        this.name = name;
        this.entities = entities;
        this.stats = stats;
        this.stages = stages.orElse(null);
        this.dimensions = dimensions;
        this.affixed = affixed;
        this.gearSets = gearSets;
        this.nbt = nbt.orElse(null);
        this.support = support;
        this.mount = mount.orElse(null);
        this.exclusions = exclusions;
    }

    public int getWeight() {
        return this.weight;
    }

    public float getQuality() {
        return this.quality;
    }

    public float getChance() {
        return this.chance;
    }

    @Override
    public Set<EntityType<?>> getEntities() {
        return this.entities;
    }

    public void transformMiniboss(ServerLevelAccessor level, Mob mob, RandomSource random, float luck) {
        Vec3 pos = mob.m_20318_(0.0f);
        if (this.nbt != null) {
            mob.m_20258_(this.nbt);
            if (this.nbt.m_128441_("Passengers")) {
                ListTag passengers = this.nbt.m_128437_("Passengers", 10);
                for (int i = 0; i < passengers.size(); ++i) {
                    Entity entity = EntityType.m_20645_((CompoundTag)passengers.m_128728_(i), (Level)level.m_6018_(), Function.identity());
                    if (entity == null) continue;
                    entity.m_7998_((Entity)mob, true);
                }
            }
        }
        mob.m_146884_(pos);
        this.initBoss(random, mob, luck);
        if (this.nbt != null) {
            mob.m_7378_(this.nbt);
        }
        if (this.mount != null) {
            Mob mountedEntity = this.mount.create(mob.m_9236_(), mob.m_20185_() + 0.5, mob.m_20186_(), mob.m_20189_() + 0.5);
            mob.m_7998_((Entity)mountedEntity, true);
            level.m_7967_((Entity)mountedEntity);
        }
        if (this.support != null) {
            for (SupportingEntity support : this.support) {
                Mob supportingMob = support.create(mob.m_9236_(), mob.m_20185_() + 0.5, mob.m_20186_(), mob.m_20189_() + 0.5);
                level.m_7967_((Entity)supportingMob);
            }
        }
    }

    public void initBoss(RandomSource rand, Mob mob, float luck) {
        mob.getPersistentData().m_128379_("apoth.miniboss", true);
        int duration = mob instanceof Creeper ? 6000 : Integer.MAX_VALUE;
        for (ChancedEffectInstance inst : this.stats.effects()) {
            if (!(rand.m_188501_() <= inst.getChance())) continue;
            mob.m_7292_(inst.createInstance(rand, duration));
        }
        for (RandomAttributeModifier modif : this.stats.modifiers()) {
            modif.apply(rand, (LivingEntity)mob);
        }
        mob.f_21345_.f_25345_.removeIf(BossItem.IS_VILLAGER_ATTACK);
        if (NAME_GEN.equals(this.name)) {
            NameHelper.setEntityName(rand, mob);
        } else if (!Strings.isNullOrEmpty((String)this.name)) {
            mob.m_6593_((Component)Component.m_237115_((String)this.name));
        }
        if (mob.m_8077_()) {
            mob.m_20340_(true);
        }
        if (!this.gearSets.isEmpty()) {
            GearSet set = BossArmorManager.INSTANCE.getRandomSet(rand, luck, this.gearSets);
            Preconditions.checkNotNull((Object)((Object)set), (Object)String.format("Failed to find a valid gear set for the miniboss %s.", this.getId()));
            set.apply((LivingEntity)mob);
        }
        int guaranteed = -1;
        if (this.affixed) {
            boolean anyValid = false;
            for (EquipmentSlot t : EquipmentSlot.values()) {
                ItemStack s = mob.m_6844_(t);
                if (s.m_41619_() || LootCategory.forItem(s).isNone()) continue;
                anyValid = true;
                break;
            }
            if (!anyValid) {
                AdventureModule.LOGGER.error("Attempted to affix a miniboss with ID " + this.getId() + " but it is not wearing any affixable items!");
                return;
            }
            guaranteed = rand.m_188503_(6);
            ItemStack temp = mob.m_6844_(EquipmentSlot.values()[guaranteed]);
            while (temp.m_41619_() || LootCategory.forItem(temp) == LootCategory.NONE) {
                guaranteed = rand.m_188503_(6);
                temp = mob.m_6844_(EquipmentSlot.values()[guaranteed]);
            }
            LootRarity rarity = LootRarity.random(rand, luck, AdventureConfig.AFFIX_CONVERT_RARITIES.get(mob.f_19853_.m_46472_().m_135782_()));
            this.modifyBossItem(temp, rand, this.name, luck, rarity);
            mob.m_6593_((Component)((MutableComponent)mob.m_7770_()).m_130948_(Style.f_131099_.m_131148_(rarity.color())));
            mob.m_21409_(EquipmentSlot.values()[guaranteed], 2.0f);
        }
        for (EquipmentSlot s : EquipmentSlot.values()) {
            ItemStack stack = mob.m_6844_(s);
            if (stack.m_41619_() || s.ordinal() == guaranteed || !(rand.m_188501_() < this.stats.enchantChance())) continue;
            this.enchantBossItem(rand, stack, Apotheosis.enableEnch ? this.stats.enchLevels()[0] : this.stats.enchLevels()[1], true);
            mob.m_8061_(s, stack);
        }
        mob.m_21153_(mob.m_21233_());
    }

    public void enchantBossItem(RandomSource rand, ItemStack stack, int level, boolean treasure) {
        List ench = EnchantmentHelper.m_220297_((RandomSource)rand, (ItemStack)stack, (int)level, (boolean)treasure);
        Map<Enchantment, Integer> map = ench.stream().filter(d -> !d.f_44947_.m_6589_()).collect(Collectors.toMap(d -> d.f_44947_, d -> d.f_44948_, Math::max));
        map.putAll(EnchantmentHelper.m_44831_((ItemStack)stack));
        EnchantmentHelper.m_44865_(map, (ItemStack)stack);
    }

    public ItemStack modifyBossItem(ItemStack stack, RandomSource rand, String bossName, float luck, LootRarity rarity) {
        this.enchantBossItem(rand, stack, Apotheosis.enableEnch ? this.stats.enchLevels()[2] : this.stats.enchLevels()[3], true);
        NameHelper.setItemName(rand, stack);
        stack = LootController.createLootItem(stack, LootCategory.forItem(stack), rarity, rand);
        String bossOwnerName = String.format(NameHelper.ownershipFormat, bossName) + " ";
        Component name = AffixHelper.getName(stack);
        ComponentContents componentContents = name.m_214077_();
        if (componentContents instanceof TranslatableContents) {
            TranslatableContents tc = (TranslatableContents)componentContents;
            MutableComponent copy = Component.m_237110_((String)(bossOwnerName + tc.m_237508_()), (Object[])tc.m_237523_()).m_130948_(name.m_7383_());
            AffixHelper.setName(stack, (Component)copy);
        }
        HashMap<Enchantment, Integer> enchMap = new HashMap<Enchantment, Integer>();
        for (Map.Entry entry : EnchantmentHelper.m_44831_((ItemStack)stack).entrySet()) {
            if (entry.getKey() == null) continue;
            enchMap.put((Enchantment)entry.getKey(), Math.min(EnchHooks.getMaxLevel((Enchantment)entry.getKey()), (Integer)entry.getValue() + rand.m_188503_(2)));
        }
        if (AdventureConfig.curseBossItems) {
            ItemStack stk = stack;
            List list = ForgeRegistries.ENCHANTMENTS.getValues().stream().filter(e -> e.canApplyAtEnchantingTable(stk) && e.m_6589_()).collect(Collectors.toList());
            if (!list.isEmpty()) {
                Enchantment curse = (Enchantment)list.get(rand.m_188503_(list.size()));
                enchMap.put(curse, Mth.m_216271_((RandomSource)rand, (int)1, (int)EnchHooks.getMaxLevel(curse)));
            }
        }
        EnchantmentHelper.m_44865_(enchMap, (ItemStack)stack);
        stack.m_41783_().m_128379_("apoth_boss", true);
        return stack;
    }

    public MinibossItem validate() {
        Preconditions.checkArgument((this.weight >= 0 ? 1 : 0) != 0, (Object)("Miniboss Item " + this.id + " has a negative weight!"));
        Preconditions.checkArgument((this.quality >= 0.0f ? 1 : 0) != 0, (Object)("Miniboss Item " + this.id + " has a negative quality!"));
        Preconditions.checkNotNull(this.entities, (Object)("Miniboss Item " + this.id + " has null entity match list!"));
        Preconditions.checkNotNull((Object)this.stats, (Object)("Miniboss Item " + this.id + " has no stats!"));
        return this;
    }

    public Set<ResourceLocation> getDimensions() {
        return this.dimensions;
    }

    @Override
    public Set<String> getStages() {
        return this.stages;
    }

    public PSerializer<? extends MinibossItem> getSerializer() {
        return SERIALIZER;
    }

    public boolean requiresNbtAccess() {
        return this.exclusions.stream().anyMatch(Exclusion::requiresNbtAccess);
    }

    public boolean isExcluded(Mob mob, ServerLevelAccessor level, MobSpawnType type) {
        CompoundTag tag = this.requiresNbtAccess() ? mob.m_20240_(new CompoundTag()) : null;
        return this.exclusions.stream().anyMatch(ex -> ex.isExcluded(mob, level, type, tag));
    }
}

