/*
 * Decompiled with CFR 0.152.
 */
package shadows.apotheosis.adventure.affix.socket.gem.cutting;

import java.util.ArrayList;
import java.util.List;
import java.util.function.Predicate;
import javax.annotation.Nullable;
import net.minecraft.sounds.SoundEvents;
import net.minecraft.sounds.SoundSource;
import net.minecraft.world.Container;
import net.minecraft.world.entity.player.Inventory;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.inventory.ContainerLevelAccess;
import net.minecraft.world.inventory.MenuType;
import net.minecraft.world.inventory.ResultContainer;
import net.minecraft.world.inventory.Slot;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemStack;
import net.minecraftforge.items.IItemHandlerModifiable;
import net.minecraftforge.items.wrapper.RecipeWrapper;
import shadows.apotheosis.Apoth;
import shadows.apotheosis.adventure.AdventureModule;
import shadows.apotheosis.adventure.affix.socket.gem.GemInstance;
import shadows.apotheosis.adventure.affix.socket.gem.GemItem;
import shadows.apotheosis.adventure.loot.LootRarity;
import shadows.placebo.cap.InternalItemHandler;
import shadows.placebo.container.FilteredSlot;
import shadows.placebo.container.PlaceboContainerMenu;

public class GemCuttingMenu
extends PlaceboContainerMenu {
    public static final List<GemCuttingRecipe> RECIPES = new ArrayList<GemCuttingRecipe>();
    protected final Player player;
    protected final ContainerLevelAccess access;
    protected final InternalItemHandler invSlots = new InternalItemHandler(3);
    protected final ResultContainer result = new ResultContainer();
    protected GemCuttingRecipe recipe;

    public GemCuttingMenu(int id, Inventory inv) {
        this(id, inv, ContainerLevelAccess.f_39287_);
    }

    public GemCuttingMenu(int id, Inventory inv, ContainerLevelAccess access) {
        super((MenuType)Apoth.Menus.GEM_CUTTING.get(), id, inv);
        this.player = inv.f_35978_;
        this.access = access;
        this.m_38897_((Slot)new UpdatingSlot(this.invSlots, 0, 8, 35, stack -> stack.m_41720_() == Apoth.Items.GEM_DUST.get()));
        this.m_38897_((Slot)new UpdatingSlot(this.invSlots, 1, 44, 35, stack -> GemItem.getGem(stack) != null));
        this.m_38897_((Slot)new UpdatingSlot(this.invSlots, 2, 93, 35, this::isValidSecondItem));
        this.m_38897_(new Slot((Container)this.result, 3, 151, 35){

            public void m_142406_(Player pPlayer, ItemStack pStack) {
                super.m_142406_(pPlayer, pStack);
                GemCuttingMenu.this.onCraft();
            }
        });
        this.addPlayerSlots(inv, 8, 84);
        this.mover.registerRule((stack, slot) -> slot == 3, this.playerInvStart, this.hotbarStart + 9);
        this.mover.registerRule((stack, slot) -> slot >= this.playerInvStart && stack.m_41720_() == Apoth.Items.GEM_DUST.get(), 0, 1);
        this.mover.registerRule((stack, slot) -> slot >= this.playerInvStart && GemItem.getGem(stack) != null && this.invSlots.getStackInSlot(1).m_41619_(), 1, 2);
        this.mover.registerRule((stack, slot) -> slot >= this.playerInvStart && this.isValidSecondItem((ItemStack)stack), 2, 3);
        this.mover.registerRule((stack, slot) -> slot < this.playerInvStart, this.playerInvStart, this.hotbarStart + 9);
        this.registerInvShuffleRules();
    }

    public void m_6199_(@Nullable Container pContainer) {
        int dust = this.invSlots.getStackInSlot(0).m_41613_();
        ItemStack gem = this.invSlots.getStackInSlot(1);
        ItemStack catalyst = this.invSlots.getStackInSlot(2);
        for (GemCuttingRecipe r : RECIPES) {
            if (dust < r.getDustCost() || !r.matches(gem, catalyst)) continue;
            this.recipe = r;
            this.result.m_6836_(0, r.getResult(gem, catalyst));
            return;
        }
        this.recipe = null;
        this.result.m_6836_(0, ItemStack.f_41583_);
    }

    public void onQuickMove(ItemStack original, ItemStack remaining, Slot slot) {
        super.onQuickMove(original, remaining, slot);
        if (remaining.m_41619_() && slot.f_40219_ == 3) {
            this.onCraft();
        }
    }

    protected boolean isValidSecondItem(ItemStack stack) {
        ItemStack first = this.m_38853_(1).m_7993_();
        if (first.m_41619_()) {
            return false;
        }
        GemInstance inst = new GemInstance(first);
        if (!inst.isMaxed()) {
            LootRarity rarity = LootRarity.getMaterialRarity(stack);
            return rarity != null && (rarity == inst.rarity() || rarity == inst.rarity().prev());
        }
        GemInstance otherInst = new GemInstance(stack);
        return otherInst.isValid() && otherInst.isMaxed() && otherInst.gem() == inst.gem();
    }

    protected void onCraft() {
        if (this.recipe != null) {
            this.invSlots.getStackInSlot(0).m_41774_(this.recipe.getDustCost());
            this.recipe.decrementInputs(this.invSlots.getStackInSlot(1), this.invSlots.getStackInSlot(2));
            this.level.m_5594_(this.player, this.player.m_20183_(), SoundEvents.f_144242_, SoundSource.BLOCKS, 1.0f, 1.5f + 0.35f * (1.0f - 2.0f * this.level.f_46441_.m_188501_()));
        } else {
            AdventureModule.LOGGER.error("Took an output from the gem cutting table without a set recipe!");
            Thread.dumpStack();
        }
    }

    public boolean m_6875_(Player pPlayer) {
        return (Boolean)this.access.m_39299_((level, pos) -> level.m_8055_(pos).m_60734_() == Apoth.Blocks.GEM_CUTTING_TABLE.get(), (Object)true);
    }

    public void m_6877_(Player pPlayer) {
        super.m_6877_(pPlayer);
        this.access.m_39292_((level, pos) -> this.m_150411_(pPlayer, (Container)new RecipeWrapper((IItemHandlerModifiable)this.invSlots)));
    }

    static {
        RECIPES.add(new StandardCut());
        RECIPES.add(new PrevRarityCut());
        RECIPES.add(new RarityUpgrade());
    }

    protected class UpdatingSlot
    extends FilteredSlot {
        public UpdatingSlot(InternalItemHandler handler, int index, int x, int y, Predicate<ItemStack> filter) {
            super(handler, index, x, y, filter);
        }

        public void m_6654_() {
            super.m_6654_();
            GemCuttingMenu.this.m_6199_(null);
        }
    }

    public static interface GemCuttingRecipe {
        public int getDustCost();

        public boolean matches(ItemStack var1, ItemStack var2);

        public ItemStack getResult(ItemStack var1, ItemStack var2);

        public void decrementInputs(ItemStack var1, ItemStack var2);
    }

    public static class StandardCut
    implements GemCuttingRecipe {
        @Override
        public int getDustCost() {
            return 1;
        }

        @Override
        public boolean matches(ItemStack gem, ItemStack catalyst) {
            GemInstance g = new GemInstance(gem);
            Item rarityMat = catalyst.m_41720_();
            LootRarity matRarity = (LootRarity)AdventureModule.RARITY_MATERIALS.inverse().get((Object)rarityMat);
            return g.isValid() && !g.isMaxed() && matRarity != null && matRarity == g.rarity();
        }

        @Override
        public ItemStack getResult(ItemStack gem, ItemStack catalyst) {
            ItemStack out = gem.m_41777_();
            GemItem.setFacets(out, GemItem.getFacets(out) + 1);
            return out;
        }

        @Override
        public void decrementInputs(ItemStack gem, ItemStack catalyst) {
            gem.m_41774_(1);
            catalyst.m_41774_(1);
        }
    }

    public static class PrevRarityCut
    implements GemCuttingRecipe {
        @Override
        public int getDustCost() {
            return 1;
        }

        @Override
        public boolean matches(ItemStack gem, ItemStack catalyst) {
            GemInstance g = new GemInstance(gem);
            Item rarityMat = catalyst.m_41720_();
            LootRarity matRarity = (LootRarity)AdventureModule.RARITY_MATERIALS.inverse().get((Object)rarityMat);
            return g.isValid() && !g.isMaxed() && matRarity != null && matRarity == g.rarity().prev() && catalyst.m_41613_() >= 4;
        }

        @Override
        public ItemStack getResult(ItemStack gem, ItemStack catalyst) {
            ItemStack out = gem.m_41777_();
            GemItem.setFacets(out, GemItem.getFacets(out) + 1);
            return out;
        }

        @Override
        public void decrementInputs(ItemStack gem, ItemStack catalyst) {
            gem.m_41774_(1);
            catalyst.m_41774_(4);
        }
    }

    public static class RarityUpgrade
    implements GemCuttingRecipe {
        @Override
        public int getDustCost() {
            return 4;
        }

        @Override
        public boolean matches(ItemStack gem, ItemStack catalyst) {
            GemInstance g = new GemInstance(gem);
            GemInstance c = new GemInstance(catalyst);
            return g.isValid() && g.isMaxed() && c.isValid() && c.isMaxed() && g.rarity() != LootRarity.ANCIENT && g.gem() == c.gem() && g.rarity() == c.rarity();
        }

        @Override
        public ItemStack getResult(ItemStack gem, ItemStack catalyst) {
            ItemStack out = gem.m_41777_();
            GemItem.setFacets(out, 0);
            GemItem.setLootRarity(out, GemItem.getLootRarity(out).next());
            return out;
        }

        @Override
        public void decrementInputs(ItemStack gem, ItemStack catalyst) {
            gem.m_41774_(1);
            catalyst.m_41774_(1);
        }
    }
}

