/*
 * Decompiled with CFR 0.152.
 */
package shadows.apotheosis.adventure.affix.socket.gem.bonus;

import com.google.common.base.Preconditions;
import com.mojang.datafixers.kinds.App;
import com.mojang.datafixers.kinds.Applicative;
import com.mojang.serialization.Codec;
import com.mojang.serialization.codecs.RecordCodecBuilder;
import java.util.Map;
import net.minecraft.ChatFormatting;
import net.minecraft.network.chat.Component;
import net.minecraft.network.chat.MutableComponent;
import net.minecraft.network.chat.Style;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.enchantment.Enchantment;
import net.minecraftforge.registries.ForgeRegistries;
import shadows.apotheosis.Apotheosis;
import shadows.apotheosis.adventure.affix.socket.gem.GemClass;
import shadows.apotheosis.adventure.affix.socket.gem.bonus.GemBonus;
import shadows.apotheosis.adventure.loot.LootRarity;

public class EnchantmentBonus
extends GemBonus {
    protected final Enchantment ench;
    protected final boolean mustExist;
    protected final boolean global;
    protected final Map<LootRarity, Integer> values;
    public static Codec<EnchantmentBonus> CODEC = RecordCodecBuilder.create(inst -> inst.group(EnchantmentBonus.gemClass(), (App)ForgeRegistries.ENCHANTMENTS.getCodec().fieldOf("enchantment").forGetter(a -> a.ench), (App)Codec.BOOL.optionalFieldOf("must_exist", (Object)false).forGetter(a -> a.mustExist), (App)Codec.BOOL.optionalFieldOf("global", (Object)false).forGetter(a -> a.global), (App)LootRarity.mapCodec(Codec.intRange((int)1, (int)127)).fieldOf("values").forGetter(a -> a.values)).apply((Applicative)inst, EnchantmentBonus::new));

    public EnchantmentBonus(GemClass gemClass, Enchantment ench, boolean mustExist, boolean global, Map<LootRarity, Integer> values) {
        super(Apotheosis.loc("enchantment"), gemClass);
        this.ench = ench;
        this.values = values;
        this.mustExist = mustExist;
        this.global = global;
    }

    @Override
    public Component getSocketBonusTooltip(ItemStack gem, LootRarity rarity, int facets) {
        int level = this.values.get(rarity);
        String desc = "bonus." + this.getId() + ".desc";
        if (this.global) {
            desc = desc + ".global";
        } else if (this.mustExist) {
            desc = desc + ".mustExist";
        }
        MutableComponent enchName = Component.m_237115_((String)this.ench.m_44704_());
        Style style = this.ench.m_44700_(0).m_7383_();
        if (style.m_131135_().m_131265_() != ChatFormatting.GRAY.m_126665_().intValue()) {
            enchName.m_130948_(style);
        }
        return Component.m_237110_((String)desc, (Object[])new Object[]{level, Component.m_237115_((String)("misc.apotheosis.level" + (level > 1 ? ".many" : ""))), enchName}).m_130940_(ChatFormatting.GREEN);
    }

    @Override
    public void getEnchantmentLevels(ItemStack gemStack, LootRarity rarity, int facets, Map<Enchantment, Integer> enchantments) {
        int level = this.values.get(rarity);
        if (this.global) {
            for (Enchantment e : enchantments.keySet()) {
                enchantments.computeIfPresent(e, (key, val) -> val > 0 ? val + level : 0);
            }
        } else if (this.mustExist) {
            enchantments.computeIfPresent(this.ench, (key, val) -> val > 0 ? val + level : 0);
        } else {
            enchantments.merge(this.ench, level, Integer::sum);
        }
    }

    @Override
    public int getMaxFacets(LootRarity rarity) {
        return 3;
    }

    @Override
    public GemBonus validate() {
        Preconditions.checkNotNull((Object)this.ench, (Object)"Invalid DamageReductionBonus with null type");
        Preconditions.checkNotNull(this.values, (Object)"Invalid DamageReductionBonus with null values");
        return this;
    }

    @Override
    public boolean supports(LootRarity rarity) {
        return this.values.containsKey(rarity);
    }

    @Override
    public int getNumberOfUUIDs() {
        return 0;
    }

    public Codec<? extends GemBonus> getCodec() {
        return CODEC;
    }
}

