/*
 * Decompiled with CFR 0.152.
 */
package shadows.apotheosis.adventure.affix.socket.gem.bonus;

import com.google.common.base.Preconditions;
import com.mojang.datafixers.kinds.App;
import com.mojang.datafixers.kinds.Applicative;
import com.mojang.serialization.Codec;
import com.mojang.serialization.codecs.RecordCodecBuilder;
import java.util.Map;
import java.util.function.BiConsumer;
import net.minecraft.network.chat.Component;
import net.minecraft.world.entity.ai.attributes.Attribute;
import net.minecraft.world.entity.ai.attributes.AttributeModifier;
import net.minecraft.world.item.ItemStack;
import net.minecraftforge.registries.ForgeRegistries;
import shadows.apotheosis.Apotheosis;
import shadows.apotheosis.adventure.affix.socket.gem.GemClass;
import shadows.apotheosis.adventure.affix.socket.gem.GemItem;
import shadows.apotheosis.adventure.affix.socket.gem.bonus.GemBonus;
import shadows.apotheosis.adventure.loot.LootRarity;
import shadows.placebo.codec.EnumCodec;
import shadows.placebo.util.StepFunction;

public class AttributeBonus
extends GemBonus {
    public static Codec<AttributeBonus> CODEC = RecordCodecBuilder.create(inst -> inst.group(AttributeBonus.gemClass(), (App)ForgeRegistries.ATTRIBUTES.getCodec().fieldOf("attribute").forGetter(a -> a.attribute), (App)new EnumCodec(AttributeModifier.Operation.class).fieldOf("operation").forGetter(a -> a.operation), (App)VALUES_CODEC.fieldOf("values").forGetter(a -> a.values)).apply((Applicative)inst, AttributeBonus::new));
    protected final Attribute attribute;
    protected final AttributeModifier.Operation operation;
    protected final Map<LootRarity, StepFunction> values;

    public AttributeBonus(GemClass gemClass, Attribute attr, AttributeModifier.Operation op, Map<LootRarity, StepFunction> values) {
        super(Apotheosis.loc("attribute"), gemClass);
        this.attribute = attr;
        this.operation = op;
        this.values = values;
    }

    @Override
    public void addModifiers(ItemStack gem, LootRarity rarity, int facets, BiConsumer<Attribute, AttributeModifier> map) {
        map.accept(this.attribute, this.read(gem, rarity, facets));
    }

    @Override
    public Component getSocketBonusTooltip(ItemStack gem, LootRarity rarity, int facets) {
        return GemItem.toComponent(this.attribute, this.read(gem, rarity, facets));
    }

    @Override
    public int getMaxFacets(LootRarity rarity) {
        return this.values.get(rarity).steps();
    }

    @Override
    public AttributeBonus validate() {
        Preconditions.checkNotNull((Object)this.attribute, (Object)"Invalid AttributeBonus with null attribute");
        Preconditions.checkNotNull((Object)this.operation, (Object)"Invalid AttributeBonus with null operation");
        Preconditions.checkNotNull(this.values, (Object)"Invalid AttributeBonus with null values");
        return this;
    }

    @Override
    public boolean supports(LootRarity rarity) {
        return this.values.containsKey(rarity);
    }

    @Override
    public int getNumberOfUUIDs() {
        return 1;
    }

    public AttributeModifier read(ItemStack gem, LootRarity rarity, int facets) {
        return new AttributeModifier(GemItem.getUUIDs(gem).get(0), "apoth.gem_modifier", (double)this.values.get(rarity).getForStep(facets), this.operation);
    }

    public Codec<? extends GemBonus> getCodec() {
        return CODEC;
    }
}

