/*
 * Decompiled with CFR 0.152.
 */
package shadows.apotheosis.adventure.affix.socket.gem;

import java.util.function.Predicate;
import javax.annotation.Nullable;
import net.minecraft.server.level.ServerLevel;
import net.minecraft.util.RandomSource;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.level.ItemLike;
import shadows.apotheosis.Apoth;
import shadows.apotheosis.adventure.AdventureConfig;
import shadows.apotheosis.adventure.AdventureModule;
import shadows.apotheosis.adventure.affix.socket.gem.Gem;
import shadows.apotheosis.adventure.affix.socket.gem.GemItem;
import shadows.apotheosis.adventure.loot.LootRarity;
import shadows.placebo.json.WeightedJsonReloadListener;

public class GemManager
extends WeightedJsonReloadListener<Gem> {
    public static final GemManager INSTANCE = new GemManager();

    public GemManager() {
        super(AdventureModule.LOGGER, "gems", true, false);
    }

    protected void registerBuiltinSerializers() {
        this.registerSerializer(DEFAULT, Gem.SERIALIZER);
    }

    @SafeVarargs
    public static ItemStack createRandomGemStack(RandomSource rand, ServerLevel level, float luck, Predicate<Gem> ... filter) {
        Gem gem = (Gem)INSTANCE.getRandomItem(rand, luck, filter);
        if (gem == null) {
            return ItemStack.f_41583_;
        }
        LootRarity.Clamped clamp = AdventureConfig.GEM_DIM_RARITIES.get(level.m_46472_().m_135782_());
        LootRarity rarity = gem.clamp(LootRarity.random(rand, luck, clamp));
        return GemManager.createGemStack(gem, rand, rarity, luck);
    }

    public static ItemStack createGemStack(Gem gem, RandomSource rand, @Nullable LootRarity rarity, float luck) {
        ItemStack stack = new ItemStack((ItemLike)Apoth.Items.GEM.get());
        GemItem.setGem(stack, gem);
        if (rarity == null) {
            rarity = LootRarity.random(rand, luck, gem);
        }
        GemItem.setLootRarity(stack, rarity);
        int facets = rand.m_188503_(gem.getMaxFacets(rarity) + 1);
        GemItem.setFacets(stack, facets);
        return stack;
    }
}

