/*
 * Decompiled with CFR 0.152.
 */
package shadows.apotheosis.adventure.affix.socket.gem;

import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import java.util.UUID;
import javax.annotation.Nullable;
import net.minecraft.ChatFormatting;
import net.minecraft.core.NonNullList;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.nbt.ListTag;
import net.minecraft.nbt.NbtUtils;
import net.minecraft.nbt.Tag;
import net.minecraft.network.chat.Component;
import net.minecraft.network.chat.MutableComponent;
import net.minecraft.network.chat.Style;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.world.damagesource.DamageSource;
import net.minecraft.world.entity.ai.attributes.Attribute;
import net.minecraft.world.entity.ai.attributes.AttributeModifier;
import net.minecraft.world.entity.ai.attributes.Attributes;
import net.minecraft.world.item.CreativeModeTab;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.TooltipFlag;
import net.minecraft.world.level.ItemLike;
import net.minecraft.world.level.Level;
import shadows.apotheosis.Apoth;
import shadows.apotheosis.adventure.affix.AffixHelper;
import shadows.apotheosis.adventure.affix.socket.gem.Gem;
import shadows.apotheosis.adventure.affix.socket.gem.GemManager;
import shadows.apotheosis.adventure.loot.LootRarity;

public class GemItem
extends Item {
    public static final String UUID_ARRAY = "uuids";
    public static final String GEM = "gem";

    public GemItem(Item.Properties pProperties) {
        super(pProperties);
    }

    public void m_7373_(ItemStack pStack, Level pLevel, List<Component> tooltip, TooltipFlag pIsAdvanced) {
        Gem gem = GemItem.getGem(pStack);
        if (gem == null) {
            tooltip.add((Component)Component.m_237113_((String)"Errored gem with no bonus!").m_130940_(ChatFormatting.GRAY));
            return;
        }
        int facets = GemItem.getFacets(pStack);
        gem.addInformation(pStack, GemItem.getLootRarity(pStack), facets, tooltip::add);
    }

    public Component m_7626_(ItemStack pStack) {
        Gem gem = GemItem.getGem(pStack);
        LootRarity rarity = GemItem.getLootRarity(pStack);
        if (gem == null || rarity == null) {
            return super.m_7626_(pStack);
        }
        MutableComponent comp = Component.m_237115_((String)this.m_5671_(pStack));
        int facets = GemItem.getFacets(pStack);
        if (facets > 0 && facets == gem.getMaxFacets(rarity)) {
            comp = Component.m_237110_((String)"item.apotheosis.gem.flawless", (Object[])new Object[]{comp});
        } else if (facets == 0) {
            comp = Component.m_237110_((String)"item.apotheosis.gem.cracked", (Object[])new Object[]{comp});
        }
        return comp.m_130948_(Style.f_131099_.m_131148_(rarity.color()));
    }

    public String m_5671_(ItemStack pStack) {
        Gem gem = GemItem.getGem(pStack);
        if (gem == null) {
            return super.m_5524_();
        }
        return super.m_5671_(pStack) + "." + gem.getId();
    }

    public boolean m_5812_(ItemStack pStack) {
        Gem gem = GemItem.getGem(pStack);
        LootRarity rarity = GemItem.getLootRarity(pStack);
        if (gem == null || rarity == null) {
            return super.m_5812_(pStack);
        }
        int facets = GemItem.getFacets(pStack);
        return facets > 0 && facets == gem.getMaxFacets(rarity);
    }

    public static List<UUID> getUUIDs(ItemStack gemStack) {
        Gem gem = GemItem.getGem(gemStack);
        if (gem == null || gem.getNumberOfUUIDs() == 0) {
            return Collections.emptyList();
        }
        CompoundTag tag = gemStack.m_41784_();
        if (tag.m_128441_(UUID_ARRAY)) {
            ListTag list = tag.m_128437_(UUID_ARRAY, 11);
            ArrayList<UUID> ret = new ArrayList<UUID>(list.size());
            for (Tag t : list) {
                ret.add(NbtUtils.m_129233_((Tag)t));
            }
            if (ret.size() <= gem.getNumberOfUUIDs()) {
                return GemItem.generateAndSave(ret, gem.getNumberOfUUIDs(), gemStack);
            }
            return ret;
        }
        return GemItem.generateAndSave(new ArrayList<UUID>(gem.getNumberOfUUIDs()), gem.getNumberOfUUIDs(), gemStack);
    }

    private static List<UUID> generateAndSave(List<UUID> base, int amount, ItemStack gemStack) {
        int needed = amount - base.size();
        for (int i = 0; i < needed; ++i) {
            base.add(UUID.randomUUID());
        }
        ListTag list = new ListTag();
        for (UUID id : base) {
            list.add((Object)NbtUtils.m_129226_((UUID)id));
        }
        gemStack.m_41784_().m_128365_(UUID_ARRAY, (Tag)list);
        return base;
    }

    public static void setGem(ItemStack gemStack, Gem gem) {
        gemStack.m_41784_().m_128359_(GEM, gem.getId().toString());
    }

    @Nullable
    public static Gem getGem(ItemStack gem) {
        if (gem.m_41720_() != Apoth.Items.GEM.get() || !gem.m_41782_()) {
            return null;
        }
        CompoundTag tag = gem.m_41783_();
        if (tag.m_128441_(GEM)) {
            return (Gem)GemManager.INSTANCE.getValue(new ResourceLocation(tag.m_128461_(GEM)));
        }
        return null;
    }

    public static void setFacets(ItemStack stack, int facets) {
        stack.m_41784_().m_128405_("facets", facets);
    }

    public static int getFacets(ItemStack stack) {
        return stack.m_41782_() ? stack.m_41783_().m_128451_("facets") : 0;
    }

    public static void setLootRarity(ItemStack stack, LootRarity rarity) {
        stack.m_41784_().m_128359_("rarity", rarity.id());
    }

    @Nullable
    public static LootRarity getLootRarity(ItemStack stack) {
        Gem gem = GemItem.getGem(stack);
        return gem == null ? null : gem.clamp(AffixHelper.getRarity(stack.m_41783_()));
    }

    public boolean m_41386_(DamageSource src) {
        return super.m_41386_(src) && src != DamageSource.f_19321_;
    }

    public void m_6787_(CreativeModeTab group, NonNullList<ItemStack> items) {
        if (group == CreativeModeTab.f_40754_) {
            GemManager.INSTANCE.getValues().stream().sorted((g1, g2) -> g1.getId().compareTo(g2.getId())).forEach(gem -> {
                ItemStack stack = new ItemStack((ItemLike)this);
                GemItem.setGem(stack, gem);
                GemItem.setLootRarity(stack, gem.getMaxRarity());
                GemItem.setFacets(stack, gem.getMaxFacets(gem.getMaxRarity()));
                items.add((Object)stack);
            });
        }
    }

    public static Component toComponent(Attribute attr, AttributeModifier modif) {
        int code;
        String key;
        double amt = modif.m_22218_();
        if (modif.m_22217_() == AttributeModifier.Operation.ADDITION) {
            if (attr == Attributes.f_22278_) {
                amt *= 10.0;
            }
        } else {
            amt *= 100.0;
        }
        String string = key = (code = modif.m_22217_().ordinal()) == 0 ? "attribute.modifier." : "attribute.modifier.apotheosis.";
        if (amt > 0.0) {
            return Component.m_237110_((String)(key + "plus." + code), (Object[])new Object[]{ItemStack.f_41584_.format(amt), Component.m_237115_((String)attr.m_22087_())}).m_130940_(ChatFormatting.BLUE);
        }
        return Component.m_237110_((String)(key + "take." + code), (Object[])new Object[]{ItemStack.f_41584_.format(amt *= -1.0), Component.m_237115_((String)attr.m_22087_())}).m_130940_(ChatFormatting.RED);
    }
}

