/*
 * Decompiled with CFR 0.152.
 */
package shadows.apotheosis.adventure.affix.effect;

import com.mojang.datafixers.kinds.App;
import com.mojang.datafixers.kinds.Applicative;
import com.mojang.serialization.Codec;
import com.mojang.serialization.codecs.RecordCodecBuilder;
import java.util.Arrays;
import java.util.Map;
import java.util.function.Consumer;
import net.minecraft.ChatFormatting;
import net.minecraft.core.BlockPos;
import net.minecraft.network.chat.Component;
import net.minecraft.world.effect.MobEffectUtil;
import net.minecraft.world.effect.MobEffects;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.enchantment.EnchantmentHelper;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraftforge.common.ForgeMod;
import net.minecraftforge.event.entity.player.PlayerEvent;
import net.minecraftforge.fluids.FluidType;
import shadows.apotheosis.adventure.affix.Affix;
import shadows.apotheosis.adventure.affix.AffixHelper;
import shadows.apotheosis.adventure.affix.AffixInstance;
import shadows.apotheosis.adventure.affix.AffixType;
import shadows.apotheosis.adventure.loot.LootCategory;
import shadows.apotheosis.adventure.loot.LootRarity;
import shadows.placebo.json.ItemAdapter;
import shadows.placebo.json.PSerializer;

public class OmneticAffix
extends Affix {
    public static final Codec<OmneticAffix> CODEC = RecordCodecBuilder.create(inst -> inst.group((App)LootRarity.mapCodec(OmneticData.CODEC).fieldOf("values").forGetter(a -> a.values)).apply((Applicative)inst, OmneticAffix::new));
    public static final PSerializer<OmneticAffix> SERIALIZER = PSerializer.fromCodec((String)"Omnetic Affix", CODEC);
    protected final Map<LootRarity, OmneticData> values;

    public OmneticAffix(Map<LootRarity, OmneticData> values) {
        super(AffixType.ABILITY);
        this.values = values;
    }

    @Override
    public boolean canApplyTo(ItemStack stack, LootRarity rarity) {
        return LootCategory.forItem(stack).isBreaker() && this.values.containsKey(rarity);
    }

    @Override
    public void addInformation(ItemStack stack, LootRarity rarity, float level, Consumer<Component> list) {
        list.accept((Component)Component.m_237110_((String)("affix." + this.getId() + ".desc"), (Object[])new Object[]{Component.m_237115_((String)("misc.apotheosis." + this.values.get((Object)rarity).name))}).m_130940_(ChatFormatting.YELLOW));
    }

    public void harvest(PlayerEvent.HarvestCheck e) {
        AffixInstance inst;
        ItemStack stack = e.getEntity().m_21205_();
        if (!stack.m_41619_() && (inst = AffixHelper.getAffixes(stack).get((Object)this)) != null) {
            OmneticData data = this.values.get(inst.rarity());
            for (ItemStack item : data.items()) {
                if (!item.m_41735_(e.getTargetBlock())) continue;
                e.setCanHarvest(true);
                return;
            }
        }
    }

    public void speed(PlayerEvent.BreakSpeed e) {
        AffixInstance inst;
        ItemStack stack = e.getEntity().m_21205_();
        if (!stack.m_41619_() && (inst = AffixHelper.getAffixes(stack).get((Object)this)) != null) {
            float speed = e.getOriginalSpeed();
            OmneticData data = this.values.get(inst.rarity());
            for (ItemStack item : data.items()) {
                speed = Math.max(OmneticAffix.getBaseSpeed(e.getEntity(), item, e.getState(), e.getPosition().orElse(BlockPos.f_121853_)), speed);
            }
            e.setNewSpeed(speed);
        }
    }

    public PSerializer<? extends Affix> getSerializer() {
        return SERIALIZER;
    }

    static float getBaseSpeed(Player player, ItemStack tool, BlockState state, BlockPos pos) {
        float f = tool.m_41691_(state);
        if (f > 1.0f) {
            int i = EnchantmentHelper.m_44926_((LivingEntity)player);
            ItemStack itemstack = player.m_21205_();
            if (i > 0 && !itemstack.m_41619_()) {
                f += (float)(i * i + 1);
            }
        }
        if (MobEffectUtil.m_19584_((LivingEntity)player)) {
            f *= 1.0f + (float)(MobEffectUtil.m_19586_((LivingEntity)player) + 1) * 0.2f;
        }
        if (player.m_21023_(MobEffects.f_19599_)) {
            f *= (switch (player.m_21124_(MobEffects.f_19599_).m_19564_()) {
                case 0 -> 0.3f;
                case 1 -> 0.09f;
                case 2 -> 0.0027f;
                default -> 8.1E-4f;
            });
        }
        if (player.isEyeInFluidType((FluidType)ForgeMod.WATER_TYPE.get()) && !EnchantmentHelper.m_44934_((LivingEntity)player)) {
            f /= 5.0f;
        }
        if (!player.m_20096_()) {
            f /= 5.0f;
        }
        return f;
    }

    record OmneticData(String name, ItemStack[] items) {
        public static Codec<OmneticData> CODEC = RecordCodecBuilder.create(inst -> inst.group((App)Codec.STRING.fieldOf("name").forGetter(OmneticData::name), (App)Codec.list((Codec)ItemAdapter.CODEC).xmap(l -> l.toArray(new ItemStack[0]), Arrays::asList).fieldOf("items").forGetter(OmneticData::items)).apply((Applicative)inst, OmneticData::new));
    }
}

