/*
 * Decompiled with CFR 0.152.
 */
package shadows.apotheosis.adventure.affix;

import com.google.gson.JsonArray;
import com.google.gson.JsonElement;
import com.google.gson.JsonObject;
import com.google.gson.reflect.TypeToken;
import java.util.Collection;
import java.util.HashMap;
import java.util.Map;
import java.util.Set;
import java.util.concurrent.atomic.AtomicBoolean;
import java.util.stream.Stream;
import javax.annotation.Nullable;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.nbt.ListTag;
import net.minecraft.nbt.StringTag;
import net.minecraft.nbt.Tag;
import net.minecraft.network.chat.Component;
import net.minecraft.network.chat.MutableComponent;
import net.minecraft.network.chat.Style;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.item.ItemStack;
import shadows.apotheosis.Apotheosis;
import shadows.apotheosis.adventure.affix.Affix;
import shadows.apotheosis.adventure.affix.AffixInstance;
import shadows.apotheosis.adventure.affix.AffixManager;
import shadows.apotheosis.adventure.affix.AffixType;
import shadows.apotheosis.adventure.loot.LootCategory;
import shadows.apotheosis.adventure.loot.LootRarity;
import shadows.placebo.util.CachedObject;
import shadows.placebo.util.StepFunction;

public class AffixHelper {
    public static final ResourceLocation AFFIX_CACHED_OBJECT = Apotheosis.loc("affixes");
    public static final String DISPLAY = "display";
    public static final String LORE = "Lore";
    public static final String AFFIX_DATA = "affix_data";
    public static final String AFFIXES = "affixes";
    public static final String RARITY = "rarity";
    public static final String NAME = "name";
    private static ThreadLocal<AtomicBoolean> reentrantLock = ThreadLocal.withInitial(() -> new AtomicBoolean(false));

    public static void applyAffix(ItemStack stack, AffixInstance affix) {
        Map<Affix, AffixInstance> affixes = AffixHelper.getAffixes(stack);
        affixes.put(affix.affix(), affix);
        AffixHelper.setAffixes(stack, affixes);
    }

    public static void setAffixes(ItemStack stack, Map<Affix, AffixInstance> affixes) {
        CompoundTag afxData = stack.m_41698_(AFFIX_DATA);
        CompoundTag affixesTag = new CompoundTag();
        for (AffixInstance inst : affixes.values()) {
            affixesTag.m_128350_(inst.affix().getId().toString(), inst.level());
        }
        afxData.m_128365_(AFFIXES, (Tag)affixesTag);
    }

    public static void setName(ItemStack stack, Component name) {
        CompoundTag afxData = stack.m_41698_(AFFIX_DATA);
        afxData.m_128359_(NAME, Component.Serializer.m_130703_((Component)name));
    }

    @Nullable
    public static Component getName(ItemStack stack) {
        if (!stack.m_41782_()) {
            return null;
        }
        CompoundTag afxData = stack.m_41737_(AFFIX_DATA);
        if (afxData == null) {
            return null;
        }
        return Component.Serializer.m_130701_((String)afxData.m_128461_(NAME));
    }

    public static Map<Affix, AffixInstance> getAffixes(ItemStack stack) {
        return (Map)CachedObject.CachedObjectSource.getOrCreate((ItemStack)stack, (ResourceLocation)AFFIX_CACHED_OBJECT, AffixHelper::getAffixesImpl);
    }

    public static Map<Affix, AffixInstance> getAffixesImpl(ItemStack stack) {
        boolean isReentrant = reentrantLock.get().getAndSet(true);
        HashMap<Affix, AffixInstance> map = new HashMap<Affix, AffixInstance>();
        if (!AffixHelper.hasAffixes(stack)) {
            return map;
        }
        CompoundTag afxData = stack.m_41737_(AFFIX_DATA);
        if (afxData != null && afxData.m_128441_(AFFIXES)) {
            CompoundTag affixes = afxData.m_128469_(AFFIXES);
            LootRarity rarity = AffixHelper.getRarity(afxData);
            if (rarity == null) {
                rarity = LootRarity.COMMON;
            }
            for (String key : affixes.m_128431_()) {
                Affix affix = (Affix)AffixManager.INSTANCE.getValue(new ResourceLocation(key));
                if (affix == null || !isReentrant && !affix.canApplyTo(stack, rarity)) continue;
                float lvl = affixes.m_128457_(key);
                map.put(affix, new AffixInstance(affix, stack, rarity, lvl));
            }
        }
        reentrantLock.get().set(false);
        return map;
    }

    public static Stream<AffixInstance> streamAffixes(ItemStack stack) {
        return AffixHelper.getAffixes(stack).values().stream();
    }

    public static boolean hasAffixes(ItemStack stack) {
        return stack.m_41782_() && !stack.m_41783_().m_128469_(AFFIX_DATA).m_128469_(AFFIXES).m_128456_();
    }

    public static void addLore(ItemStack stack, Component lore) {
        CompoundTag display = stack.m_41698_(DISPLAY);
        ListTag tag = display.m_128437_(LORE, 8);
        tag.add((Object)StringTag.m_129297_((String)Component.Serializer.m_130703_((Component)lore)));
        display.m_128365_(LORE, (Tag)tag);
    }

    public static void setRarity(ItemStack stack, LootRarity rarity) {
        MutableComponent comp = Component.m_237110_((String)"%s", (Object[])new Object[]{Component.m_237113_((String)"")}).m_130948_(Style.f_131099_.m_131148_(rarity.color()));
        CompoundTag afxData = stack.m_41698_(AFFIX_DATA);
        afxData.m_128359_(NAME, Component.Serializer.m_130703_((Component)comp));
        afxData.m_128359_(RARITY, rarity.id());
    }

    public static void copyFrom(ItemStack stack, Entity entity) {
        if (AffixHelper.hasAffixes(stack)) {
            CompoundTag afxData = stack.m_41737_(AFFIX_DATA);
            entity.getPersistentData().m_128365_(AFFIX_DATA, (Tag)afxData.m_6426_());
        }
    }

    public static Map<Affix, AffixInstance> getAffixes(Entity entity) {
        HashMap<Affix, AffixInstance> map = new HashMap<Affix, AffixInstance>();
        if (entity == null) {
            return map;
        }
        CompoundTag afxData = entity.getPersistentData().m_128469_(AFFIX_DATA);
        if (afxData != null && afxData.m_128441_(AFFIXES)) {
            CompoundTag affixes = afxData.m_128469_(AFFIXES);
            LootRarity rarity = AffixHelper.getRarity(afxData);
            if (rarity == null) {
                rarity = LootRarity.COMMON;
            }
            for (String key : affixes.m_128431_()) {
                Affix affix = (Affix)AffixManager.INSTANCE.getValue(new ResourceLocation(key));
                if (affix == null) continue;
                float lvl = affixes.m_128457_(key);
                map.put(affix, new AffixInstance(affix, ItemStack.f_41583_, rarity, lvl));
            }
        }
        return map;
    }

    public static Stream<AffixInstance> streamAffixes(Entity entity) {
        return AffixHelper.getAffixes(entity).values().stream();
    }

    @Nullable
    public static LootRarity getRarity(ItemStack stack) {
        if (!stack.m_41782_()) {
            return null;
        }
        CompoundTag afxData = stack.m_41737_(AFFIX_DATA);
        return AffixHelper.getRarity(afxData);
    }

    @Nullable
    public static LootRarity getRarity(@Nullable CompoundTag afxData) {
        if (afxData != null) {
            try {
                return LootRarity.byId(afxData.m_128461_(RARITY));
            }
            catch (IllegalArgumentException e) {
                afxData.m_128473_(RARITY);
                return null;
            }
        }
        return null;
    }

    public static Collection<Affix> byType(AffixType type) {
        return AffixManager.INSTANCE.getTypeMap().get((Object)type);
    }

    public static StepFunction step(float min, int steps, float step) {
        return new StepFunction(min, steps, step);
    }

    public static Map<LootRarity, StepFunction> readValues(JsonObject obj) {
        return (Map)Affix.GSON.fromJson((JsonElement)obj, new TypeToken<Map<LootRarity, StepFunction>>(){}.getType());
    }

    public static Set<LootCategory> readTypes(JsonArray json) {
        return (Set)Affix.GSON.fromJson((JsonElement)json, new TypeToken<Set<LootCategory>>(){}.getType());
    }
}

