/*
 * Decompiled with CFR 0.152.
 */
package shadows.placebo.json;

import com.google.gson.JsonElement;
import com.google.gson.JsonObject;
import com.google.gson.JsonParseException;
import com.mojang.datafixers.util.Pair;
import com.mojang.serialization.Codec;
import com.mojang.serialization.DynamicOps;
import com.mojang.serialization.JsonOps;
import java.util.Objects;
import java.util.function.Consumer;
import java.util.function.Supplier;
import javax.annotation.Nullable;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.nbt.NbtOps;
import net.minecraft.network.FriendlyByteBuf;
import shadows.placebo.Placebo;
import shadows.placebo.json.JsonUtil;

public class PSerializer<V>
implements JsonUtil.JsonDeserializer<V>,
JsonUtil.JsonSerializer<V>,
JsonUtil.NetDeserializer<V>,
JsonUtil.NetSerializer<V> {
    private final String name;
    private final JsonUtil.JsonDeserializer<V> jds;
    @Nullable
    private final JsonUtil.JsonSerializer<V> js;
    @Nullable
    private final JsonUtil.NetDeserializer<V> nds;
    @Nullable
    private final JsonUtil.NetSerializer<V> ns;

    public PSerializer(String name, JsonUtil.JsonDeserializer<V> jds, @Nullable JsonUtil.JsonSerializer<V> js, @Nullable JsonUtil.NetDeserializer<V> nds, @Nullable JsonUtil.NetSerializer<V> ns) {
        this.name = Objects.requireNonNull(name);
        this.jds = Objects.requireNonNull(jds, "The serializer for " + this.name + " is missing a json deserializer.");
        this.js = js;
        this.nds = nds;
        this.ns = ns;
    }

    @Override
    public JsonObject write(V src) {
        if (this.js == null) {
            throw new UnsupportedOperationException("Attempted to serialize a " + this.name + " to json, but this serializer does not support that operation.");
        }
        return this.js.write(src);
    }

    @Override
    public void write(V src, FriendlyByteBuf buf) {
        if (this.ns == null) {
            throw new UnsupportedOperationException("Attempted to serialize a " + this.name + " to the network, but this serializer does not support that operation.");
        }
        this.ns.write(src, buf);
    }

    @Override
    public V read(JsonObject json) throws JsonParseException {
        return this.jds.read(json);
    }

    @Override
    public V read(FriendlyByteBuf buf) {
        if (this.nds == null) {
            throw new UnsupportedOperationException("Attempted to deserialize a " + this.name + " from the network, but this serializer does not support that operation.");
        }
        return this.nds.read(buf);
    }

    public final JsonObject writeUnchecked(Object src) {
        return this.write(src);
    }

    public final void writeUnchecked(Object src, FriendlyByteBuf buf) {
        this.write(src, buf);
    }

    public void validate(boolean serializable, boolean synced) {
        if (serializable) {
            Objects.requireNonNull(this.js, "The serializer for " + this.name + " is missing a json serializer.");
        }
        if (synced) {
            Objects.requireNonNull(this.nds, "The serializer for " + this.name + " is missing a network deserializer.");
            Objects.requireNonNull(this.ns, "The serializer for " + this.name + " is missing a network serializer.");
        }
    }

    public static <V> PSerializer<V> fromCodec(String name, Codec<V> codec) {
        Builder<Object> builder = new Builder<Object>(name);
        Consumer<String> onErr = msg -> PSerializer.logCodecError(name, msg);
        builder.toJson(obj -> ((JsonElement)codec.encodeStart((DynamicOps)JsonOps.INSTANCE, obj).getOrThrow(false, onErr)).getAsJsonObject());
        builder.fromJson(json -> ((Pair)codec.decode((DynamicOps)JsonOps.INSTANCE, (Object)json).getOrThrow(false, onErr)).getFirst());
        builder.toNetwork((obj, buf) -> buf.m_130079_((CompoundTag)codec.encodeStart((DynamicOps)NbtOps.f_128958_, obj).getOrThrow(false, onErr)));
        builder.fromNetwork(buf -> ((Pair)codec.decode((DynamicOps)NbtOps.f_128958_, (Object)buf.m_130260_()).getOrThrow(false, onErr)).getFirst());
        return builder.build();
    }

    private static void logCodecError(String name, String msg) {
        Placebo.LOGGER.error("Codec failure for type {}, message: {}", (Object)name, (Object)msg);
    }

    public static <V> PSerializer<V> builtin(String name, Supplier<V> factory) {
        Builder<Object> builder = new Builder<Object>(name);
        builder.fromJson(json -> factory.get()).toJson(o -> new JsonObject());
        builder.fromNetwork(net -> factory.get()).toNetwork((obj, buf) -> {});
        return builder.build();
    }

    public static <V> PSerializer<V> basic(String name, JsonUtil.JsonDeserializer<V> jds) {
        return PSerializer.builder(name, jds).build();
    }

    public static <V> Builder<V> builder(String name) {
        return new Builder(name);
    }

    public static <V> Builder<V> builder(String name, JsonUtil.JsonDeserializer<V> jds) {
        return new Builder<V>(name).fromJson(jds);
    }

    public static class Builder<V> {
        private final String name;
        private JsonUtil.JsonDeserializer<V> jds;
        private JsonUtil.JsonSerializer<V> js;
        private JsonUtil.NetDeserializer<V> nds;
        private JsonUtil.NetSerializer<V> ns;

        public Builder(String name) {
            this.name = name;
        }

        public Builder<V> fromJson(JsonUtil.JsonDeserializer<V> jds) {
            this.jds = jds;
            return this;
        }

        public Builder<V> toJson(JsonUtil.JsonSerializer<V> js) {
            this.js = js;
            return this;
        }

        public Builder<V> fromNetwork(JsonUtil.NetDeserializer<V> nds) {
            this.nds = nds;
            return this;
        }

        public Builder<V> toNetwork(JsonUtil.NetSerializer<V> ns) {
            this.ns = ns;
            return this;
        }

        public Builder<V> networked(JsonUtil.NetDeserializer<V> nds, JsonUtil.NetSerializer<V> ns) {
            return this.fromNetwork(nds).toNetwork(ns);
        }

        public PSerializer<V> build() {
            return new PSerializer<V>(this.name, this.jds, this.js, this.nds, this.ns);
        }
    }

    public static interface PSerializable<V extends PSerializable<V>> {
        public PSerializer<? extends V> getSerializer();
    }
}

