/*
 * Decompiled with CFR 0.152.
 */
package shadows.placebo.codec;

import com.google.common.collect.BiMap;
import com.mojang.datafixers.util.Pair;
import com.mojang.serialization.Codec;
import com.mojang.serialization.DataResult;
import com.mojang.serialization.DynamicOps;
import java.util.ArrayList;
import java.util.HashSet;
import java.util.Optional;
import java.util.Set;
import javax.annotation.Nullable;
import net.minecraft.resources.ResourceLocation;
import org.apache.logging.log4j.Logger;
import shadows.placebo.Placebo;

public class PlaceboCodecs {
    public static <V extends CodecProvider<V>> Codec<V> mapBackedDefaulted(String name, BiMap<ResourceLocation, Codec<? extends V>> reg, Codec<? extends V> defaultCodec) {
        return new MapBackedCodec<V>(name, reg, defaultCodec);
    }

    public static <V extends CodecProvider<V>> Codec<V> mapBacked(String name, BiMap<ResourceLocation, Codec<? extends V>> reg) {
        return new MapBackedCodec<V>(name, reg);
    }

    public static <V> Codec<Set<V>> setCodec(Codec<V> elementCodec) {
        return elementCodec.listOf().xmap(HashSet::new, ArrayList::new);
    }

    public static class MapBackedCodec<V extends CodecProvider<V>>
    implements Codec<V> {
        protected final String name;
        protected final BiMap<ResourceLocation, Codec<? extends V>> registry;
        @Nullable
        protected final Codec<? extends V> defaultCodec;

        public MapBackedCodec(String name, BiMap<ResourceLocation, Codec<? extends V>> registry, @Nullable Codec<? extends V> defaultCodec) {
            this.name = name;
            this.registry = registry;
            this.defaultCodec = defaultCodec;
        }

        public MapBackedCodec(String name, BiMap<ResourceLocation, Codec<? extends V>> registry) {
            this(name, registry, null);
        }

        public <T> DataResult<Pair<V, T>> decode(DynamicOps<T> ops, T input) {
            Optional type = ops.get(input, "type").resultOrPartial(str -> {});
            Optional<ResourceLocation> key = type.map(t -> (ResourceLocation)((Pair)ResourceLocation.f_135803_.decode(ops, t).resultOrPartial(arg_0 -> ((Logger)Placebo.LOGGER).error(arg_0)).get()).getFirst());
            Codec<? extends V> codec = key.map(arg_0 -> this.registry.get(arg_0)).orElse(this.defaultCodec);
            if (codec == null) {
                return DataResult.error((String)("Failure when parsing a " + this.name + ". Unrecognized type: " + key.map(ResourceLocation::toString).orElse("null")));
            }
            return codec.decode(ops, input);
        }

        public <T> DataResult<T> encode(V input, DynamicOps<T> ops, T prefix) {
            Codec codec = input.getCodec();
            ResourceLocation key = (ResourceLocation)this.registry.inverse().get(codec);
            if (key == null) {
                return DataResult.error((String)("Attempted to serialize an element of type " + this.name + " with an unregistered codec! Object: " + input));
            }
            Object encodedKey = ResourceLocation.f_135803_.encodeStart(ops, (Object)key).getOrThrow(false, arg_0 -> ((Logger)Placebo.LOGGER).error(arg_0));
            Object encodedObj = codec.encode(input, ops, prefix).getOrThrow(false, arg_0 -> ((Logger)Placebo.LOGGER).error(arg_0));
            return ops.mergeToMap(encodedObj, ops.createString("type"), encodedKey);
        }
    }

    public static interface CodecProvider<T> {
        public Codec<? extends T> getCodec();
    }
}

