/*
 * Decompiled with CFR 0.152.
 */
package net.mehvahdjukaar.moonlight.api.platform.network.forge;

import java.util.Optional;
import java.util.function.Function;
import java.util.function.Supplier;
import net.mehvahdjukaar.moonlight.api.platform.network.ChannelHandler;
import net.mehvahdjukaar.moonlight.api.platform.network.Message;
import net.mehvahdjukaar.moonlight.api.platform.network.NetworkDir;
import net.minecraft.core.BlockPos;
import net.minecraft.network.FriendlyByteBuf;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.server.MinecraftServer;
import net.minecraft.server.level.ServerPlayer;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.level.Level;
import net.minecraftforge.network.NetworkDirection;
import net.minecraftforge.network.NetworkEvent;
import net.minecraftforge.network.NetworkRegistry;
import net.minecraftforge.network.PacketDistributor;
import net.minecraftforge.network.simple.SimpleChannel;
import net.minecraftforge.server.ServerLifecycleHooks;

public class ChannelHandlerImpl
extends ChannelHandler {
    public final SimpleChannel channel;
    protected int id = 0;

    public static ChannelHandler createChannel(ResourceLocation channelMame) {
        return new ChannelHandlerImpl(channelMame);
    }

    public ChannelHandlerImpl(ResourceLocation channelName) {
        super(channelName);
        String version = "1";
        this.channel = NetworkRegistry.newSimpleChannel((ResourceLocation)channelName, () -> version, version::equals, version::equals);
    }

    @Override
    public <M extends Message> void register(NetworkDir dir, Class<M> messageClass, Function<FriendlyByteBuf, M> decoder) {
        Optional<Object> d = switch (dir) {
            default -> throw new IncompatibleClassChangeError();
            case NetworkDir.BOTH -> Optional.empty();
            case NetworkDir.PLAY_TO_CLIENT -> Optional.of(NetworkDirection.PLAY_TO_CLIENT);
            case NetworkDir.PLAY_TO_SERVER -> Optional.of(NetworkDirection.PLAY_TO_SERVER);
        };
        this.channel.registerMessage(this.id++, messageClass, Message::writeToBuffer, decoder, this::consumer, d);
    }

    private <M extends Message> void consumer(M message, Supplier<NetworkEvent.Context> context) {
        NetworkEvent.Context c = context.get();
        c.enqueueWork(() -> message.handle(new Wrapper(c)));
        c.setPacketHandled(true);
    }

    @Override
    public void sendToClientPlayer(ServerPlayer serverPlayer, Message message) {
        this.channel.send(PacketDistributor.PLAYER.with(() -> serverPlayer), (Object)message);
    }

    @Override
    public void sendToAllClientPlayers(Message message) {
        this.channel.send(PacketDistributor.ALL.noArg(), (Object)message);
    }

    @Override
    public void sendToServer(Message message) {
        this.channel.sendToServer((Object)message);
    }

    @Override
    public void sendToAllClientPlayersInRange(Level level, BlockPos pos, double radius, Message message) {
        MinecraftServer currentServer = ServerLifecycleHooks.getCurrentServer();
        if (currentServer != null) {
            PacketDistributor.PacketTarget distributor = PacketDistributor.NEAR.with(() -> new PacketDistributor.TargetPoint((double)pos.m_123341_(), (double)pos.m_123342_(), (double)pos.m_123343_(), radius, level.m_46472_()));
            this.channel.send(distributor, (Object)message);
        }
    }

    @Override
    public void sentToAllClientPlayersTrackingEntity(Entity target, Message message) {
        this.channel.send(PacketDistributor.TRACKING_ENTITY.with(() -> target), (Object)message);
    }

    @Override
    public void sentToAllClientPlayersTrackingEntityAndSelf(Entity target, Message message) {
        this.channel.send(PacketDistributor.TRACKING_ENTITY_AND_SELF.with(() -> target), (Object)message);
    }

    static class Wrapper
    implements ChannelHandler.Context {
        private final NetworkEvent.Context context;

        public Wrapper(NetworkEvent.Context ctx) {
            this.context = ctx;
        }

        @Override
        public NetworkDir getDirection() {
            return switch (this.context.getDirection()) {
                case NetworkDirection.PLAY_TO_CLIENT -> NetworkDir.PLAY_TO_CLIENT;
                default -> NetworkDir.PLAY_TO_SERVER;
            };
        }

        @Override
        public Player getSender() {
            return this.context.getSender();
        }
    }
}

