/*
 * Decompiled with CFR 0.152.
 */
package net.mehvahdjukaar.moonlight.api.client.model.forge;

import com.google.common.base.Preconditions;
import com.mojang.math.Matrix4f;
import com.mojang.math.Transformation;
import net.mehvahdjukaar.moonlight.api.client.model.BakedQuadBuilder;
import net.mehvahdjukaar.moonlight.api.client.util.RotHlpr;
import net.minecraft.client.renderer.block.model.BakedQuad;
import net.minecraft.client.renderer.texture.TextureAtlasSprite;
import net.minecraft.core.Direction;
import net.minecraftforge.client.model.QuadTransformers;
import net.minecraftforge.client.model.pipeline.QuadBakingVertexConsumer;
import org.jetbrains.annotations.Nullable;

public class BakedQuadBuilderImpl
implements BakedQuadBuilder {
    private final QuadBakingVertexConsumer inner = new QuadBakingVertexConsumer(s -> {
        this.output = s;
    });
    private int emissivity = 0;
    private BakedQuad output;
    private Matrix4f transform;

    public static BakedQuadBuilder create(@Nullable Transformation transformation) {
        return new BakedQuadBuilderImpl(transformation == null ? null : transformation.m_121104_());
    }

    private BakedQuadBuilderImpl(@Nullable Matrix4f transformation) {
        this.transform = transformation;
        this.inner.setShade(true);
        this.inner.setHasAmbientOcclusion(true);
    }

    @Override
    public BakedQuadBuilder setSprite(TextureAtlasSprite sprite) {
        this.inner.setSprite(sprite);
        return this;
    }

    @Override
    public BakedQuadBuilder setShade(boolean shade) {
        this.inner.setShade(shade);
        return this;
    }

    @Override
    public BakedQuadBuilder setAmbientOcclusion(boolean ambientOcclusion) {
        this.inner.setHasAmbientOcclusion(ambientOcclusion);
        return this;
    }

    @Override
    public BakedQuadBuilder setDirection(Direction direction) {
        if (this.transform != null) {
            direction = RotHlpr.rotateDirection(direction, this.transform);
        }
        this.inner.setDirection(direction);
        return this;
    }

    @Override
    public BakedQuadBuilder pos(float x, float y, float z) {
        this.inner.m_5483_((double)x, (double)y, (double)z);
        return this;
    }

    @Override
    public BakedQuadBuilder normal(float x, float y, float z) {
        this.inner.m_5601_(x, y, z);
        return this;
    }

    @Override
    public BakedQuadBuilder lightEmission(int lightLevel) {
        this.emissivity = lightLevel;
        return this;
    }

    @Override
    public BakedQuadBuilder color(int rgba) {
        this.inner.m_193479_(rgba);
        return this;
    }

    @Override
    public BakedQuadBuilder uv(float u, float v) {
        this.inner.m_7421_(u, v);
        return this;
    }

    @Override
    public BakedQuadBuilder endVertex() {
        this.inner.m_5752_();
        return this;
    }

    @Override
    public BakedQuad build() {
        Preconditions.checkNotNull((Object)this.output, (Object)"vertex data has not been fully filled");
        if (this.transform != null) {
            QuadTransformers.applying((Transformation)new Transformation(this.transform).blockCenterToCorner()).processInPlace(this.output);
        }
        if (this.emissivity != 0) {
            QuadTransformers.settingEmissivity((int)this.emissivity).processInPlace(this.output);
        }
        return this.output;
    }

    @Override
    public BakedQuadBuilder useTransform(Matrix4f matrix4f) {
        this.transform = matrix4f;
        return this;
    }
}

