/*
 * Decompiled with CFR 0.152.
 */
package mcjty.incontrol.rules;

import com.google.gson.JsonElement;
import java.util.Set;
import java.util.function.Consumer;
import javax.annotation.Nullable;
import mcjty.incontrol.ErrorHandler;
import mcjty.incontrol.InControl;
import mcjty.incontrol.compat.ModRuleCompatibilityLayer;
import mcjty.incontrol.data.PhaseTools;
import mcjty.incontrol.rules.support.GenericRuleEvaluator;
import mcjty.incontrol.rules.support.RuleKeys;
import mcjty.incontrol.tools.rules.IEventQuery;
import mcjty.incontrol.tools.rules.IModRuleCompatibilityLayer;
import mcjty.incontrol.tools.rules.RuleBase;
import mcjty.incontrol.tools.typed.Attribute;
import mcjty.incontrol.tools.typed.AttributeMap;
import mcjty.incontrol.tools.typed.GenericAttributeMapFactory;
import net.minecraft.core.BlockPos;
import net.minecraft.world.damagesource.DamageSource;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.LevelAccessor;
import net.minecraftforge.event.entity.EntityJoinLevelEvent;
import net.minecraftforge.event.entity.living.LivingSpawnEvent;
import net.minecraftforge.eventbus.api.Event;

public class SpawnRule
extends RuleBase<RuleBase.EventGetter> {
    public static final IEventQuery<LivingSpawnEvent.CheckSpawn> EVENT_QUERY = new IEventQuery<LivingSpawnEvent.CheckSpawn>(){

        @Override
        public LevelAccessor getWorld(LivingSpawnEvent.CheckSpawn o) {
            return o.getLevel();
        }

        @Override
        public BlockPos getPos(LivingSpawnEvent.CheckSpawn o) {
            return new BlockPos(o.getX(), o.getY(), o.getZ());
        }

        @Override
        public BlockPos getValidBlockPos(LivingSpawnEvent.CheckSpawn o) {
            return new BlockPos(o.getX(), o.getY() - 1.0, o.getZ());
        }

        @Override
        public int getY(LivingSpawnEvent.CheckSpawn o) {
            return (int)o.getY();
        }

        @Override
        public Entity getEntity(LivingSpawnEvent.CheckSpawn o) {
            return o.getEntity();
        }

        @Override
        public DamageSource getSource(LivingSpawnEvent.CheckSpawn o) {
            return null;
        }

        @Override
        public Entity getAttacker(LivingSpawnEvent.CheckSpawn o) {
            return null;
        }

        @Override
        public Player getPlayer(LivingSpawnEvent.CheckSpawn o) {
            return SpawnRule.getClosestPlayer(o.getLevel(), new BlockPos(o.getX(), o.getY(), o.getZ()));
        }

        @Override
        public ItemStack getItem(LivingSpawnEvent.CheckSpawn o) {
            return ItemStack.f_41583_;
        }
    };
    public static final IEventQuery<EntityJoinLevelEvent> EVENT_QUERY_JOIN = new IEventQuery<EntityJoinLevelEvent>(){

        public Level getWorld(EntityJoinLevelEvent o) {
            return o.getLevel();
        }

        @Override
        public BlockPos getPos(EntityJoinLevelEvent o) {
            return o.getEntity().m_20183_();
        }

        @Override
        public BlockPos getValidBlockPos(EntityJoinLevelEvent o) {
            return o.getEntity().m_20183_().m_7495_();
        }

        @Override
        public int getY(EntityJoinLevelEvent o) {
            return o.getEntity().m_20183_().m_123342_();
        }

        @Override
        public Entity getEntity(EntityJoinLevelEvent o) {
            return o.getEntity();
        }

        @Override
        public DamageSource getSource(EntityJoinLevelEvent o) {
            return null;
        }

        @Override
        public Entity getAttacker(EntityJoinLevelEvent o) {
            return null;
        }

        @Override
        public Player getPlayer(EntityJoinLevelEvent o) {
            return SpawnRule.getClosestPlayer((LevelAccessor)o.getLevel(), o.getEntity().m_20183_());
        }

        @Override
        public ItemStack getItem(EntityJoinLevelEvent o) {
            return ItemStack.f_41583_;
        }
    };
    private static final GenericAttributeMapFactory FACTORY = new GenericAttributeMapFactory();
    private final boolean onJoin;
    private final GenericRuleEvaluator ruleEvaluator;
    private final Set<String> phases;
    private Event.Result result = null;
    private boolean doContinue = false;

    private static Player getClosestPlayer(LevelAccessor world, BlockPos pos) {
        return world.m_45924_((double)pos.m_123341_(), (double)pos.m_123342_(), (double)pos.m_123343_(), 100.0, false);
    }

    private SpawnRule(AttributeMap map, boolean onJoin, Set<String> phases) {
        super(InControl.setup.getLogger());
        this.onJoin = onJoin;
        this.phases = phases;
        this.ruleEvaluator = new GenericRuleEvaluator(map);
        this.addActions(map, new ModRuleCompatibilityLayer());
        if (!map.isEmpty()) {
            StringBuffer buffer = new StringBuffer();
            map.getKeys().forEach(k -> buffer.append(k).append(' '));
            ErrorHandler.error("Invalid keywords in spawn rule: " + buffer);
        }
    }

    public Set<String> getPhases() {
        return this.phases;
    }

    public static SpawnRule parse(JsonElement element) {
        if (element == null) {
            return null;
        }
        AttributeMap map = FACTORY.parse(element, "spawn.json");
        boolean onJoin = element.getAsJsonObject().has("onjoin") && element.getAsJsonObject().get("onjoin").getAsBoolean();
        return new SpawnRule(map, onJoin, PhaseTools.getPhases(element));
    }

    @Override
    protected void addActions(AttributeMap map, IModRuleCompatibilityLayer layer) {
        super.addActions(map, layer);
        map.consumeOrElse(RuleKeys.ACTION_RESULT, br -> {
            this.result = "default".equals(br) || br.startsWith("def") ? Event.Result.DEFAULT : ("allow".equals(br) || "true".equals(br) ? Event.Result.ALLOW : Event.Result.DENY);
        }, () -> {
            this.result = null;
        });
        map.consume(RuleKeys.ACTION_CONTINUE, v -> {
            this.doContinue = v;
        });
    }

    public boolean match(LivingSpawnEvent.CheckSpawn event) {
        return this.ruleEvaluator.match(event, EVENT_QUERY);
    }

    public boolean match(EntityJoinLevelEvent event) {
        return this.ruleEvaluator.match(event, EVENT_QUERY_JOIN);
    }

    public void action(final LivingSpawnEvent.CheckSpawn event) {
        RuleBase.EventGetter getter = new RuleBase.EventGetter(){

            @Override
            public LivingEntity getEntityLiving() {
                return event.getEntity();
            }

            @Override
            public Player getPlayer() {
                return null;
            }

            @Override
            public LevelAccessor getWorld() {
                return event.getLevel();
            }

            @Override
            public BlockPos getPosition() {
                return event.getEntity().m_20183_();
            }
        };
        for (Consumer action : this.actions) {
            action.accept(getter);
        }
    }

    public void action(final EntityJoinLevelEvent event) {
        RuleBase.EventGetter getter = new RuleBase.EventGetter(){

            @Override
            public LivingEntity getEntityLiving() {
                return event.getEntity() instanceof LivingEntity ? (LivingEntity)event.getEntity() : null;
            }

            @Override
            public Player getPlayer() {
                return null;
            }

            public Level getWorld() {
                return event.getLevel();
            }

            @Override
            public BlockPos getPosition() {
                return event.getEntity() != null ? event.getEntity().m_20183_() : null;
            }
        };
        for (Consumer action : this.actions) {
            action.accept(getter);
        }
    }

    @Nullable
    public Event.Result getResult() {
        return this.result;
    }

    public boolean isDoContinue() {
        return this.doContinue;
    }

    public boolean isOnJoin() {
        return this.onJoin;
    }

    static {
        FACTORY.attribute(Attribute.create(RuleKeys.ONJOIN)).attribute(Attribute.create(RuleKeys.PHASE)).attribute(Attribute.create(RuleKeys.TIME)).attribute(Attribute.create(RuleKeys.MINTIME)).attribute(Attribute.create(RuleKeys.MAXTIME)).attribute(Attribute.create(RuleKeys.DAYCOUNT)).attribute(Attribute.create(RuleKeys.MINDAYCOUNT)).attribute(Attribute.create(RuleKeys.MAXDAYCOUNT)).attribute(Attribute.create(RuleKeys.MINCOUNT)).attribute(Attribute.create(RuleKeys.MAXCOUNT)).attribute(Attribute.create(RuleKeys.LIGHT)).attribute(Attribute.create(RuleKeys.MINLIGHT)).attribute(Attribute.create(RuleKeys.MAXLIGHT)).attribute(Attribute.create(RuleKeys.HEIGHT)).attribute(Attribute.create(RuleKeys.MINHEIGHT)).attribute(Attribute.create(RuleKeys.MAXHEIGHT)).attribute(Attribute.create(RuleKeys.MINDIFFICULTY)).attribute(Attribute.create(RuleKeys.MAXDIFFICULTY)).attribute(Attribute.create(RuleKeys.MINSPAWNDIST)).attribute(Attribute.create(RuleKeys.MAXSPAWNDIST)).attribute(Attribute.create(RuleKeys.RANDOM)).attribute(Attribute.create(RuleKeys.CANSPAWNHERE)).attribute(Attribute.create(RuleKeys.NOTCOLLIDING)).attribute(Attribute.create(RuleKeys.SPAWNER)).attribute(Attribute.create(RuleKeys.INCONTROL)).attribute(Attribute.create(RuleKeys.INBUILDING)).attribute(Attribute.createMulti(RuleKeys.BUILDING)).attribute(Attribute.create(RuleKeys.INCITY)).attribute(Attribute.create(RuleKeys.INSTREET)).attribute(Attribute.create(RuleKeys.INSPHERE)).attribute(Attribute.create(RuleKeys.GAMESTAGE)).attribute(Attribute.create(RuleKeys.PASSIVE)).attribute(Attribute.create(RuleKeys.HOSTILE)).attribute(Attribute.create(RuleKeys.BABY)).attribute(Attribute.create(RuleKeys.SEESKY)).attribute(Attribute.create(RuleKeys.SLIME)).attribute(Attribute.create(RuleKeys.WEATHER)).attribute(Attribute.createMulti(RuleKeys.BIOMETAGS)).attribute(Attribute.create(RuleKeys.DIFFICULTY)).attribute(Attribute.create(RuleKeys.STRUCTURE)).attribute(Attribute.create(RuleKeys.WINTER)).attribute(Attribute.create(RuleKeys.SUMMER)).attribute(Attribute.create(RuleKeys.SPRING)).attribute(Attribute.create(RuleKeys.AUTUMN)).attribute(Attribute.createMulti(RuleKeys.MOB)).attribute(Attribute.createMulti(RuleKeys.MOD)).attribute(Attribute.createMulti(RuleKeys.BLOCK)).attribute(Attribute.create(RuleKeys.BLOCKOFFSET)).attribute(Attribute.createMulti(RuleKeys.BIOME)).attribute(Attribute.createMulti(RuleKeys.BIOMETYPE)).attribute(Attribute.createMulti(RuleKeys.DIMENSION)).attribute(Attribute.createMulti(RuleKeys.DIMENSION_MOD)).attribute(Attribute.create(RuleKeys.STATE)).attribute(Attribute.createMulti(RuleKeys.SCOREBOARDTAGS_ALL)).attribute(Attribute.createMulti(RuleKeys.SCOREBOARDTAGS_ANY)).attribute(Attribute.createMulti(RuleKeys.HELMET)).attribute(Attribute.createMulti(RuleKeys.CHESTPLATE)).attribute(Attribute.createMulti(RuleKeys.LEGGINGS)).attribute(Attribute.createMulti(RuleKeys.BOOTS)).attribute(Attribute.createMulti(RuleKeys.AMULET)).attribute(Attribute.createMulti(RuleKeys.RING)).attribute(Attribute.createMulti(RuleKeys.BELT)).attribute(Attribute.createMulti(RuleKeys.TRINKET)).attribute(Attribute.createMulti(RuleKeys.HEAD)).attribute(Attribute.createMulti(RuleKeys.BODY)).attribute(Attribute.createMulti(RuleKeys.CHARM)).attribute(Attribute.createMulti(RuleKeys.PLAYER_HELDITEM)).attribute(Attribute.createMulti(RuleKeys.OFFHANDITEM)).attribute(Attribute.createMulti(RuleKeys.BOTHHANDSITEM)).attribute(Attribute.create(RuleKeys.ACTION_CONTINUE)).attribute(Attribute.create(RuleKeys.ACTION_RESULT)).attribute(Attribute.create(RuleKeys.ACTION_MESSAGE)).attribute(Attribute.create(RuleKeys.ACTION_ADDSCOREBOARDTAGS)).attribute(Attribute.create(RuleKeys.ACTION_HEALTHSET)).attribute(Attribute.create(RuleKeys.ACTION_HEALTHMULTIPLY)).attribute(Attribute.create(RuleKeys.ACTION_HEALTHADD)).attribute(Attribute.create(RuleKeys.ACTION_SPEEDSET)).attribute(Attribute.create(RuleKeys.ACTION_SPEEDMULTIPLY)).attribute(Attribute.create(RuleKeys.ACTION_SPEEDADD)).attribute(Attribute.create(RuleKeys.ACTION_DAMAGESET)).attribute(Attribute.create(RuleKeys.ACTION_DAMAGEMULTIPLY)).attribute(Attribute.create(RuleKeys.ACTION_DAMAGEADD)).attribute(Attribute.create(RuleKeys.ACTION_SIZEMULTIPLY)).attribute(Attribute.create(RuleKeys.ACTION_SIZEADD)).attribute(Attribute.create(RuleKeys.ACTION_ANGRY)).attribute(Attribute.create(RuleKeys.ACTION_MOBNBT)).attribute(Attribute.create(RuleKeys.ACTION_CUSTOMNAME)).attribute(Attribute.createMulti(RuleKeys.ACTION_HELDITEM)).attribute(Attribute.createMulti(RuleKeys.ACTION_ARMORBOOTS)).attribute(Attribute.createMulti(RuleKeys.ACTION_ARMORLEGS)).attribute(Attribute.createMulti(RuleKeys.ACTION_ARMORCHEST)).attribute(Attribute.createMulti(RuleKeys.ACTION_ARMORHELMET)).attribute(Attribute.createMulti(RuleKeys.ACTION_POTION)).attribute(Attribute.create(RuleKeys.ACTION_NODESPAWN));
    }
}

