/*
 * Decompiled with CFR 0.152.
 */
package org.zeith.hammerlib.net.packets;

import io.netty.buffer.Unpooled;
import net.minecraft.client.Minecraft;
import net.minecraft.client.multiplayer.ClientLevel;
import net.minecraft.core.BlockPos;
import net.minecraft.network.FriendlyByteBuf;
import net.minecraftforge.api.distmarker.Dist;
import net.minecraftforge.api.distmarker.OnlyIn;
import org.zeith.hammerlib.net.IPacket;
import org.zeith.hammerlib.net.MainThreaded;
import org.zeith.hammerlib.net.PacketContext;
import org.zeith.hammerlib.net.properties.IPropertyTile;
import org.zeith.hammerlib.util.java.Cast;

@MainThreaded
public class SendPropertiesPacket
implements IPacket {
    long pos;
    byte[] data;

    public SendPropertiesPacket(long pos, byte[] data) {
        this.pos = pos;
        this.data = data;
    }

    @Override
    public void write(FriendlyByteBuf buf) {
        buf.writeLong(this.pos);
        buf.writeShort(this.data.length);
        buf.writeBytes(this.data);
    }

    @Override
    public void read(FriendlyByteBuf buf) {
        this.pos = buf.readLong();
        this.data = new byte[buf.readShort()];
        buf.readBytes(this.data);
    }

    @Override
    @OnlyIn(value=Dist.CLIENT)
    public void clientExecute(PacketContext ctx) {
        IPropertyTile tile;
        ClientLevel cw = Minecraft.m_91087_().f_91073_;
        if (cw != null && (tile = Cast.cast(cw.m_7702_(BlockPos.m_122022_((long)this.pos)), IPropertyTile.class)) != null) {
            FriendlyByteBuf buf = new FriendlyByteBuf(Unpooled.wrappedBuffer((byte[])this.data));
            tile.getProperties().decodeChanges(buf);
        }
    }
}

