/*
 * Decompiled with CFR 0.152.
 */
package org.zeith.hammerlib.net.lft;

import com.google.common.base.Predicates;
import java.io.IOException;
import java.io.PipedInputStream;
import java.io.PipedOutputStream;
import java.util.ArrayList;
import java.util.List;
import java.util.Map;
import java.util.UUID;
import java.util.function.Predicate;
import net.minecraft.resources.ResourceKey;
import net.minecraft.server.MinecraftServer;
import net.minecraft.server.level.ServerPlayer;
import net.minecraft.world.level.Level;
import net.minecraft.world.phys.Vec3;
import net.minecraftforge.fml.LogicalSide;
import net.minecraftforge.fml.util.thread.SidedThreadGroup;
import net.minecraftforge.fml.util.thread.SidedThreadGroups;
import net.minecraftforge.server.ServerLifecycleHooks;
import org.zeith.hammerlib.HammerLib;
import org.zeith.hammerlib.net.HLTargetPoint;
import org.zeith.hammerlib.net.IPacket;
import org.zeith.hammerlib.net.Network;
import org.zeith.hammerlib.net.PacketContext;
import org.zeith.hammerlib.net.lft.ITransportAcceptor;
import org.zeith.hammerlib.net.lft.NetTransport;
import org.zeith.hammerlib.net.lft.PacketTransportInfo;
import org.zeith.hammerlib.util.mcf.LogicalSidePredictor;

public class TransportSession {
    final Class<? extends ITransportAcceptor> acceptor;
    final List<byte[]> pending;
    final ITransportAcceptor acceptori;
    final PipedOutputStream pos;
    final PipedInputStream pis;
    public final String id;
    final int length;
    final LogicalSide createSide;
    private Thread readThread;

    public TransportSession(String id, Class<? extends ITransportAcceptor> acceptor, List<byte[]> data, ITransportAcceptor ai, int length) {
        this.id = id;
        this.acceptor = acceptor;
        this.pending = data;
        this.acceptori = ai;
        this.length = length;
        this.createSide = LogicalSidePredictor.getCurrentLogicalSide();
        PipedInputStream pis = null;
        PipedOutputStream pos = null;
        if (ai != null) {
            pis = new PipedInputStream(length);
            try {
                pos = new PipedOutputStream(pis);
            }
            catch (IOException iOException) {
                // empty catch block
            }
        }
        this.pis = pis;
        this.pos = pos;
        if (ai != null) {
            SidedThreadGroup stg = this.createSide == LogicalSide.SERVER ? SidedThreadGroups.SERVER : SidedThreadGroups.CLIENT;
            this.readThread = stg.newThread(() -> ai.read(this.pis, length));
            this.readThread.start();
            NetTransport.indexSession(this);
        }
    }

    PacketTransportInfo genPacket() {
        NetTransport.indexSession(this);
        return new PacketTransportInfo(this.id, this.acceptor.getName(), this.length);
    }

    public PacketTransportInfo createPacket() {
        return TransportSession.genCopy(this).genPacket();
    }

    public void sendTo(ServerPlayer player) {
        Network.sendTo((IPacket)this.createPacket(), player);
    }

    public void sendToServer() {
        Network.sendToServer(this.createPacket());
    }

    public void sendToAll() {
        this.sendToPlayersIf((Predicate<ServerPlayer>)Predicates.alwaysTrue());
    }

    public void sendToDimension(ResourceKey<Level> dim) {
        this.sendToPlayersIf(mp -> mp.f_19853_.m_46472_().compareTo(dim) == 0);
    }

    public void sendToNearby(HLTargetPoint tp) {
        this.sendToPlayersIf(mp -> mp.f_19853_.m_46472_().compareTo(tp.dim) == 0 && Math.sqrt(mp.m_20182_().m_82554_((Vec3)tp)) <= tp.range);
    }

    public void sendToPlayersIf(Predicate<ServerPlayer> predicate) {
        MinecraftServer mcs = ServerLifecycleHooks.getCurrentServer();
        if (mcs != null) {
            for (ServerPlayer mp : mcs.m_6846_().m_11314_()) {
                if (!predicate.test(mp)) continue;
                this.sendTo(mp);
            }
        }
    }

    public void sendToMultiplePlayers(ServerPlayer ... players) {
        for (int i = 0; i < players.length; ++i) {
            this.sendTo(players[i]);
        }
    }

    void accept(byte[] data) {
        if (this.pos != null) {
            try {
                this.pos.write(data);
                this.pos.flush();
            }
            catch (IOException iOException) {
                // empty catch block
            }
        }
    }

    void end(PacketContext ctx) {
        Map<String, TransportSession> m;
        ITransportAcceptor acp = this.acceptori;
        if (this.readThread != null) {
            try {
                this.readThread.join(1000L);
            }
            catch (InterruptedException e) {
                e.printStackTrace();
                this.readThread.interrupt();
                HammerLib.LOG.error("------- Transport acceptor " + this.acceptor + " failed to read passed data in time it was given, aborting the transmit completion.");
                acp = null;
            }
            this.readThread = null;
        }
        if (acp != null) {
            acp.onTransmissionComplete(ctx);
        }
        if ((m = NetTransport.SESSIONS.get(this.createSide)) != null) {
            m.remove(this.id);
        }
    }

    public static TransportSession genCopy(TransportSession session) {
        ArrayList<byte[]> matrix = new ArrayList<byte[]>(session.pending);
        for (int i = 0; i < matrix.size(); ++i) {
            matrix.set(i, (byte[])((byte[])matrix.get(i)).clone());
        }
        return new TransportSession(UUID.randomUUID().toString(), session.acceptor, matrix, null, session.length);
    }
}

