/*
 * Decompiled with CFR 0.152.
 */
package org.zeith.hammerlib.core.adapter;

import java.lang.reflect.InvocationTargetException;
import java.lang.reflect.Modifier;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;
import java.util.Map;
import java.util.Optional;
import java.util.concurrent.ConcurrentHashMap;
import java.util.function.BiConsumer;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.util.Tuple;
import net.minecraft.world.item.BlockItem;
import net.minecraft.world.item.Item;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.block.entity.BlockEntityType;
import net.minecraftforge.api.distmarker.Dist;
import net.minecraftforge.fml.event.lifecycle.FMLClientSetupEvent;
import net.minecraftforge.fml.event.lifecycle.FMLCommonSetupEvent;
import net.minecraftforge.fml.loading.FMLEnvironment;
import net.minecraftforge.registries.IForgeRegistry;
import net.minecraftforge.registries.RegisterEvent;
import org.zeith.api.registry.RegistryMapping;
import org.zeith.hammerlib.HammerLib;
import org.zeith.hammerlib.annotations.OnlyIf;
import org.zeith.hammerlib.annotations.RegistryName;
import org.zeith.hammerlib.annotations.Setup;
import org.zeith.hammerlib.annotations.SimplyRegister;
import org.zeith.hammerlib.annotations.client.ClientSetup;
import org.zeith.hammerlib.annotations.client.TileRenderer;
import org.zeith.hammerlib.api.blocks.ICreativeTabBlock;
import org.zeith.hammerlib.api.blocks.ICustomBlockItem;
import org.zeith.hammerlib.api.blocks.IItemPropertySupplier;
import org.zeith.hammerlib.api.blocks.INoItemBlock;
import org.zeith.hammerlib.api.fml.ICustomRegistrar;
import org.zeith.hammerlib.api.fml.IRegisterListener;
import org.zeith.hammerlib.core.adapter.OnlyIfAdapter;
import org.zeith.hammerlib.util.java.Cast;
import org.zeith.hammerlib.util.java.ReflectionUtil;

public class RegistryAdapter {
    private static final Map<Class<?>, List<Tuple<Block, ResourceLocation>>> blocks = new ConcurrentHashMap();

    public static <T> BiConsumer<ResourceLocation, T> createRegisterer(IForgeRegistry<T> registry, String prefix) {
        return (name, entry) -> {
            name = new ResourceLocation(name.m_135827_(), prefix + name.m_135815_());
            IRegisterListener l = Cast.cast(entry, IRegisterListener.class);
            if (l != null) {
                l.onPreRegistered();
            }
            registry.register(name, entry);
            if (l != null) {
                l.onPostRegistered();
            }
        };
    }

    public static int register(RegisterEvent event, Class<?> source, String modid, String prefix) {
        IForgeRegistry reg = event.getForgeRegistry();
        if (reg == null) {
            reg = RegistryMapping.getRegistryByType(RegistryMapping.getSuperType(event.getRegistryKey()));
        }
        return RegistryAdapter.register(event, reg, source, modid, prefix);
    }

    public static <T> int register(RegisterEvent event, IForgeRegistry<T> registry, Class<?> source, String modid, String prefix) {
        Class superType = RegistryMapping.getSuperType(registry);
        if (superType == null) {
            return 0;
        }
        List blockList = blocks.computeIfAbsent(source, s -> new ArrayList());
        BiConsumer<ResourceLocation, Object> grabber = RegistryAdapter.createRegisterer(registry, prefix).andThen((key, handler) -> {
            if (handler instanceof Block) {
                Block b = (Block)handler;
                blockList.add(new Tuple((Object)b, key));
            }
        });
        if (Item.class.equals(superType)) {
            for (Tuple e : blockList) {
                BlockItem item;
                Block blk = (Block)e.m_14418_();
                if (blk instanceof INoItemBlock) continue;
                IItemPropertySupplier gen = Cast.cast(blk, IItemPropertySupplier.class);
                if (blk instanceof ICustomBlockItem) {
                    item = ((ICustomBlockItem)blk).createBlockItem();
                } else {
                    Item.Properties props;
                    Item.Properties properties = props = gen != null ? gen.createItemProperties(new Item.Properties()) : new Item.Properties();
                    if (blk instanceof ICreativeTabBlock) {
                        props = props.m_41491_(((ICreativeTabBlock)blk).getCreativeTab());
                    }
                    item = new BlockItem(blk, props);
                }
                grabber.accept((ResourceLocation)e.m_14419_(), Cast.cast(item));
            }
        }
        boolean tileRegistryOnClient = BlockEntityType.class.equals(superType) && FMLEnvironment.dist == Dist.CLIENT;
        int prevSize = registry.getValues().size();
        Arrays.stream(source.getDeclaredFields()).filter(f -> ICustomRegistrar.class.isAssignableFrom(f.getType())).forEach(field -> {
            if (Modifier.isStatic(field.getModifiers()) && Modifier.isFinal(field.getModifiers())) {
                try {
                    field.setAccessible(true);
                    RegistryName name = field.getAnnotation(RegistryName.class);
                    ResourceLocation rl = new ResourceLocation(modid, prefix + name.value());
                    Object val = field.get(null);
                    OnlyIf onlyIf = field.getAnnotation(OnlyIf.class);
                    if ((!RegistryMapping.isNonIntrusive(registry) || OnlyIfAdapter.checkCondition(onlyIf, source.toString(), superType.getSimpleName(), val, rl)) && val instanceof ICustomRegistrar) {
                        ICustomRegistrar cr = (ICustomRegistrar)val;
                        cr.performRegister(event, rl);
                    }
                }
                catch (IllegalAccessException | IllegalArgumentException e) {
                    e.printStackTrace();
                }
            }
        });
        Arrays.stream(source.getDeclaredMethods()).filter(m -> m.getAnnotation(SimplyRegister.class) != null && m.getParameterCount() == 1 && BiConsumer.class.isAssignableFrom(m.getParameterTypes()[0]) && ReflectionUtil.doesParameterTypeArgsMatch(m.getParameters()[0], ResourceLocation.class, superType)).forEach(method -> {
            String prefix2 = Optional.ofNullable(method.getAnnotation(SimplyRegister.class)).map(SimplyRegister::prefix).orElse("");
            if (Modifier.isStatic(method.getModifiers())) {
                try {
                    method.setAccessible(true);
                    BiConsumer<ResourceLocation, Object> grabber2 = (id, obj) -> {
                        id = new ResourceLocation(id.m_135827_(), prefix2 + id.m_135815_());
                        grabber.accept((ResourceLocation)id, obj);
                    };
                    method.invoke(null, grabber2);
                }
                catch (IllegalAccessException | IllegalArgumentException | InvocationTargetException e) {
                    e.printStackTrace();
                }
            }
        });
        Arrays.stream(source.getDeclaredFields()).filter(f -> superType.isAssignableFrom(f.getType())).forEach(field -> {
            if (Modifier.isStatic(field.getModifiers()) && Modifier.isFinal(field.getModifiers())) {
                try {
                    field.setAccessible(true);
                    RegistryName name = field.getAnnotation(RegistryName.class);
                    ResourceLocation rl = new ResourceLocation(modid, name.value());
                    Object val = field.get(null);
                    OnlyIf onlyIf = field.getAnnotation(OnlyIf.class);
                    if (!RegistryMapping.isNonIntrusive(registry) || OnlyIfAdapter.checkCondition(onlyIf, source.toString(), superType.getSimpleName(), val, rl)) {
                        TileRenderer.RendererInfo tesr;
                        Object fval = superType.cast(val);
                        grabber.accept(rl, fval);
                        if (tileRegistryOnClient && (tesr = TileRenderer.RendererTarget.get(source, field.getName())) != null) {
                            tesr.apply();
                            HammerLib.LOG.debug("Applied TESR registration for " + field.getType().getSimpleName() + "[" + registry.getKey(fval) + "] " + source.getSimpleName() + "." + field.getName());
                        }
                    }
                }
                catch (IllegalAccessException | IllegalArgumentException e) {
                    e.printStackTrace();
                }
            }
        });
        return registry.getValues().size() - prevSize;
    }

    public static void setup(FMLCommonSetupEvent event, Class<?> source, String memberName) {
        String methodName = memberName.substring(0, memberName.indexOf(40));
        Arrays.stream(source.getDeclaredMethods()).filter(m -> m.getAnnotation(Setup.class) != null && m.getName().equals(methodName)).forEach(method -> {
            if (Modifier.isStatic(method.getModifiers())) {
                try {
                    OnlyIf onlyIf = method.getAnnotation(OnlyIf.class);
                    if (!OnlyIfAdapter.checkCondition(onlyIf, source.toString(), "Setup", null, null)) {
                        return;
                    }
                    method.setAccessible(true);
                    if (method.getParameterCount() == 0) {
                        method.invoke(null, new Object[0]);
                    } else if (method.getParameterCount() == 1 && method.getParameterTypes()[0] == FMLCommonSetupEvent.class) {
                        method.invoke(null, event);
                    }
                }
                catch (IllegalAccessException | IllegalArgumentException | InvocationTargetException e) {
                    RuntimeException re = null;
                    if (e instanceof InvocationTargetException && e.getCause() instanceof RuntimeException) {
                        re = (RuntimeException)e.getCause();
                    }
                    if (e instanceof RuntimeException) {
                        re = (RuntimeException)e;
                    }
                    if (re != null) {
                        throw re;
                    }
                    e.printStackTrace();
                }
            }
        });
    }

    public static void clientSetup(FMLClientSetupEvent event, Class<?> source, String memberName) {
        String methodName = memberName.substring(0, memberName.indexOf(40));
        Arrays.stream(source.getDeclaredMethods()).filter(m -> m.getAnnotation(ClientSetup.class) != null && m.getName().equals(methodName)).forEach(method -> {
            if (Modifier.isStatic(method.getModifiers())) {
                try {
                    OnlyIf onlyIf = method.getAnnotation(OnlyIf.class);
                    if (!OnlyIfAdapter.checkCondition(onlyIf, source.toString(), "ClientSetup", null, null)) {
                        return;
                    }
                    method.setAccessible(true);
                    if (method.getParameterCount() == 0) {
                        method.invoke(null, new Object[0]);
                    } else if (method.getParameterCount() == 1 && method.getParameterTypes()[0] == FMLClientSetupEvent.class) {
                        method.invoke(null, event);
                    }
                }
                catch (IllegalAccessException | IllegalArgumentException | InvocationTargetException e) {
                    RuntimeException re = null;
                    if (e instanceof InvocationTargetException && e.getCause() instanceof RuntimeException) {
                        re = (RuntimeException)e.getCause();
                    }
                    if (e instanceof RuntimeException) {
                        re = (RuntimeException)e;
                    }
                    if (re != null) {
                        throw re;
                    }
                    e.printStackTrace();
                }
            }
        });
    }
}

