/*
 * Decompiled with CFR 0.152.
 */
package org.zeith.hammerlib.api.crafting.building;

import com.google.gson.JsonElement;
import com.google.gson.JsonObject;
import java.io.BufferedReader;
import java.io.BufferedWriter;
import java.io.IOException;
import java.util.Optional;
import java.util.function.Function;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.server.MinecraftServer;
import net.minecraft.server.packs.resources.Resource;
import net.minecraftforge.common.crafting.conditions.ICondition;
import org.zeith.hammerlib.api.crafting.IGeneralRecipe;
import org.zeith.hammerlib.api.crafting.itf.IFileDecoder;
import org.zeith.hammerlib.util.java.Cast;
import org.zeith.hammerlib.util.mcf.itf.INetworkable;

public abstract class CustomRecipeGenerator<T extends IGeneralRecipe, DEC extends IFileDecoder<IO>, IO> {
    protected final String defaultDir;
    protected final DEC decoder;

    public CustomRecipeGenerator(ResourceLocation registryPath, Function<String, DEC> decoder) {
        this.defaultDir = "recipes_hl/" + registryPath.m_135827_() + "/" + registryPath.m_135815_();
        this.decoder = (IFileDecoder)decoder.apply(this.defaultDir);
    }

    public final String getFileDir() {
        return this.defaultDir;
    }

    public boolean pathMatches(ResourceLocation path) {
        return this.decoder.doesPathMatch(path);
    }

    public abstract Optional<T> decodeRecipe(ResourceLocation var1, IO var2, MinecraftServer var3, ICondition.IContext var4);

    public Optional<IO> createTemplate() {
        return Optional.empty();
    }

    protected JsonElement itemStackTemplate() {
        JsonObject $ = new JsonObject();
        $.addProperty("item", "example:item_stack");
        return $;
    }

    protected JsonElement ingredientTemplate() {
        JsonObject $ = new JsonObject();
        $.addProperty("tag", "example:ingredient");
        return $;
    }

    public Optional<T> readRecipe(ResourceLocation path, Resource resource, MinecraftServer server, ICondition.IContext context) throws IOException {
        if (this.decoder != null) {
            try (BufferedReader in = resource.m_215508_();){
                ResourceLocation rid = this.decoder.transformPathToId(path);
                Optional optional = rid == null ? Optional.empty() : this.decoder.tryDecode(path, in).flatMap(io -> this.decodeRecipe(rid, io, server, context));
                return optional;
            }
        }
        return Optional.empty();
    }

    public boolean createExampleRecipe(Resource.IoSupplier<BufferedWriter> writer) throws IOException {
        Object template = this.createTemplate().orElse(null);
        if (template != null) {
            try (BufferedWriter wr = (BufferedWriter)writer.m_215511_();){
                this.decoder.write(template, wr);
                boolean bl = true;
                return bl;
            }
        }
        return false;
    }

    public Optional<INetworkable<T>> getSerializer() {
        Optional<INetworkable<T>> net = Cast.optionally(this, INetworkable.class);
        return net;
    }
}

