/*
 * Decompiled with CFR 0.152.
 */
package org.zeith.hammerlib.api.crafting;

import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import java.util.UUID;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.server.MinecraftServer;
import net.minecraft.server.level.ServerPlayer;
import net.minecraftforge.api.distmarker.Dist;
import net.minecraftforge.api.distmarker.OnlyIn;
import net.minecraftforge.common.crafting.conditions.ICondition;
import net.minecraftforge.event.server.ServerStartingEvent;
import net.minecraftforge.event.server.ServerStoppingEvent;
import net.minecraftforge.eventbus.api.SubscribeEvent;
import net.minecraftforge.fml.common.Mod;
import net.minecraftforge.server.ServerLifecycleHooks;
import org.zeith.hammerlib.HammerLib;
import org.zeith.hammerlib.api.crafting.IGeneralRecipe;
import org.zeith.hammerlib.api.crafting.IRecipeContainer;
import org.zeith.hammerlib.api.crafting.building.CustomRecipeGenerator;
import org.zeith.hammerlib.api.crafting.building.GeneralRecipeBuilder;
import org.zeith.hammerlib.api.crafting.building.IRecipeBuilderFactory;
import org.zeith.hammerlib.event.listeners.TagsUpdateListener;
import org.zeith.hammerlib.event.recipe.ReloadRecipeRegistryEvent;
import org.zeith.hammerlib.util.mcf.itf.INetworkable;
import org.zeith.hammerlib.util.mcf.itf.IRecipeRegistrationEvent;
import org.zeith.hammerlib.util.shaded.json.JSONObject;

@Mod.EventBusSubscriber
public abstract class AbstractRecipeRegistry<T extends IGeneralRecipe, CTR extends IRecipeContainer<T>, IDX> {
    private static final List<AbstractRecipeRegistry<?, ?, ?>> ALL_REGISTRIES = new ArrayList();
    private static final List<AbstractRecipeRegistry<?, ?, ?>> ALL_REGISTRIES_VIEW = Collections.unmodifiableList(ALL_REGISTRIES);
    protected final Class<T> type;
    protected final CTR container;
    protected final CustomRecipeGenerator<T, ?, ?> custom;
    private final ResourceLocation id;
    private UUID activeSyncSession;
    IRecipeBuilderFactory<T, ?> recipeBuilder;

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public AbstractRecipeRegistry(Class<T> type, CTR container, ResourceLocation id, CustomRecipeGenerator<T, ?, ?> custom) {
        if (HammerLib.PROXY.hasFinishedLoading()) {
            throw new IllegalStateException("Attempted to create recipe registry for type " + type.getName() + " too late! Please do it in construct or preInit!");
        }
        this.id = id;
        this.type = type;
        this.container = container;
        this.custom = custom;
        List<AbstractRecipeRegistry<?, ?, ?>> list = ALL_REGISTRIES;
        synchronized (list) {
            ALL_REGISTRIES.add(this);
        }
        HammerLib.LOG.info("Allocated new instance of " + this.getClass().getName() + " with id " + JSONObject.quote(id.toString()));
    }

    public void syncToPlayer(ServerPlayer player) {
    }

    @OnlyIn(value=Dist.CLIENT)
    public void addClientSideRecipe(T recipe, UUID transportSession) {
        if (!Objects.equals(this.activeSyncSession, transportSession)) {
            this.activeSyncSession = transportSession;
            this.resetClientRecipes();
        }
    }

    @OnlyIn(value=Dist.CLIENT)
    public void resetClientRecipes() {
    }

    @OnlyIn(value=Dist.CLIENT)
    public void addClientsideContents() {
        HammerLib.postEvent(new ReloadRecipeRegistryEvent.Pre(this));
        this.removeStaticRecipes();
        int prev = this.getRecipeCount();
        HammerLib.postEvent(new ReloadRecipeRegistryEvent.AddRecipes(this, TagsUpdateListener.REMOTE_TAG_ACCESS, null));
        HammerLib.LOG.info("Added " + (this.getRecipeCount() - prev) + " static recipes into recipe registry " + this.id);
        HammerLib.postEvent(new ReloadRecipeRegistryEvent.Post(this));
    }

    public Optional<INetworkable<T>> getNetworkSerializer() {
        return this.custom != null ? this.custom.getSerializer() : Optional.empty();
    }

    public GeneralRecipeBuilder<T, ?> builder(IRecipeRegistrationEvent<T> event) {
        if (this.recipeBuilder != null) {
            return this.recipeBuilder.newBuilder(event);
        }
        throw new UnsupportedOperationException("Building is not supported for " + this.getClass().getSimpleName() + "<" + this.type.getSimpleName() + ">{" + this.id + "}");
    }

    public abstract IDX addRecipe(T var1);

    public abstract void removeRecipe(T var1);

    protected abstract void removeAllRecipes();

    protected abstract void removeStaticRecipes();

    public abstract T getRecipe(IDX var1);

    public Collection<T> getRecipes() {
        return this.container.getRecipes();
    }

    public int getRecipeCount() {
        return this.container.getRecipeCount();
    }

    public Class<T> getRecipeType() {
        return this.type;
    }

    public static List<AbstractRecipeRegistry<?, ?, ?>> getAllRegistries() {
        return ALL_REGISTRIES_VIEW;
    }

    public ResourceLocation getRegistryId() {
        return this.id;
    }

    @Deprecated(forRemoval=true)
    public void reload() {
        this.reload(null, TagsUpdateListener.REMOTE_TAG_ACCESS);
    }

    public void reload(MinecraftServer server, ICondition.IContext context) {
        if (server == null) {
            server = ServerLifecycleHooks.getCurrentServer();
        }
        HammerLib.postEvent(new ReloadRecipeRegistryEvent.Pre(this));
        this.removeAllRecipes();
        this.reloadDatapackRecipes(server, context);
        HammerLib.postEvent(new ReloadRecipeRegistryEvent.AddRecipes(this, context, server));
        HammerLib.postEvent(new ReloadRecipeRegistryEvent.Post(this));
    }

    protected void reloadDatapackRecipes(MinecraftServer server, ICondition.IContext context) {
    }

    @SubscribeEvent
    public static void serverStart(ServerStartingEvent e) {
        HammerLib.LOG.info("Reloading recipes in " + ALL_REGISTRIES.size() + " HL recipe registries.");
        for (AbstractRecipeRegistry<?, ?, ?> reg : ALL_REGISTRIES) {
            reg.reload(e.getServer(), e.getServer().getServerResources().f_206585_().getConditionContext());
        }
    }

    @SubscribeEvent
    public static void serverStop(ServerStoppingEvent e) {
        HammerLib.LOG.info("Purging cache from " + ALL_REGISTRIES.size() + " HL recipe registries.");
        for (AbstractRecipeRegistry<?, ?, ?> reg : ALL_REGISTRIES) {
            reg.removeAllRecipes();
        }
    }
}

