/*
 * Decompiled with CFR 0.152.
 */
package org.zeith.hammerlib.api;

import java.util.ArrayList;
import java.util.HashMap;
import java.util.Map;
import java.util.function.BiConsumer;
import net.minecraft.world.entity.player.Player;
import org.zeith.hammerlib.HammerLib;
import org.zeith.hammerlib.event.LanguageReloadEvent;

public class LanguageHelper {
    public static void reloadLanguage(BiConsumer<String, String> handler) {
        String lng = HammerLib.PROXY.getLanguage();
        ArrayList<String> langs = new ArrayList<String>();
        langs.add("en_us");
        if (!langs.contains(lng)) {
            langs.add(lng);
        }
        LangMap exist = new LangMap(lng);
        LanguageHelper.reloadLang("en_us", exist);
        if (!lng.equals("en_us")) {
            LanguageHelper.reloadLang(lng, exist);
        }
        exist.apply(handler);
    }

    private static void reloadLang(String lang, LangMap lmap) {
        HammerLib.postEvent(new LanguageReloadEvent(lmap, lang));
    }

    public static String getLanguage(Player player) {
        return HammerLib.PROXY.getLanguage(player);
    }

    public static class LangMap
    extends HashMap<String, String> {
        final String lang;
        boolean dirty;

        public LangMap(String lng) {
            this.lang = lng;
        }

        public void translate(String key, String value) {
            this.put(key, value);
            this.dirty = true;
        }

        public boolean isDirty() {
            return this.dirty;
        }

        public void setDirty(boolean dirty) {
            this.dirty = dirty;
        }

        public void apply(Map<String, String> langs) {
            langs.putAll(this);
        }

        public void apply(BiConsumer<String, String> langs) {
            for (Map.Entry e : this.entrySet()) {
                langs.accept((String)e.getKey(), (String)e.getValue());
            }
        }
    }
}

