/*
 * Decompiled with CFR 0.152.
 */
package org.zeith.hammerlib.annotations.client;

import java.lang.annotation.ElementType;
import java.lang.annotation.Retention;
import java.lang.annotation.RetentionPolicy;
import java.lang.annotation.Target;
import java.util.HashMap;
import java.util.Map;
import net.minecraft.Util;
import net.minecraftforge.api.distmarker.Dist;
import net.minecraftforge.fml.DistExecutor;
import org.jetbrains.annotations.ApiStatus;
import org.objectweb.asm.Type;
import org.zeith.hammerlib.HammerLib;
import org.zeith.hammerlib.util.mcf.ScanDataHelper;

@Retention(value=RetentionPolicy.CLASS)
@Target(value={ElementType.FIELD})
public @interface TileRenderer {
    public Class<?> value();

    @ApiStatus.Internal
    public record RendererInfo(Runnable applicant) {
        public void apply() {
            this.applicant.run();
        }
    }

    @ApiStatus.Internal
    public record RendererTarget(Type owner, String field) {
        public static final Map<RendererTarget, RendererInfo> TILE_RENDERS = (Map)DistExecutor.unsafeCallWhenOn((Dist)Dist.CLIENT, () -> () -> (HashMap)Util.m_137469_(new HashMap(), map -> ScanDataHelper.lookupAnnotatedObjects(TileRenderer.class).forEach(data -> {
            if (data.getTargetType() == ElementType.FIELD) {
                data.getOwnerMod().ifPresent(mc -> map.put(new RendererTarget(data.clazz(), data.getMemberName()), new RendererInfo(() -> mc.getEventBus().addListener(HammerLib.PROXY.addTESR(data.clazz(), data.getMemberName(), data.getProperty("value").map(Type.class::cast).orElse(null))))));
            }
        })));

        public static RendererInfo get(Class<?> cls, String field) {
            return TILE_RENDERS.get(new RendererTarget(Type.getType(cls), field));
        }
    }
}

