/*
 * Decompiled with CFR 0.152.
 */
package cofh.archersparadox.entity.projectile;

import cofh.archersparadox.init.APEntities;
import cofh.archersparadox.init.APItems;
import cofh.core.config.IBaseConfig;
import cofh.lib.item.ArrowItemCoFH;
import cofh.lib.util.Utils;
import java.util.function.Supplier;
import javax.annotation.Nullable;
import net.minecraft.core.particles.ParticleOptions;
import net.minecraft.core.particles.ParticleTypes;
import net.minecraft.network.protocol.Packet;
import net.minecraft.network.syncher.EntityDataAccessor;
import net.minecraft.network.syncher.EntityDataSerializer;
import net.minecraft.network.syncher.EntityDataSerializers;
import net.minecraft.network.syncher.SynchedEntityData;
import net.minecraft.world.effect.MobEffectInstance;
import net.minecraft.world.effect.MobEffects;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.EntityType;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.entity.projectile.AbstractArrow;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.level.ItemLike;
import net.minecraft.world.level.Level;
import net.minecraft.world.phys.AABB;
import net.minecraft.world.phys.EntityHitResult;
import net.minecraft.world.phys.Vec3;
import net.minecraftforge.common.ForgeConfigSpec;
import net.minecraftforge.network.NetworkHooks;

public class ShulkerArrow
extends AbstractArrow {
    private static final EntityDataAccessor<Integer> TARGET = SynchedEntityData.m_135353_(ShulkerArrow.class, (EntityDataSerializer)EntityDataSerializers.f_135028_);
    private static final int ID_NO_TARGET = -1;
    private static final float MAX_VELOCITY = 3.0f;
    private static final double SEEK_DISTANCE = 5.0;
    private static final double SEEK_FACTOR = 0.2;
    private static final double SEEK_ANGLE = 0.5235987755982988;
    private static final double SEEK_THRESHOLD = 0.5;
    public static float defaultDamage = 2.5f;
    public static int effectDuration = 100;
    public static final ArrowItemCoFH.IArrowFactory<AbstractArrow> FACTORY = new ArrowItemCoFH.IArrowFactory<AbstractArrow>(){

        public AbstractArrow createArrow(Level world, LivingEntity living) {
            return new ShulkerArrow(world, living);
        }

        public AbstractArrow createArrow(Level world, double posX, double posY, double posZ) {
            return new ShulkerArrow(world, posX, posY, posZ);
        }
    };
    public static final IBaseConfig CONFIG = new IBaseConfig(){
        private Supplier<Double> cfgDamage;
        private Supplier<Integer> cfgDuration;

        public void apply(ForgeConfigSpec.Builder builder) {
            String name = "Shulker Arrow";
            builder.push(name);
            this.cfgDamage = builder.comment("Adjust this to set the damage for the " + name + ". Vanilla Arrow value is 2.0.").defineInRange("Damage", (double)defaultDamage, 0.0, 16.0);
            this.cfgDuration = builder.comment("Adjust this to set the effect duration (Levitation) for the " + name + ". (In ticks; there are 20 ticks per second).").defineInRange("Effect Duration", effectDuration, 20, 1200);
            builder.pop();
        }

        public void refresh() {
            defaultDamage = this.cfgDamage.get().floatValue();
            effectDuration = this.cfgDuration.get();
        }
    };

    public ShulkerArrow(EntityType<? extends ShulkerArrow> entityIn, Level worldIn) {
        super(entityIn, worldIn);
        this.f_36698_ = defaultDamage;
    }

    public ShulkerArrow(Level worldIn, LivingEntity shooter) {
        super((EntityType)APEntities.SHULKER_ARROW.get(), shooter, worldIn);
        this.f_36698_ = defaultDamage;
    }

    public ShulkerArrow(Level worldIn, double x, double y, double z) {
        super((EntityType)APEntities.SHULKER_ARROW.get(), x, y, z, worldIn);
        this.f_36698_ = defaultDamage;
    }

    protected void m_8097_() {
        super.m_8097_();
        this.m_20088_().m_135372_(TARGET, (Object)-1);
    }

    protected ItemStack m_7941_() {
        return new ItemStack((ItemLike)APItems.SHULKER_ARROW_ITEM.get());
    }

    protected void m_5790_(EntityHitResult raytraceResultIn) {
        super.m_5790_(raytraceResultIn);
        Entity entity = raytraceResultIn.m_82443_();
        if (!entity.m_20147_() && entity instanceof LivingEntity && effectDuration > 0) {
            LivingEntity living = (LivingEntity)entity;
            living.m_7292_(new MobEffectInstance(MobEffects.f_19620_, effectDuration));
        }
    }

    public void m_20254_(int seconds) {
    }

    public void m_8119_() {
        if (!this.f_36703_) {
            Entity target;
            if (Utils.isServerWorld((Level)this.f_19853_)) {
                this.updateTarget();
            }
            if ((target = this.getTarget()) != null) {
                Vec3 targetVec = this.getVectorToTarget(target).m_82490_(0.2);
                Vec3 courseVec = this.m_20184_();
                double courseLen = courseVec.m_82553_();
                double targetLen = targetVec.m_82553_();
                double totalLen = Math.sqrt(courseLen * courseLen + targetLen * targetLen);
                double dotProduct = courseVec.m_82526_(targetVec) / (courseLen * targetLen);
                if (dotProduct > 0.5) {
                    Vec3 newMotion = courseVec.m_82490_(courseLen / totalLen).m_82549_(targetVec.m_82490_(targetLen / totalLen)).m_82541_().m_82490_(3.0);
                    this.m_20334_(newMotion.f_82479_, newMotion.f_82480_ + (double)0.05f, newMotion.f_82481_);
                } else if (Utils.isServerWorld((Level)this.f_19853_)) {
                    this.setTarget(null);
                }
                if (Utils.isClientWorld((Level)this.f_19853_)) {
                    Vec3 vec3d = this.m_20184_().m_82490_(0.25);
                    double d1 = vec3d.f_82479_;
                    double d2 = vec3d.f_82480_;
                    double d0 = vec3d.f_82481_;
                    this.f_19853_.m_7106_((ParticleOptions)ParticleTypes.f_123810_, this.m_20185_() + d1, this.m_20186_() + d2, this.m_20189_() + d0, -d1, -d2 + 0.2, -d0);
                }
            }
        }
        super.m_8119_();
    }

    public Packet<?> m_5654_() {
        return NetworkHooks.getEntitySpawningPacket((Entity)this);
    }

    private void updateTarget() {
        if (this.m_20069_() || this.m_20077_()) {
            this.setTarget(null);
            return;
        }
        Entity target = this.getTarget();
        if (target != null && !target.m_6084_()) {
            target = null;
            this.setTarget(null);
        }
        if (target == null) {
            AABB positionBB;
            AABB targetBB = positionBB = new AABB(this.m_20185_(), this.m_20186_(), this.m_20189_(), this.m_20185_(), this.m_20186_(), this.m_20189_());
            Vec3 courseVec = this.m_20184_().m_82490_(5.0).m_82524_(0.5235988f);
            targetBB = targetBB.m_82367_(positionBB.m_82383_(courseVec));
            courseVec = this.m_20184_().m_82490_(5.0).m_82524_(-0.5235988f);
            targetBB = targetBB.m_82367_(positionBB.m_82383_(courseVec));
            targetBB = targetBB.m_82377_(0.0, 2.5, 0.0);
            double closestDot = -1.0;
            LivingEntity closestTarget = null;
            for (LivingEntity living : this.f_19853_.m_45976_(LivingEntity.class, targetBB)) {
                Vec3 targetVec;
                Vec3 motionVec;
                double dot;
                if (living instanceof Player || !((dot = (motionVec = this.m_20184_().m_82541_()).m_82526_(targetVec = this.getVectorToTarget((Entity)living).m_82541_())) > Math.max(closestDot, 0.5))) continue;
                closestDot = dot;
                closestTarget = living;
            }
            if (closestTarget != null) {
                this.setTarget((Entity)closestTarget);
            }
        }
    }

    private Vec3 getVectorToTarget(Entity target) {
        return new Vec3(target.m_20185_() - this.m_20185_(), target.m_20186_() + (double)target.m_20192_() - this.m_20186_(), target.m_20189_() - this.m_20189_());
    }

    @Nullable
    private Entity getTarget() {
        return this.f_19853_.m_6815_(((Integer)this.f_19804_.m_135370_(TARGET)).intValue());
    }

    private void setTarget(@Nullable Entity e) {
        this.f_19804_.m_135381_(TARGET, (Object)(e == null ? -1 : e.m_19879_()));
    }
}

