/*
 * Decompiled with CFR 0.152.
 */
package thelm.jaopca.items;

import java.util.Optional;
import java.util.OptionalInt;
import net.minecraft.network.chat.Component;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.Rarity;
import net.minecraft.world.item.crafting.RecipeType;
import thelm.jaopca.api.forms.IForm;
import thelm.jaopca.api.items.IItemFormSettings;
import thelm.jaopca.api.items.IMaterialFormItem;
import thelm.jaopca.api.materials.IMaterial;
import thelm.jaopca.items.ItemFormType;
import thelm.jaopca.utils.ApiImpl;

public class JAOPCAItem
extends Item
implements IMaterialFormItem {
    private final IForm form;
    private final IMaterial material;
    protected final IItemFormSettings settings;
    protected OptionalInt f_41370_ = OptionalInt.empty();
    protected Optional<Boolean> hasEffect = Optional.empty();
    protected Optional<Rarity> f_41369_ = Optional.empty();
    protected OptionalInt burnTime = OptionalInt.empty();

    public JAOPCAItem(IForm form, IMaterial material, IItemFormSettings settings) {
        super(new Item.Properties().m_41491_(ItemFormType.getCreativeTab()));
        this.form = form;
        this.material = material;
        this.settings = settings;
    }

    @Override
    public IForm getForm() {
        return this.form;
    }

    @Override
    public IMaterial getMaterial() {
        return this.material;
    }

    public int getMaxStackSize(ItemStack stack) {
        if (!this.f_41370_.isPresent()) {
            this.f_41370_ = OptionalInt.of(this.settings.getMaxStackSizeFunction().applyAsInt(this.material));
        }
        return this.f_41370_.getAsInt();
    }

    public boolean m_5812_(ItemStack stack) {
        if (!this.hasEffect.isPresent()) {
            this.hasEffect = Optional.of(this.settings.getHasEffectFunction().test(this.material));
        }
        return this.hasEffect.get() != false || super.m_5812_(stack);
    }

    public Rarity m_41460_(ItemStack stack) {
        if (!this.f_41369_.isPresent()) {
            this.f_41369_ = Optional.of((Rarity)this.settings.getDisplayRarityFunction().apply((Object)this.material));
        }
        return this.f_41369_.get();
    }

    public int getBurnTime(ItemStack itemStack, RecipeType<?> recipeType) {
        if (!this.burnTime.isPresent()) {
            this.burnTime = OptionalInt.of(this.settings.getBurnTimeFunction().applyAsInt(this.material));
        }
        return this.burnTime.getAsInt();
    }

    public Component m_7626_(ItemStack stack) {
        return ApiImpl.INSTANCE.currentLocalizer().localizeMaterialForm("item.jaopca." + this.form.getName(), this.material, this.m_5671_(stack));
    }
}

