/*
 * Decompiled with CFR 0.152.
 */
package thelm.jaopca.fluids;

import java.util.Optional;
import java.util.OptionalInt;
import net.minecraft.advancements.CriteriaTriggers;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Direction;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.network.chat.Component;
import net.minecraft.server.level.ServerPlayer;
import net.minecraft.sounds.SoundEvent;
import net.minecraft.sounds.SoundEvents;
import net.minecraft.sounds.SoundSource;
import net.minecraft.stats.Stats;
import net.minecraft.tags.FluidTags;
import net.minecraft.world.InteractionHand;
import net.minecraft.world.InteractionResultHolder;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.Items;
import net.minecraft.world.item.Rarity;
import net.minecraft.world.item.crafting.RecipeType;
import net.minecraft.world.level.BlockAndTintGetter;
import net.minecraft.world.level.BlockGetter;
import net.minecraft.world.level.ClipContext;
import net.minecraft.world.level.ItemLike;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.LevelAccessor;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.block.LiquidBlockContainer;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.level.gameevent.GameEvent;
import net.minecraft.world.level.material.Material;
import net.minecraft.world.phys.BlockHitResult;
import net.minecraft.world.phys.HitResult;
import net.minecraftforge.common.SoundActions;
import net.minecraftforge.common.capabilities.ICapabilityProvider;
import net.minecraftforge.event.ForgeEventFactory;
import net.minecraftforge.fluids.FluidStack;
import thelm.jaopca.api.fluids.IFluidFormSettings;
import thelm.jaopca.api.fluids.IMaterialFormBucketItem;
import thelm.jaopca.api.fluids.IMaterialFormFluid;
import thelm.jaopca.api.forms.IForm;
import thelm.jaopca.api.materials.IMaterial;
import thelm.jaopca.fluids.JAOPCAFluidHandlerItem;
import thelm.jaopca.items.ItemFormType;
import thelm.jaopca.utils.ApiImpl;

public class JAOPCABucketItem
extends Item
implements IMaterialFormBucketItem {
    private final IMaterialFormFluid fluid;
    private final IFluidFormSettings settings;
    private OptionalInt maxStackSize = OptionalInt.empty();
    private Optional<Boolean> hasEffect = Optional.empty();
    private Optional<Rarity> rarity = Optional.empty();
    private OptionalInt burnTime = OptionalInt.empty();

    public JAOPCABucketItem(IMaterialFormFluid fluid, IFluidFormSettings settings) {
        super(new Item.Properties().m_41495_(Items.f_42446_).m_41491_(ItemFormType.getCreativeTab()));
        this.fluid = fluid;
        this.settings = settings;
    }

    @Override
    public IForm getForm() {
        return this.fluid.getForm();
    }

    @Override
    public IMaterial getMaterial() {
        return this.fluid.getMaterial();
    }

    public int getMaxStackSize(ItemStack stack) {
        if (!this.maxStackSize.isPresent()) {
            this.maxStackSize = OptionalInt.of(this.settings.getMaxStackSizeFunction().applyAsInt(this.getMaterial()));
        }
        return this.maxStackSize.getAsInt();
    }

    public boolean m_5812_(ItemStack stack) {
        if (!this.hasEffect.isPresent()) {
            this.hasEffect = Optional.of(this.settings.getHasEffectFunction().test(this.getMaterial()));
        }
        return this.hasEffect.get() != false || super.m_5812_(stack);
    }

    public Rarity m_41460_(ItemStack stack) {
        if (!this.rarity.isPresent()) {
            this.rarity = Optional.of(this.settings.getDisplayRarityFunction().apply(this.getMaterial()));
        }
        return this.rarity.get();
    }

    public int getBurnTime(ItemStack itemStack, RecipeType<?> recipeType) {
        if (!this.burnTime.isPresent()) {
            this.burnTime = OptionalInt.of(this.settings.getBurnTimeFunction().applyAsInt(this.getMaterial()));
        }
        return this.burnTime.getAsInt();
    }

    public InteractionResultHolder<ItemStack> m_7203_(Level world, Player player, InteractionHand hand) {
        BlockHitResult blockHitResult;
        ItemStack stack = player.m_21120_(hand);
        InteractionResultHolder ret = ForgeEventFactory.onBucketUse((Player)player, (Level)world, (ItemStack)stack, (HitResult)(blockHitResult = JAOPCABucketItem.m_41435_((Level)world, (Player)player, (ClipContext.Fluid)ClipContext.Fluid.NONE)));
        if (ret != null) {
            return ret;
        }
        if (blockHitResult.m_6662_() == HitResult.Type.MISS) {
            return InteractionResultHolder.m_19098_((Object)stack);
        }
        if (blockHitResult.m_6662_() != HitResult.Type.BLOCK) {
            return InteractionResultHolder.m_19098_((Object)stack);
        }
        BlockPos resultPos = blockHitResult.m_82425_();
        Direction direction = blockHitResult.m_82434_();
        BlockPos offsetPos = resultPos.m_121945_(blockHitResult.m_82434_());
        if (world.m_7966_(player, resultPos) && player.m_36204_(offsetPos, direction, stack)) {
            BlockPos placePos;
            BlockState state = world.m_8055_(resultPos);
            BlockPos blockPos = placePos = this.canBlockContainFluid(world, resultPos, state) ? resultPos : offsetPos;
            if (this.emptyContents(player, world, placePos, blockHitResult)) {
                this.checkExtraContent(player, world, stack, placePos);
                if (player instanceof ServerPlayer) {
                    CriteriaTriggers.f_10591_.m_59469_((ServerPlayer)player, placePos, stack);
                }
                player.m_36246_(Stats.f_12982_.m_12902_((Object)this));
                return InteractionResultHolder.m_19092_((Object)this.getEmptySuccessItem(stack, player), (boolean)world.f_46443_);
            }
            return InteractionResultHolder.m_19100_((Object)stack);
        }
        return InteractionResultHolder.m_19100_((Object)stack);
    }

    protected ItemStack getEmptySuccessItem(ItemStack stack, Player player) {
        return !player.m_150110_().f_35937_ ? new ItemStack((ItemLike)Items.f_42446_) : stack;
    }

    public void checkExtraContent(Player player, Level world, ItemStack stack, BlockPos pos) {
    }

    public boolean emptyContents(Player player, Level world, BlockPos pos, BlockHitResult blockHitResult) {
        LiquidBlockContainer container;
        LiquidBlockContainer container2;
        boolean flag1;
        BlockState blockState = world.m_8055_(pos);
        Block block = blockState.m_60734_();
        Material blockMaterial = blockState.m_60767_();
        boolean flag = blockState.m_60722_(this.fluid.asFluid());
        boolean bl = flag1 = blockState.m_60795_() || flag || block instanceof LiquidBlockContainer && (container2 = (LiquidBlockContainer)block).m_6044_((BlockGetter)world, pos, blockState, this.fluid.asFluid());
        if (!flag1) {
            return blockHitResult != null && this.emptyContents(player, world, blockHitResult.m_82425_().m_121945_(blockHitResult.m_82434_()), null);
        }
        FluidStack stack = new FluidStack(this.fluid.asFluid(), 1000);
        if (this.fluid.asFluid().getFluidType().isVaporizedOnPlacement(world, pos, stack)) {
            this.fluid.asFluid().getFluidType().onVaporize(player, world, pos, stack);
            return true;
        }
        if (block instanceof LiquidBlockContainer && (container = (LiquidBlockContainer)block).m_6044_((BlockGetter)world, pos, blockState, this.fluid.asFluid())) {
            container.m_7361_((LevelAccessor)world, pos, blockState, this.fluid.asFluid().m_76145_());
            this.playEmptySound(player, (LevelAccessor)world, pos);
            return true;
        }
        if (!world.f_46443_ && flag && !blockMaterial.m_76332_()) {
            world.m_46961_(pos, true);
        }
        if (!world.m_7731_(pos, this.fluid.asFluid().getFluidType().getStateForPlacement((BlockAndTintGetter)world, pos, stack).m_76188_(), 11) && !blockState.m_60819_().m_76170_()) {
            return false;
        }
        this.playEmptySound(player, (LevelAccessor)world, pos);
        return true;
    }

    protected void playEmptySound(Player player, LevelAccessor world, BlockPos pos) {
        SoundEvent soundEvent = this.fluid.asFluid().getFluidType().getSound(SoundActions.BUCKET_EMPTY);
        if (soundEvent == null) {
            soundEvent = this.fluid.asFluid().m_205067_(FluidTags.f_13132_) ? SoundEvents.f_11780_ : SoundEvents.f_11778_;
        }
        world.m_5594_(player, pos, soundEvent, SoundSource.BLOCKS, 1.0f, 1.0f);
        world.m_142346_((Entity)player, GameEvent.f_157769_, pos);
    }

    protected boolean canBlockContainFluid(Level worldIn, BlockPos posIn, BlockState blockstate) {
        return blockstate.m_60734_() instanceof LiquidBlockContainer && ((LiquidBlockContainer)blockstate.m_60734_()).m_6044_((BlockGetter)worldIn, posIn, blockstate, this.fluid.asFluid());
    }

    public ICapabilityProvider initCapabilities(ItemStack stack, CompoundTag nbt) {
        return new JAOPCAFluidHandlerItem(this.fluid, stack);
    }

    public Component m_7626_(ItemStack stack) {
        return ApiImpl.INSTANCE.currentLocalizer().localizeMaterialForm("item.jaopca." + this.getForm().getName(), this.getMaterial(), this.m_5671_(stack));
    }
}

