/*
 * Decompiled with CFR 0.152.
 */
package thelm.jaopca.custom.json;

import com.google.gson.JsonDeserializationContext;
import com.google.gson.JsonDeserializer;
import com.google.gson.JsonElement;
import com.google.gson.JsonObject;
import com.google.gson.JsonParseException;
import java.lang.reflect.Type;
import java.util.function.Function;
import java.util.function.Predicate;
import java.util.function.Supplier;
import java.util.function.ToDoubleFunction;
import java.util.function.ToIntFunction;
import net.minecraft.world.item.Rarity;
import net.minecraft.world.level.pathfinder.BlockPathTypes;
import thelm.jaopca.api.fluids.IFluidFormSettings;
import thelm.jaopca.blocks.BlockFormType;
import thelm.jaopca.fluids.FluidFormType;
import thelm.jaopca.forms.FormTypeHandler;
import thelm.jaopca.utils.JsonHelper;

public class FluidFormSettingsDeserializer
implements JsonDeserializer<IFluidFormSettings> {
    public static final FluidFormSettingsDeserializer INSTANCE = new FluidFormSettingsDeserializer();

    private FluidFormSettingsDeserializer() {
    }

    public IFluidFormSettings deserialize(JsonElement jsonElement, JsonDeserializationContext context) {
        return this.deserialize(jsonElement, (Type)((Object)IFluidFormSettings.class), context);
    }

    public IFluidFormSettings deserialize(JsonElement jsonElement, Type typeOfT, JsonDeserializationContext context) throws JsonParseException {
        JsonObject functionJson;
        JsonHelper helper = JsonHelper.INSTANCE;
        JsonObject json = helper.getJsonObject(jsonElement, "settings");
        IFluidFormSettings settings = FluidFormType.INSTANCE.getNewSettings();
        if (json.has("maxLevel")) {
            functionJson = helper.getJsonObject(json, "maxLevel");
            if (!functionJson.has("default")) {
                functionJson.addProperty("default", (Number)8);
            }
            settings.setMaxLevelFunction((ToIntFunction)helper.deserializeType(json, "maxLevel", context, FormTypeHandler.INT_FUNCTION_TYPE));
        }
        if (json.has("tickRate")) {
            functionJson = helper.getJsonObject(json, "tickRate");
            if (!functionJson.has("default")) {
                functionJson.addProperty("default", (Number)5);
            }
            settings.setTickRateFunction((ToIntFunction)helper.deserializeType(json, "tickRate", context, FormTypeHandler.INT_FUNCTION_TYPE));
        }
        if (json.has("explosionResistance")) {
            functionJson = helper.getJsonObject(json, "explosionResistance");
            if (!functionJson.has("default")) {
                functionJson.addProperty("default", (Number)100);
            }
            settings.setExplosionResistanceFunction((ToDoubleFunction)helper.deserializeType(json, "explosionResistance", context, FormTypeHandler.DOUBLE_FUNCTION_TYPE));
        }
        if (json.has("lightValue")) {
            functionJson = helper.getJsonObject(json, "lightValue");
            if (!functionJson.has("default")) {
                functionJson.addProperty("default", (Number)0);
            }
            settings.setLightValueFunction((ToIntFunction)helper.deserializeType(json, "lightValue", context, FormTypeHandler.INT_FUNCTION_TYPE));
        }
        if (json.has("density")) {
            functionJson = helper.getJsonObject(json, "density");
            if (!functionJson.has("default")) {
                functionJson.addProperty("default", (Number)1000);
            }
            settings.setDensityFunction((ToIntFunction)helper.deserializeType(json, "density", context, FormTypeHandler.INT_FUNCTION_TYPE));
        }
        if (json.has("temperature")) {
            functionJson = helper.getJsonObject(json, "temperature");
            if (!functionJson.has("default")) {
                functionJson.addProperty("default", (Number)300);
            }
            settings.setTemperatureFunction((ToIntFunction)helper.deserializeType(json, "temperature", context, FormTypeHandler.INT_FUNCTION_TYPE));
        }
        if (json.has("viscosity")) {
            functionJson = helper.getJsonObject(json, "viscosity");
            if (!functionJson.has("default")) {
                functionJson.addProperty("default", (Number)1000);
            }
            settings.setViscosityFunction((ToIntFunction)helper.deserializeType(json, "viscosity", context, FormTypeHandler.INT_FUNCTION_TYPE));
        }
        if (json.has("rarity")) {
            Rarity rarity = (Rarity)helper.deserializeType(json, "rarity", context, (Type)((Object)Rarity.class));
            settings.setDisplayRarityFunction(m -> rarity);
        }
        if (json.has("fillSound")) {
            settings.setFillSoundSupplier((Supplier)helper.deserializeType(json, "fillSound", context, FluidFormType.SOUND_EVENT_SUPPLIER_TYPE));
        }
        if (json.has("emptySound")) {
            settings.setEmptySoundSupplier((Supplier)helper.deserializeType(json, "emptySound", context, FluidFormType.SOUND_EVENT_SUPPLIER_TYPE));
        }
        if (json.has("vaporizeSound")) {
            settings.setVaporizeSoundSupplier((Supplier)helper.deserializeType(json, "vaporizeSound", context, FluidFormType.SOUND_EVENT_SUPPLIER_TYPE));
        }
        if (json.has("motionScale")) {
            functionJson = helper.getJsonObject(json, "motionScale");
            if (!functionJson.has("default")) {
                functionJson.addProperty("default", (Number)0.0023333333333333335);
            }
            settings.setMotionScaleFunction((ToDoubleFunction)helper.deserializeType(json, "motionScale", context, FormTypeHandler.DOUBLE_FUNCTION_TYPE));
        }
        if (json.has("canPushEntity")) {
            functionJson = helper.getJsonObject(json, "canPushEntity");
            if (!functionJson.has("default")) {
                functionJson.addProperty("default", Boolean.valueOf(true));
            }
            settings.setCanPushEntityFunction((Predicate)helper.deserializeType(json, "canPushEntity", context, FormTypeHandler.PREDICATE_TYPE));
        }
        if (json.has("canSwim")) {
            functionJson = helper.getJsonObject(json, "canSwim");
            if (!functionJson.has("default")) {
                functionJson.addProperty("default", Boolean.valueOf(false));
            }
            settings.setCanSwimFunction((Predicate)helper.deserializeType(json, "canSwim", context, FormTypeHandler.PREDICATE_TYPE));
        }
        if (json.has("fallDistanceModifier")) {
            functionJson = helper.getJsonObject(json, "fallDistanceModifier");
            if (!functionJson.has("default")) {
                functionJson.addProperty("default", (Number)0.5);
            }
            settings.setFallDistanceModifierFunction((ToDoubleFunction)helper.deserializeType(json, "fallDistanceModifier", context, FormTypeHandler.DOUBLE_FUNCTION_TYPE));
        }
        if (json.has("canExtingush")) {
            functionJson = helper.getJsonObject(json, "canExtingush");
            if (!functionJson.has("default")) {
                functionJson.addProperty("default", Boolean.valueOf(false));
            }
            settings.setCanExtinguishFunction((Predicate)helper.deserializeType(json, "canExtingush", context, FormTypeHandler.PREDICATE_TYPE));
        }
        if (json.has("canDrown")) {
            functionJson = helper.getJsonObject(json, "canDrown");
            if (!functionJson.has("default")) {
                functionJson.addProperty("default", Boolean.valueOf(false));
            }
            settings.setCanDrownFunction((Predicate)helper.deserializeType(json, "canDrown", context, FormTypeHandler.PREDICATE_TYPE));
        }
        if (json.has("supportsBoating")) {
            functionJson = helper.getJsonObject(json, "supportsBoating");
            if (!functionJson.has("default")) {
                functionJson.addProperty("default", Boolean.valueOf(false));
            }
            settings.setSupportsBoatingFunction((Predicate)helper.deserializeType(json, "supportsBoating", context, FormTypeHandler.PREDICATE_TYPE));
        }
        if (json.has("canHydrate")) {
            functionJson = helper.getJsonObject(json, "canHydrate");
            if (!functionJson.has("default")) {
                functionJson.addProperty("default", Boolean.valueOf(false));
            }
            settings.setCanHydrateFunction((Predicate)helper.deserializeType(json, "canHydrate", context, FormTypeHandler.PREDICATE_TYPE));
        }
        if (json.has("canConvertToSource")) {
            functionJson = helper.getJsonObject(json, "canConvertToSource");
            if (!functionJson.has("default")) {
                functionJson.addProperty("default", Boolean.valueOf(false));
            }
            settings.setCanConvertToSourceFunction((Predicate)helper.deserializeType(json, "canConvertToSource", context, FormTypeHandler.PREDICATE_TYPE));
        }
        if (json.has("pathType")) {
            BlockPathTypes pathType = (BlockPathTypes)helper.deserializeType(json, "pathType", context, (Type)((Object)BlockPathTypes.class));
            settings.setPathTypeFunction(m -> pathType);
        }
        if (json.has("adjacentPathType")) {
            BlockPathTypes adjacentPathType = (BlockPathTypes)helper.deserializeType(json, "adjacentPathType", context, (Type)((Object)BlockPathTypes.class));
            settings.setAdjacentPathTypeFunction(m -> adjacentPathType);
        }
        if (json.has("levelDecreasePerBlock")) {
            functionJson = helper.getJsonObject(json, "levelDecreasePerBlock");
            if (!functionJson.has("default")) {
                functionJson.addProperty("default", (Number)1);
            }
            settings.setLevelDecreasePerBlockFunction((ToIntFunction)helper.deserializeType(json, "levelDecreasePerBlock", context, FormTypeHandler.INT_FUNCTION_TYPE));
        }
        if (json.has("blockMaterial")) {
            functionJson = helper.getJsonObject(json, "blockMaterial");
            if (!functionJson.has("default")) {
                functionJson.addProperty("default", "lava");
            }
            settings.setMaterialFunction((Function)helper.deserializeType(json, "blockMaterial", context, BlockFormType.MATERIAL_FUNCTION_TYPE));
        }
        if (json.has("blockHardness")) {
            functionJson = helper.getJsonObject(json, "blockHardness");
            if (!functionJson.has("default")) {
                functionJson.addProperty("default", (Number)5);
            }
            settings.setBlockHardnessFunction((ToDoubleFunction)helper.deserializeType(json, "blockHardness", context, FormTypeHandler.DOUBLE_FUNCTION_TYPE));
        }
        if (json.has("flammability")) {
            functionJson = helper.getJsonObject(json, "flammability");
            if (!functionJson.has("default")) {
                functionJson.addProperty("default", (Number)0);
            }
            settings.setFlammabilityFunction((ToIntFunction)helper.deserializeType(json, "flammability", context, FormTypeHandler.INT_FUNCTION_TYPE));
        }
        if (json.has("fireSpreadSpeed")) {
            functionJson = helper.getJsonObject(json, "fireSpreadSpeed");
            if (!functionJson.has("default")) {
                functionJson.addProperty("default", (Number)0);
            }
            settings.setFireSpreadSpeedFunction((ToIntFunction)helper.deserializeType(json, "fireSpreadSpeed", context, FormTypeHandler.INT_FUNCTION_TYPE));
        }
        if (json.has("isFireSource")) {
            functionJson = helper.getJsonObject(json, "isFireSource");
            if (!functionJson.has("default")) {
                functionJson.addProperty("default", Boolean.valueOf(false));
            }
            settings.setIsFireSourceFunction((Predicate)helper.deserializeType(json, "isFireSource", context, FormTypeHandler.PREDICATE_TYPE));
        }
        if (json.has("maxStackSize")) {
            functionJson = helper.getJsonObject(json, "maxStackSize");
            if (!functionJson.has("default")) {
                functionJson.addProperty("default", (Number)1);
            }
            settings.setMaxStackSizeFunction((ToIntFunction)helper.deserializeType(json, "maxStackSize", context, FormTypeHandler.INT_FUNCTION_TYPE));
        }
        if (json.has("hasEffect")) {
            boolean hasEffect = helper.getBoolean(json, "hasEffect");
            settings.setHasEffectFunction(m -> m.hasEffect() || hasEffect);
        }
        if (json.has("burnTime")) {
            JsonObject functionJson2 = helper.getJsonObject(json, "burnTime");
            if (!functionJson2.has("default")) {
                functionJson2.addProperty("default", (Number)-1);
            }
            settings.setBurnTimeFunction((ToIntFunction)helper.deserializeType(json, "burnTime", context, FormTypeHandler.INT_FUNCTION_TYPE));
        }
        return settings;
    }
}

