/*
 * Decompiled with CFR 0.152.
 */
package thelm.jaopca.compat.mekanism.recipes;

import com.google.gson.JsonElement;
import com.google.gson.JsonObject;
import java.util.Objects;
import mekanism.api.SerializerHelper;
import mekanism.api.chemical.ChemicalStack;
import mekanism.api.chemical.merged.BoxedChemicalStack;
import mekanism.api.chemical.slurry.SlurryStack;
import mekanism.api.recipes.ingredients.ChemicalStackIngredient;
import mekanism.api.recipes.ingredients.ItemStackIngredient;
import net.minecraft.resources.ResourceLocation;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;
import thelm.jaopca.api.recipes.IRecipeSerializer;
import thelm.jaopca.compat.mekanism.MekanismHelper;

public class DissolutionRecipeSerializer
implements IRecipeSerializer {
    private static final Logger LOGGER = LogManager.getLogger();
    public final ResourceLocation key;
    public final Object itemInput;
    public final int itemInputCount;
    public final Object gasInput;
    public final int gasInputAmount;
    public final Object output;
    public final int outputCount;

    public DissolutionRecipeSerializer(ResourceLocation key, Object itemInput, int itemInputCount, Object gasInput, int gasInputAmount, Object output, int outputCount) {
        this.key = Objects.requireNonNull(key);
        this.itemInput = itemInput;
        this.itemInputCount = itemInputCount;
        this.gasInput = gasInput;
        this.gasInputAmount = gasInputAmount;
        this.output = output;
        this.outputCount = outputCount;
    }

    @Override
    public JsonElement get() {
        ItemStackIngredient ing = MekanismHelper.INSTANCE.getItemStackIngredient(this.itemInput, this.itemInputCount);
        if (ing == null) {
            throw new IllegalArgumentException("Empty ingredient in recipe " + this.key + ": " + this.itemInput);
        }
        ChemicalStackIngredient.GasStackIngredient gasIng = MekanismHelper.INSTANCE.getGasStackIngredient(this.gasInput, this.gasInputAmount);
        if (gasIng == null) {
            throw new IllegalArgumentException("Empty ingredient in recipe " + this.key + ": " + this.gasInput);
        }
        SlurryStack stack = MekanismHelper.INSTANCE.getSlurryStack(this.output, this.outputCount);
        if (stack.isEmpty()) {
            throw new IllegalArgumentException("Empty output in recipe " + this.key + ": " + this.output);
        }
        JsonObject json = new JsonObject();
        json.addProperty("type", "mekanism:dissolution");
        json.add("itemInput", ing.serialize());
        json.add("gasInput", gasIng.serialize());
        json.add("output", SerializerHelper.serializeBoxedChemicalStack((BoxedChemicalStack)BoxedChemicalStack.box((ChemicalStack)stack)));
        return json;
    }
}

