/*
 * Decompiled with CFR 0.152.
 */
package thelm.jaopca.compat.electrodynamics.recipes;

import com.google.gson.JsonElement;
import com.google.gson.JsonObject;
import java.util.Objects;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.crafting.Ingredient;
import net.minecraftforge.common.crafting.IntersectionIngredient;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;
import thelm.jaopca.api.recipes.IRecipeSerializer;
import thelm.jaopca.ingredients.EmptyIngredient;
import thelm.jaopca.utils.MiscHelper;

public class MineralGrinderRecipeSerializer
implements IRecipeSerializer {
    private static final Logger LOGGER = LogManager.getLogger();
    public final ResourceLocation key;
    public final Object input;
    public final int inputCount;
    public final Object output;
    public final int outputCount;
    public final Object secondOutput;
    public final int secondOutputCount;
    public final double secondChance;
    public final double experience;
    public final int time;
    public final double energy;

    public MineralGrinderRecipeSerializer(ResourceLocation key, Object input, int inputCount, Object output, int outputCount, double experience, int time, double energy) {
        this(key, input, inputCount, output, outputCount, ItemStack.f_41583_, 0, 0.0, experience, time, energy);
    }

    public MineralGrinderRecipeSerializer(ResourceLocation key, Object input, int inputCount, Object output, int outputCount, Object secondOutput, int secondOutputCount, double secondChance, double experience, int time, double energy) {
        this.key = Objects.requireNonNull(key);
        this.input = input;
        this.inputCount = inputCount;
        this.output = output;
        this.outputCount = outputCount;
        this.secondOutput = secondOutput;
        this.secondOutputCount = secondOutputCount;
        this.secondChance = secondChance;
        this.experience = experience;
        this.time = time;
        this.energy = energy;
    }

    @Override
    public JsonElement get() {
        Ingredient ing = MiscHelper.INSTANCE.getIngredient(this.input);
        if (ing == EmptyIngredient.INSTANCE) {
            throw new IllegalArgumentException("Empty ingredient in recipe " + this.key + ": " + this.input);
        }
        ItemStack stack = MiscHelper.INSTANCE.getItemStack(this.output, this.outputCount);
        if (stack.m_41619_()) {
            throw new IllegalArgumentException("Empty output in recipe " + this.key + ": " + this.output);
        }
        ItemStack secondStack = MiscHelper.INSTANCE.getItemStack(this.secondOutput, this.secondOutputCount);
        JsonObject json = new JsonObject();
        json.addProperty("type", "electrodynamics:mineral_grinder_recipe");
        JsonObject itemInputJson = new JsonObject();
        itemInputJson.addProperty("count", (Number)1);
        JsonObject ingJson = IntersectionIngredient.of((Ingredient[])new Ingredient[]{ing}).m_43942_().getAsJsonObject();
        ingJson.addProperty("count", (Number)this.inputCount);
        itemInputJson.add("0", (JsonElement)ingJson);
        json.add("iteminputs", (JsonElement)itemInputJson);
        json.add("output", (JsonElement)MiscHelper.INSTANCE.serializeItemStack(stack));
        if (!secondStack.m_41619_()) {
            JsonObject secondJson = new JsonObject();
            secondJson.addProperty("count", (Number)1);
            JsonObject secondResultJson = MiscHelper.INSTANCE.serializeItemStack(secondStack);
            secondResultJson.addProperty("chance", (Number)this.secondChance);
            secondJson.add("0", (JsonElement)secondResultJson);
            json.add("itembi", (JsonElement)secondJson);
        }
        json.addProperty("experience", (Number)this.experience);
        json.addProperty("ticks", (Number)this.time);
        json.addProperty("usagepertick", (Number)this.energy);
        return json;
    }
}

