/*
 * Decompiled with CFR 0.152.
 */
package thelm.jaopca.client.events;

import net.minecraft.client.renderer.ItemBlockRenderTypes;
import net.minecraft.client.renderer.RenderType;
import net.minecraft.server.packs.PackType;
import net.minecraft.server.packs.repository.RepositorySource;
import net.minecraft.server.packs.resources.PreparableReloadListener;
import net.minecraft.server.packs.resources.ResourceManager;
import net.minecraft.server.packs.resources.SimplePreparableReloadListener;
import net.minecraft.util.profiling.ProfilerFiller;
import net.minecraft.world.level.material.Fluid;
import net.minecraftforge.client.event.ClientPlayerNetworkEvent;
import net.minecraftforge.client.event.ModelEvent;
import net.minecraftforge.client.event.RegisterClientReloadListenersEvent;
import net.minecraftforge.client.event.RegisterColorHandlersEvent;
import net.minecraftforge.common.MinecraftForge;
import net.minecraftforge.event.AddPackFindersEvent;
import net.minecraftforge.event.TagsUpdatedEvent;
import net.minecraftforge.eventbus.api.SubscribeEvent;
import net.minecraftforge.fml.event.lifecycle.FMLClientSetupEvent;
import thelm.jaopca.api.fluids.IMaterialFormFluid;
import thelm.jaopca.client.colors.ColorHandler;
import thelm.jaopca.client.models.ModelHandler;
import thelm.jaopca.client.resources.ResourceInjector;
import thelm.jaopca.fluids.FluidFormType;
import thelm.jaopca.localization.LocalizationRepoHandler;
import thelm.jaopca.materials.MaterialHandler;
import thelm.jaopca.modules.ModuleHandler;

public class ClientEventHandler {
    public static final ClientEventHandler INSTANCE = new ClientEventHandler();

    public static ClientEventHandler getInstance() {
        return INSTANCE;
    }

    @SubscribeEvent
    public void onClientSetup(FMLClientSetupEvent event) {
        MinecraftForge.EVENT_BUS.addListener(this::onPlayerLoggingIn);
        MinecraftForge.EVENT_BUS.addListener(this::onTagsUpdated);
        LocalizationRepoHandler.setup();
        for (IMaterialFormFluid fluid : FluidFormType.getFluids()) {
            ItemBlockRenderTypes.setRenderLayer((Fluid)fluid.asFluid(), (RenderType)RenderType.m_110466_());
        }
        ModuleHandler.onClientSetup(event);
    }

    @SubscribeEvent
    public void onRegisterClientReloadListeners(RegisterClientReloadListenersEvent event) {
        event.registerReloadListener((PreparableReloadListener)new SimplePreparableReloadListener(){

            protected Object m_5944_(ResourceManager resourceManager, ProfilerFiller profiler) {
                return null;
            }

            protected void m_5787_(Object splashList, ResourceManager resourceManager, ProfilerFiller profiler) {
                LocalizationRepoHandler.reload();
            }
        });
    }

    @SubscribeEvent
    public void onModelRegisterAdditional(ModelEvent.RegisterAdditional event) {
        ModelHandler.registerModels(event);
    }

    @SubscribeEvent
    public void onModelBakingCompleted(ModelEvent.BakingCompleted event) {
        ModelHandler.remapModels(event);
    }

    @SubscribeEvent
    public void onRegisterColorHandlers(RegisterColorHandlersEvent.Item event) {
        ColorHandler.setup(event);
    }

    @SubscribeEvent
    public void onAddPackFinders(AddPackFindersEvent event) {
        if (event.getPackType() == PackType.CLIENT_RESOURCES) {
            event.addRepositorySource((RepositorySource)ResourceInjector.PackFinder.INSTANCE);
        }
    }

    public void onPlayerLoggingIn(ClientPlayerNetworkEvent.LoggingIn event) {
        MaterialHandler.setClientTagsBound(false);
    }

    public void onTagsUpdated(TagsUpdatedEvent event) {
        if (event.getUpdateCause() == TagsUpdatedEvent.UpdateCause.CLIENT_PACKET_RECEIVED) {
            MaterialHandler.setClientTagsBound(true);
        }
    }
}

