/*
 * Decompiled with CFR 0.152.
 */
package thelm.jaopca.blocks;

import java.util.Optional;
import java.util.OptionalDouble;
import java.util.OptionalInt;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Direction;
import net.minecraft.network.chat.MutableComponent;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.level.BlockGetter;
import net.minecraft.world.level.LevelReader;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.block.SoundType;
import net.minecraft.world.level.block.state.BlockBehaviour;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.level.material.Material;
import net.minecraft.world.level.material.MaterialColor;
import net.minecraft.world.phys.shapes.CollisionContext;
import net.minecraft.world.phys.shapes.Shapes;
import net.minecraft.world.phys.shapes.VoxelShape;
import thelm.jaopca.api.blocks.IBlockFormSettings;
import thelm.jaopca.api.blocks.IMaterialFormBlock;
import thelm.jaopca.api.forms.IForm;
import thelm.jaopca.api.materials.IMaterial;
import thelm.jaopca.utils.ApiImpl;

public class JAOPCABlock
extends Block
implements IMaterialFormBlock {
    private final IForm form;
    private final IMaterial material;
    protected final IBlockFormSettings settings;
    protected boolean blocksMovement;
    protected Optional<SoundType> f_60446_ = Optional.empty();
    protected OptionalInt lightValue = OptionalInt.empty();
    protected OptionalDouble f_60444_ = OptionalDouble.empty();
    protected OptionalDouble f_60447_ = OptionalDouble.empty();
    protected VoxelShape shape;
    protected VoxelShape interactionShape;
    protected OptionalInt flammability = OptionalInt.empty();
    protected OptionalInt fireSpreadSpeed = OptionalInt.empty();
    protected Optional<Boolean> isFireSource = Optional.empty();

    public JAOPCABlock(IForm form, IMaterial material, IBlockFormSettings settings) {
        super(BlockBehaviour.Properties.m_60944_((Material)settings.getMaterialFunction().apply(material), (MaterialColor)settings.getMaterialColorFunction().apply(material)).m_60978_((float)settings.getBlockHardnessFunction().applyAsDouble(material)).m_60953_(state -> settings.getLightValueFunction().applyAsInt(material)).m_60955_());
        this.form = form;
        this.material = material;
        this.settings = settings;
        this.blocksMovement = settings.getBlocksMovement();
        this.shape = settings.getShape();
        this.interactionShape = settings.getInteractionShape();
    }

    @Override
    public IForm getForm() {
        return this.form;
    }

    @Override
    public IMaterial getMaterial() {
        return this.material;
    }

    public Block m_7374_() {
        return this;
    }

    public SoundType m_49962_(BlockState blockState) {
        if (!this.f_60446_.isPresent()) {
            this.f_60446_ = Optional.of(this.settings.getSoundTypeFunction().apply(this.material));
        }
        return this.f_60446_.get();
    }

    public int getLightEmission(BlockState state, BlockGetter world, BlockPos pos) {
        if (!this.lightValue.isPresent()) {
            this.lightValue = OptionalInt.of(this.settings.getLightValueFunction().applyAsInt(this.material));
        }
        return this.lightValue.getAsInt();
    }

    public float m_7325_() {
        if (!this.f_60444_.isPresent()) {
            this.f_60444_ = OptionalDouble.of(this.settings.getExplosionResistanceFunction().applyAsDouble(this.material));
        }
        return (float)this.f_60444_.getAsDouble();
    }

    public float getFriction(BlockState blockState, LevelReader world, BlockPos pos, Entity entity) {
        if (!this.f_60447_.isPresent()) {
            this.f_60447_ = OptionalDouble.of(this.settings.getFrictionFunction().applyAsDouble(this.material));
        }
        return (float)this.f_60447_.getAsDouble();
    }

    public VoxelShape m_5940_(BlockState blockState, BlockGetter world, BlockPos pos, CollisionContext context) {
        return this.shape;
    }

    public VoxelShape m_5939_(BlockState blockState, BlockGetter world, BlockPos pos, CollisionContext context) {
        return this.blocksMovement ? blockState.m_60808_(world, pos) : Shapes.m_83040_();
    }

    public VoxelShape m_6079_(BlockState blockState, BlockGetter world, BlockPos pos) {
        return this.interactionShape;
    }

    public int getFlammability(BlockState blockState, BlockGetter world, BlockPos pos, Direction face) {
        if (!this.flammability.isPresent()) {
            this.flammability = OptionalInt.of(this.settings.getFireSpreadSpeedFunction().applyAsInt(this.material));
        }
        return this.flammability.getAsInt();
    }

    public int getFireSpreadSpeed(BlockState blockState, BlockGetter world, BlockPos pos, Direction face) {
        if (!this.fireSpreadSpeed.isPresent()) {
            this.fireSpreadSpeed = OptionalInt.of(this.settings.getFlammabilityFunction().applyAsInt(this.material));
        }
        return this.fireSpreadSpeed.getAsInt();
    }

    public boolean isFireSource(BlockState blockState, LevelReader world, BlockPos pos, Direction side) {
        if (!this.isFireSource.isPresent()) {
            this.isFireSource = Optional.of(this.settings.getIsFireSourceFunction().test(this.material));
        }
        return this.isFireSource.get();
    }

    public MutableComponent m_49954_() {
        return ApiImpl.INSTANCE.currentLocalizer().localizeMaterialForm("block.jaopca." + this.form.getName(), this.material, this.m_7705_());
    }
}

