/*
 * Decompiled with CFR 0.152.
 */
package dev.ftb.ftbsba.tools.content.autohammer;

import dev.ftb.ftbsba.tools.ToolsRegistry;
import dev.ftb.ftbsba.tools.content.autohammer.AutoHammerBlock;
import dev.ftb.ftbsba.tools.content.autohammer.AutoHammerOutputItemHandler;
import dev.ftb.ftbsba.tools.content.autohammer.AutoHammerProperties;
import dev.ftb.ftbsba.tools.recipies.ToolsRecipeCache;
import java.util.List;
import java.util.function.Supplier;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Direction;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.nbt.Tag;
import net.minecraft.tags.BlockTags;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.level.ItemLike;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.block.entity.BlockEntity;
import net.minecraft.world.level.block.entity.BlockEntityType;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.level.block.state.properties.BlockStateProperties;
import net.minecraft.world.level.block.state.properties.Property;
import net.minecraftforge.common.capabilities.Capability;
import net.minecraftforge.common.capabilities.ForgeCapabilities;
import net.minecraftforge.common.util.LazyOptional;
import net.minecraftforge.items.IItemHandler;
import net.minecraftforge.items.ItemHandlerHelper;
import net.minecraftforge.items.ItemStackHandler;
import net.minecraftforge.items.wrapper.EmptyHandler;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class AutoHammerBlockEntity
extends BlockEntity {
    private static final int[][] IO_DIRECTIONAL_MATRIX = new int[][]{{4, 5}, {5, 4}, {3, 2}, {2, 3}};
    private final ItemStackHandler inputInventory = new ItemStackHandler(1){

        public boolean isItemValid(int slot, @NotNull ItemStack stack) {
            AutoHammerProperties props = AutoHammerBlockEntity.this.getProps();
            Block blockOfInput = Block.m_49814_((Item)stack.m_41720_());
            boolean correctToolForDrops = props.getHammerItem().get().isCorrectToolForDrops(new ItemStack((ItemLike)props.getHammerItem().get()), blockOfInput.m_49966_());
            if (correctToolForDrops) {
                return ToolsRecipeCache.hammerable(blockOfInput.m_49966_());
            }
            return false;
        }

        protected void onContentsChanged(int slot) {
            AutoHammerBlockEntity.this.m_6596_();
        }
    };
    private final AutoHammerOutputItemHandler outputInventory = new AutoHammerOutputItemHandler(this, 8);
    private final LazyOptional<ItemStackHandler> inputInvLazy = LazyOptional.of(() -> this.inputInventory);
    private final LazyOptional<AutoHammerOutputItemHandler> outputInvLazy = LazyOptional.of(() -> this.outputInventory);
    private final Supplier<Item> hammerItem;
    private int progress = 0;
    private int maxProgress = 0;
    private int timeOut = 0;
    private boolean processing = false;
    private ItemStack heldItem = ItemStack.f_41583_;

    public AutoHammerBlockEntity(BlockPos pos, BlockState state, BlockEntityType<?> blockEntityType, Supplier<Item> hammerItem) {
        super(blockEntityType, pos, state);
        this.hammerItem = hammerItem;
    }

    public static <T extends BlockEntity> void ticker(Level level, BlockPos pos, BlockState state, T t) {
        if (level == null || level.f_46443_) {
            return;
        }
        if (!(t instanceof AutoHammerBlockEntity)) {
            return;
        }
        AutoHammerBlockEntity blockEntity = (AutoHammerBlockEntity)t;
        if (blockEntity.timeOut > 0) {
            --blockEntity.timeOut;
            return;
        }
        blockEntity.pushPullInventories();
        ItemStack inputStack = blockEntity.inputInventory.getStackInSlot(0);
        List<ItemStack> hammerDrops = ToolsRecipeCache.getHammerDrops(level, inputStack);
        boolean isActive = (Boolean)state.m_61143_((Property)AutoHammerBlock.ACTIVE);
        boolean shouldBeActive = blockEntity.inputHasItemsAndOutputIsClear(hammerDrops);
        if (shouldBeActive && !isActive) {
            level.m_7731_(pos, (BlockState)state.m_61124_((Property)AutoHammerBlock.ACTIVE, (Comparable)Boolean.valueOf(true)), 3);
        } else if (!shouldBeActive && isActive) {
            level.m_7731_(pos, (BlockState)state.m_61124_((Property)AutoHammerBlock.ACTIVE, (Comparable)Boolean.valueOf(false)), 3);
        }
        if (!blockEntity.processing) {
            if (!inputStack.m_41619_()) {
                if (hammerDrops.size() > 0 && blockEntity.pushIntoInternalOutputInventory(hammerDrops, true) >= hammerDrops.size()) {
                    blockEntity.heldItem = inputStack.m_41777_();
                    blockEntity.heldItem.m_41764_(1);
                    blockEntity.inputInventory.extractItem(0, 1, false);
                    blockEntity.processing = true;
                    blockEntity.maxProgress = (Integer)blockEntity.getProps().getHammerSpeed().get();
                    blockEntity.progress = 0;
                } else {
                    blockEntity.timeOut = blockEntity.getTimeoutDuration();
                }
            } else {
                blockEntity.timeOut = blockEntity.getTimeoutDuration();
            }
        } else if (blockEntity.progress < blockEntity.maxProgress) {
            ++blockEntity.progress;
        } else {
            blockEntity.processing = false;
            blockEntity.progress = 0;
            blockEntity.maxProgress = 0;
            blockEntity.pushIntoInternalOutputInventory(ToolsRecipeCache.getHammerDrops(level, blockEntity.heldItem), false);
            blockEntity.heldItem = ItemStack.f_41583_;
        }
    }

    private void pushPullInventories() {
        ItemStack stack;
        Direction facing = (Direction)this.m_58900_().m_61143_((Property)BlockStateProperties.f_61374_);
        IItemHandler external = this.getExternalInventory(AutoHammerBlockEntity.getOutputDirection(facing));
        if (!(external instanceof EmptyHandler)) {
            for (int i = 0; i < this.outputInventory.getSlots(); ++i) {
                ItemStack stackInSlot = this.outputInventory.extractItem(i, this.outputInventory.getStackInSlot(i).m_41613_(), true);
                if (stackInSlot.m_41619_()) continue;
                stack = ItemHandlerHelper.insertItem((IItemHandler)external, (ItemStack)stackInSlot, (boolean)false);
                this.outputInventory.extractItem(i, stackInSlot.m_41613_() - stack.m_41613_(), false);
                break;
            }
        }
        IItemHandler pullSource = this.getExternalInventory(AutoHammerBlockEntity.getInputDirection(facing));
        for (int i = 0; i < pullSource.getSlots(); ++i) {
            stack = pullSource.extractItem(i, 64, true);
            if (stack.m_41619_() || !this.hasItemAndIsHammerable(stack)) continue;
            ItemStack insertedStack = ItemHandlerHelper.insertItemStacked((IItemHandler)this.inputInventory, (ItemStack)stack, (boolean)false);
            pullSource.extractItem(i, stack.m_41613_() - insertedStack.m_41613_(), false);
        }
    }

    private boolean hasItemAndIsHammerable(ItemStack stack) {
        BlockState blockState = Block.m_49814_((Item)stack.m_41720_()).m_49966_();
        boolean toolEffective = blockState.m_204336_(BlockTags.f_144282_);
        boolean toolEffective2 = blockState.m_204336_(BlockTags.f_144283_);
        boolean isCorrectTool = this.hammerItem.get().isCorrectToolForDrops(new ItemStack((ItemLike)this.hammerItem.get()), blockState);
        if (!isCorrectTool || !toolEffective && !toolEffective2) {
            return false;
        }
        return !stack.m_41619_() && ToolsRecipeCache.hammerable(stack);
    }

    private int pushIntoInternalOutputInventory(List<ItemStack> items, boolean simulate) {
        int inserted = 0;
        for (ItemStack item : items) {
            ItemStack insert = this.outputInventory.internalInsert(item.m_41777_(), simulate);
            if (!insert.m_41619_()) continue;
            ++inserted;
        }
        return inserted;
    }

    private IItemHandler getExternalInventory(Direction direction) {
        BlockEntity blockEntity = this.f_58857_.m_7702_(this.f_58858_.m_121945_(direction));
        if (blockEntity != null) {
            return (IItemHandler)blockEntity.getCapability(ForgeCapabilities.ITEM_HANDLER, direction.m_122424_()).orElse((Object)EmptyHandler.INSTANCE);
        }
        return EmptyHandler.INSTANCE;
    }

    public boolean inputHasItemsAndOutputIsClear(List<ItemStack> hammerDrops) {
        if (this.inputInventory.getStackInSlot(0).m_41619_()) {
            return false;
        }
        boolean hasSpace = false;
        block0: for (int i = 0; i < this.outputInventory.getSlots(); ++i) {
            ItemStack stackInSlot = this.outputInventory.getStackInSlot(i);
            if (stackInSlot.m_41619_()) {
                hasSpace = true;
                break;
            }
            for (ItemStack hammerDrop : hammerDrops) {
                if (!stackInSlot.m_41720_().equals(hammerDrop.m_41720_()) || stackInSlot.m_41613_() >= stackInSlot.m_41741_()) continue;
                hasSpace = true;
                continue block0;
            }
        }
        return hasSpace;
    }

    public void m_142466_(CompoundTag tag) {
        super.m_142466_(tag);
        this.progress = tag.m_128451_("Progress");
        this.maxProgress = tag.m_128451_("MaxProgress");
        this.processing = tag.m_128471_("Processing");
        this.inputInvLazy.ifPresent(e -> e.deserializeNBT(tag.m_128469_("InputInventory")));
        this.outputInvLazy.ifPresent(e -> e.deserializeNBT(tag.m_128469_("OutputInventory")));
    }

    protected void m_183515_(@NotNull CompoundTag arg) {
        super.m_183515_(arg);
        arg.m_128405_("Progress", this.progress);
        arg.m_128405_("MaxProgress", this.maxProgress);
        arg.m_128379_("Processing", this.processing);
        this.inputInvLazy.ifPresent(e -> arg.m_128365_("InputInventory", (Tag)e.serializeNBT()));
        this.outputInvLazy.ifPresent(e -> arg.m_128365_("OutputInventory", (Tag)e.serializeNBT()));
    }

    public static Direction getInputDirection(Direction facing) {
        return Direction.m_122376_((int)IO_DIRECTIONAL_MATRIX[facing.m_122411_() - 2][0]);
    }

    public static Direction getOutputDirection(Direction facing) {
        return Direction.m_122376_((int)IO_DIRECTIONAL_MATRIX[facing.m_122411_() - 2][1]);
    }

    @NotNull
    public <T> LazyOptional<T> getCapability(@NotNull Capability<T> cap, @Nullable Direction side) {
        Direction dir = (Direction)this.m_58900_().m_61143_((Property)BlockStateProperties.f_61374_);
        if (cap == ForgeCapabilities.ITEM_HANDLER) {
            if (side == AutoHammerBlockEntity.getInputDirection(dir)) {
                return this.inputInvLazy.cast();
            }
            if (side == AutoHammerBlockEntity.getOutputDirection(dir)) {
                return this.outputInvLazy.cast();
            }
        }
        return super.getCapability(cap, side);
    }

    public int getProgress() {
        return this.progress;
    }

    public int getMaxProgress() {
        return this.maxProgress;
    }

    public int getTimeOut() {
        return this.timeOut;
    }

    public int getTimeoutDuration() {
        return 100;
    }

    public ItemStack getHeldItem() {
        return this.heldItem;
    }

    public AutoHammerProperties getProps() {
        return AutoHammerProperties.IRON;
    }

    public static class Netherite
    extends AutoHammerBlockEntity {
        public Netherite(BlockPos pos, BlockState state) {
            super(pos, state, (BlockEntityType<?>)((BlockEntityType)ToolsRegistry.NETHERITE_AUTO_HAMMER_BLOCK_ENTITY.get()), (Supplier<Item>)ToolsRegistry.NETHERITE_HAMMER);
        }

        @Override
        public AutoHammerProperties getProps() {
            return AutoHammerProperties.NETHERITE;
        }
    }

    public static class Diamond
    extends AutoHammerBlockEntity {
        public Diamond(BlockPos pos, BlockState state) {
            super(pos, state, (BlockEntityType<?>)((BlockEntityType)ToolsRegistry.DIAMOND_AUTO_HAMMER_BLOCK_ENTITY.get()), (Supplier<Item>)ToolsRegistry.DIAMOND_HAMMER);
        }

        @Override
        public AutoHammerProperties getProps() {
            return AutoHammerProperties.DIAMOND;
        }
    }

    public static class Gold
    extends AutoHammerBlockEntity {
        public Gold(BlockPos pos, BlockState state) {
            super(pos, state, (BlockEntityType<?>)((BlockEntityType)ToolsRegistry.GOLD_AUTO_HAMMER_BLOCK_ENTITY.get()), (Supplier<Item>)ToolsRegistry.GOLD_HAMMER);
        }

        @Override
        public AutoHammerProperties getProps() {
            return AutoHammerProperties.GOLD;
        }
    }

    public static class Iron
    extends AutoHammerBlockEntity {
        public Iron(BlockPos pos, BlockState state) {
            super(pos, state, (BlockEntityType<?>)((BlockEntityType)ToolsRegistry.IRON_AUTO_HAMMER_BLOCK_ENTITY.get()), (Supplier<Item>)ToolsRegistry.IRON_HAMMER);
        }
    }
}

