/*
 * Decompiled with CFR 0.152.
 */
package sirttas.elementalcraft.spell.repair;

import javax.annotation.Nonnull;
import net.minecraft.core.BlockPos;
import net.minecraft.resources.ResourceKey;
import net.minecraft.world.InteractionResult;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.level.block.FallingBlock;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.phys.BlockHitResult;
import sirttas.elementalcraft.spell.Spell;
import sirttas.elementalcraft.spell.SpellHelper;

public class RepairSpell
extends Spell {
    public static final String NAME = "repair";

    public RepairSpell(ResourceKey<Spell> key) {
        super(key);
    }

    @Override
    @Nonnull
    public InteractionResult castOnBlock(@Nonnull Entity sender, @Nonnull BlockPos target, @Nonnull BlockHitResult hitResult) {
        Player player;
        ItemStack item;
        BlockPos offset = target.m_121945_(hitResult.m_82434_());
        if (!sender.f_19853_.m_8055_(offset).m_60795_() || FallingBlock.m_53241_((BlockState)sender.f_19853_.m_8055_(offset.m_7495_()))) {
            return InteractionResult.PASS;
        }
        if (sender instanceof Player && !(item = this.getItemToRepair(player = (Player)sender)).m_41619_() && item.m_41768_()) {
            this.repairPlayerItems(item);
            RepairSpell.playSound(offset, player);
            return InteractionResult.CONSUME;
        }
        return InteractionResult.PASS;
    }

    public ItemStack getItemToRepair(Player player) {
        ItemStack mainHand = player.m_21205_();
        ItemStack offHand = player.m_21206_();
        if (SpellHelper.getSpell(mainHand) == this) {
            return offHand;
        }
        if (SpellHelper.getSpell(offHand) == this) {
            return mainHand;
        }
        return ItemStack.f_41583_;
    }

    private void repairPlayerItems(ItemStack stack) {
        stack.m_41721_(stack.m_41773_() - Math.min((int)(1.0f * stack.getXpRepairRatio()), stack.m_41773_()));
    }

    private static void playSound(BlockPos offset, Player player) {
        int useTicks = player.m_21212_();
        if (useTicks > 0 && useTicks % 40 == 0) {
            player.f_19853_.m_5898_(player, 1030, offset, 0);
        }
    }
}

