/*
 * Decompiled with CFR 0.152.
 */
package sirttas.elementalcraft.recipe.instrument.binding;

import com.google.gson.JsonObject;
import java.util.List;
import javax.annotation.Nonnull;
import net.minecraft.core.NonNullList;
import net.minecraft.network.FriendlyByteBuf;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.util.GsonHelper;
import net.minecraft.world.Container;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.crafting.Ingredient;
import net.minecraft.world.item.crafting.RecipeSerializer;
import sirttas.elementalcraft.api.element.ElementType;
import sirttas.elementalcraft.block.instrument.binder.IBinder;
import sirttas.elementalcraft.config.ECConfig;
import sirttas.elementalcraft.recipe.ECRecipeSerializers;
import sirttas.elementalcraft.recipe.RecipeHelper;
import sirttas.elementalcraft.recipe.instrument.binding.AbstractBindingRecipe;

public class BindingRecipe
extends AbstractBindingRecipe {
    private final NonNullList<Ingredient> ingredients;
    private final ItemStack output;
    private final int elementAmount;

    public BindingRecipe(ResourceLocation id, ElementType type, int elementAmount, ItemStack output, List<Ingredient> ingredients) {
        super(id, type);
        this.ingredients = NonNullList.m_122783_((Object)Ingredient.f_43901_, (Object[])((Ingredient[])ingredients.toArray(Ingredient[]::new)));
        this.output = output;
        this.elementAmount = elementAmount;
    }

    @Override
    public int getElementAmount() {
        return this.elementAmount;
    }

    @Override
    public boolean matches(IBinder binder) {
        if (binder.getContainerElementType() != this.getElementType() || binder.getItemCount() != this.ingredients.size()) {
            return false;
        }
        return Boolean.TRUE.equals(ECConfig.COMMON.binderRecipeMatchOrder.get()) ? this.matchesOrdered(binder) : RecipeHelper.matchesUnordered(binder.getInventory(), this.ingredients);
    }

    private boolean matchesOrdered(IBinder binder) {
        Container inv = binder.getInventory();
        int ingredientIndex = 0;
        for (int i = 0; i < inv.m_6643_(); ++i) {
            ItemStack s = inv.m_8020_(i);
            if (s.m_41619_()) continue;
            if (ingredientIndex >= this.ingredients.size() || !((Ingredient)this.ingredients.get(ingredientIndex)).test(s)) {
                return false;
            }
            ++ingredientIndex;
        }
        return true;
    }

    @Nonnull
    public NonNullList<Ingredient> m_7527_() {
        return this.ingredients;
    }

    @Nonnull
    public ItemStack m_8043_() {
        return this.output;
    }

    @Nonnull
    public RecipeSerializer<?> m_7707_() {
        return (RecipeSerializer)ECRecipeSerializers.BINDING.get();
    }

    public static class Serializer
    implements RecipeSerializer<BindingRecipe> {
        @Nonnull
        public BindingRecipe fromJson(@Nonnull ResourceLocation recipeId, @Nonnull JsonObject json) {
            ElementType type = ElementType.byName(GsonHelper.m_13906_((JsonObject)json, (String)"element_type"));
            int elementAmount = GsonHelper.m_13927_((JsonObject)json, (String)"element_amount");
            NonNullList<Ingredient> ingredients = RecipeHelper.readIngredients(GsonHelper.m_13933_((JsonObject)json, (String)"ingredients"));
            ItemStack output = RecipeHelper.readRecipeOutput(json, "output");
            if (!output.m_41619_()) {
                return new BindingRecipe(recipeId, type, elementAmount, output, (List<Ingredient>)ingredients);
            }
            throw new IllegalStateException("Binding recipe output is empty!");
        }

        public BindingRecipe fromNetwork(@Nonnull ResourceLocation recipeId, FriendlyByteBuf buffer) {
            ElementType type = ElementType.byName(buffer.m_130277_());
            int elementAmount = buffer.readInt();
            ItemStack output = buffer.m_130267_();
            int i = buffer.m_130242_();
            NonNullList ingredients = NonNullList.m_122780_((int)i, (Object)Ingredient.f_43901_);
            for (int j = 0; j < ingredients.size(); ++j) {
                ingredients.set(j, (Object)Ingredient.m_43940_((FriendlyByteBuf)buffer));
            }
            return new BindingRecipe(recipeId, type, elementAmount, output, (List<Ingredient>)ingredients);
        }

        public void toNetwork(FriendlyByteBuf buffer, BindingRecipe recipe) {
            buffer.m_130070_(recipe.getElementType().m_7912_());
            buffer.writeInt(recipe.getElementAmount());
            buffer.m_130055_(recipe.m_8043_());
            buffer.m_130130_(recipe.m_7527_().size());
            for (Ingredient ingredient : recipe.m_7527_()) {
                ingredient.m_43923_(buffer);
            }
        }
    }
}

