/*
 * Decompiled with CFR 0.152.
 */
package sirttas.elementalcraft.pureore.injector;

import java.util.function.Supplier;
import net.minecraft.core.Registry;
import net.minecraft.resources.ResourceKey;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.world.Container;
import net.minecraft.world.item.crafting.BlastingRecipe;
import net.minecraft.world.item.crafting.CampfireCookingRecipe;
import net.minecraft.world.item.crafting.Recipe;
import net.minecraft.world.item.crafting.RecipeType;
import net.minecraft.world.item.crafting.SmeltingRecipe;
import net.minecraftforge.eventbus.api.IEventBus;
import net.minecraftforge.eventbus.api.SubscribeEvent;
import net.minecraftforge.fml.common.Mod;
import net.minecraftforge.registries.DeferredRegister;
import net.minecraftforge.registries.IForgeRegistry;
import net.minecraftforge.registries.RegisterEvent;
import net.minecraftforge.registries.RegistryBuilder;
import sirttas.elementalcraft.ElementalCraft;
import sirttas.elementalcraft.api.pureore.PureOreException;
import sirttas.elementalcraft.api.pureore.injector.AbstractPureOreRecipeInjector;
import sirttas.elementalcraft.interaction.ECinteractions;
import sirttas.elementalcraft.interaction.ie.IEInteraction;
import sirttas.elementalcraft.interaction.mekanism.MekanismInteraction;
import sirttas.elementalcraft.pureore.injector.PureOreCookingRecipeInjector;
import sirttas.elementalcraft.pureore.injector.PureOreGrindingRecipeInjector;
import sirttas.elementalcraft.registry.RegistryHelper;

@Mod.EventBusSubscriber(modid="elementalcraft", bus=Mod.EventBusSubscriber.Bus.MOD)
public class PureOreRecipeInjectors {
    public static final ResourceKey<Registry<AbstractPureOreRecipeInjector<?, ?>>> REGISTRY_KEY = ElementalCraft.createRegistryKey("pure_ore_recipe_injector");
    private static final DeferredRegister<AbstractPureOreRecipeInjector<?, ?>> DEFERRED_REGISTER = DeferredRegister.create(REGISTRY_KEY, (String)"elementalcraft");
    public static final Supplier<IForgeRegistry<AbstractPureOreRecipeInjector<?, ?>>> REGISTRY = DEFERRED_REGISTER.makeRegistry(RegistryBuilder::new);

    private PureOreRecipeInjectors() {
    }

    @SubscribeEvent
    public static void registerPureOreRecipeInjectors(RegisterEvent event) {
        if (!REGISTRY_KEY.equals((Object)event.getRegistryKey())) {
            return;
        }
        IForgeRegistry registry = event.getForgeRegistry();
        PureOreRecipeInjectors.register(registry, new PureOreCookingRecipeInjector<SmeltingRecipe>(RecipeType.f_44108_, SmeltingRecipe::new));
        PureOreRecipeInjectors.register(registry, new PureOreCookingRecipeInjector<BlastingRecipe>(RecipeType.f_44109_, BlastingRecipe::new));
        PureOreRecipeInjectors.register(registry, new PureOreCookingRecipeInjector<CampfireCookingRecipe>(RecipeType.f_44111_, CampfireCookingRecipe::new));
        PureOreRecipeInjectors.register(registry, new PureOreGrindingRecipeInjector());
        if (ECinteractions.isMekanismActive()) {
            MekanismInteraction.registerPureOreRecipeInjectors(registry);
        }
        if (ECinteractions.isImmersiveEngineeringActive()) {
            IEInteraction.registerPureOreRecipeInjectors(registry);
        }
    }

    public static <C extends Container, T extends Recipe<C>> void register(IForgeRegistry<AbstractPureOreRecipeInjector<?, ? extends Recipe<?>>> registry, AbstractPureOreRecipeInjector<C, T> injector) {
        ResourceLocation id = injector.getRecipeTypeRegistryName();
        if (id == null) {
            throw new PureOreException("Cannot register injector as its RecipeType is absent in registry.");
        }
        RegistryHelper.register(registry, injector, ElementalCraft.createRL(id.m_135827_() + "/" + id.m_135815_()));
    }

    public static void register(IEventBus modBus) {
        DEFERRED_REGISTER.register(modBus);
    }
}

