/*
 * Decompiled with CFR 0.152.
 */
package sirttas.elementalcraft.jewel.handler;

import java.util.Collections;
import java.util.List;
import java.util.stream.IntStream;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;
import net.minecraft.ChatFormatting;
import net.minecraft.core.Direction;
import net.minecraft.network.chat.Component;
import net.minecraft.network.chat.MutableComponent;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemStack;
import net.minecraftforge.api.distmarker.Dist;
import net.minecraftforge.common.capabilities.Capability;
import net.minecraftforge.common.capabilities.ICapabilityProvider;
import net.minecraftforge.common.util.LazyOptional;
import net.minecraftforge.event.entity.player.ItemTooltipEvent;
import net.minecraftforge.eventbus.api.SubscribeEvent;
import net.minecraftforge.fml.common.Mod;
import net.minecraftforge.registries.ForgeRegistries;
import sirttas.elementalcraft.item.ECItems;
import sirttas.elementalcraft.jewel.Jewel;
import sirttas.elementalcraft.jewel.JewelHelper;
import sirttas.elementalcraft.jewel.handler.IJewelHandler;

@Mod.EventBusSubscriber(value={Dist.CLIENT}, modid="elementalcraft")
public class ClientJewelHandler
implements IJewelHandler {
    private List<Jewel> activeJewels = Collections.emptyList();

    private ClientJewelHandler() {
    }

    @Nullable
    public static ICapabilityProvider createProvider() {
        if (CAPABILITY != null) {
            final ClientJewelHandler handler = new ClientJewelHandler();
            return new ICapabilityProvider(){

                @Nonnull
                public <T> LazyOptional<T> getCapability(@Nonnull Capability<T> cap, Direction side) {
                    return IJewelHandler.CAPABILITY.orEmpty(cap, LazyOptional.of(() -> handler));
                }
            };
        }
        return null;
    }

    @Override
    @Nonnull
    public List<Jewel> getActiveJewels() {
        return this.activeJewels;
    }

    @SubscribeEvent
    public static void addJewelTooltip(ItemTooltipEvent event) {
        ItemStack stack = event.getItemStack();
        Item item = stack.m_41720_();
        if (item != ECItems.JEWEL.get()) {
            List tooltip = event.getToolTip();
            Jewel jewel = JewelHelper.getJewel(stack);
            if (jewel != null) {
                int index = IntStream.range(0, tooltip.size()).filter(i -> ForgeRegistries.ITEMS.getKey((Object)item).toString().equals(((Component)tooltip.get(i)).getString())).findFirst().orElse(tooltip.size());
                Component component = jewel.getDisplayName();
                if (component instanceof MutableComponent) {
                    MutableComponent mutableComponent = (MutableComponent)component;
                    component = mutableComponent.m_130940_(ChatFormatting.YELLOW);
                }
                tooltip.add(index, component);
            }
        }
    }

    public void setActiveJewels(List<Jewel> jewels) {
        this.activeJewels = List.copyOf(jewels);
    }
}

