/*
 * Decompiled with CFR 0.152.
 */
package sirttas.elementalcraft.interaction.jei;

import java.util.List;
import java.util.function.Supplier;
import javax.annotation.Nonnull;
import mezz.jei.api.IModPlugin;
import mezz.jei.api.JeiPlugin;
import mezz.jei.api.constants.RecipeTypes;
import mezz.jei.api.constants.VanillaTypes;
import mezz.jei.api.ingredients.IIngredientHelper;
import mezz.jei.api.ingredients.IIngredientRenderer;
import mezz.jei.api.recipe.RecipeType;
import mezz.jei.api.recipe.category.IRecipeCategory;
import mezz.jei.api.recipe.vanilla.IJeiAnvilRecipe;
import mezz.jei.api.recipe.vanilla.IVanillaRecipeFactory;
import mezz.jei.api.registration.IModIngredientRegistration;
import mezz.jei.api.registration.IRecipeCatalystRegistration;
import mezz.jei.api.registration.IRecipeCategoryRegistration;
import mezz.jei.api.registration.IRecipeRegistration;
import mezz.jei.api.registration.ISubtypeRegistration;
import net.minecraft.client.Minecraft;
import net.minecraft.core.HolderSet;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.crafting.RecipeManager;
import net.minecraft.world.level.ItemLike;
import net.minecraft.world.level.block.Blocks;
import net.minecraftforge.registries.RegistryObject;
import sirttas.elementalcraft.ElementalCraft;
import sirttas.elementalcraft.api.element.ElementType;
import sirttas.elementalcraft.block.ECBlocks;
import sirttas.elementalcraft.block.shrine.budding.BuddingShrineBlock;
import sirttas.elementalcraft.block.shrine.lava.LavaShrineBlock;
import sirttas.elementalcraft.block.shrine.spring.SpringShrineBlock;
import sirttas.elementalcraft.interaction.ECinteractions;
import sirttas.elementalcraft.interaction.ie.IEInteraction;
import sirttas.elementalcraft.interaction.jei.ECJEIRecipeTypes;
import sirttas.elementalcraft.interaction.jei.category.PureInfusionRecipeCategory;
import sirttas.elementalcraft.interaction.jei.category.SpellCraftRecipeCategory;
import sirttas.elementalcraft.interaction.jei.category.element.CrystalThrowingRecipeCategory;
import sirttas.elementalcraft.interaction.jei.category.element.DisplacementRecipeCategory;
import sirttas.elementalcraft.interaction.jei.category.element.EvaporationRecipeCategory;
import sirttas.elementalcraft.interaction.jei.category.element.ExtractionRecipeCategory;
import sirttas.elementalcraft.interaction.jei.category.element.ImprovedExtractionRecipeCategory;
import sirttas.elementalcraft.interaction.jei.category.element.SolarSynthesisRecipeCategory;
import sirttas.elementalcraft.interaction.jei.category.element.SourceBreedingRecipeCategory;
import sirttas.elementalcraft.interaction.jei.category.instrument.BindingRecipeCategory;
import sirttas.elementalcraft.interaction.jei.category.instrument.CrystallizationRecipeCategory;
import sirttas.elementalcraft.interaction.jei.category.instrument.InscriptionRecipeCategory;
import sirttas.elementalcraft.interaction.jei.category.instrument.io.GrindingRecipeCategory;
import sirttas.elementalcraft.interaction.jei.category.instrument.io.InfusionRecipeCategory;
import sirttas.elementalcraft.interaction.jei.category.instrument.io.PurificationRecipeCategory;
import sirttas.elementalcraft.interaction.jei.category.instrument.io.SawingRecipeCategory;
import sirttas.elementalcraft.interaction.jei.category.instrument.io.ToolInfusionRecipeCategory;
import sirttas.elementalcraft.interaction.jei.category.shrine.BuddingShrineRecipeCategory;
import sirttas.elementalcraft.interaction.jei.category.shrine.LavaShrineRecipeCategory;
import sirttas.elementalcraft.interaction.jei.category.shrine.SpringShrineRecipeCategory;
import sirttas.elementalcraft.interaction.jei.ingredient.ECIngredientTypes;
import sirttas.elementalcraft.interaction.jei.ingredient.element.ElementIngredientHelper;
import sirttas.elementalcraft.interaction.jei.ingredient.element.ElementIngredientRenderer;
import sirttas.elementalcraft.interaction.jei.ingredient.element.IngredientElementType;
import sirttas.elementalcraft.interaction.jei.ingredient.source.IngredientSource;
import sirttas.elementalcraft.interaction.jei.ingredient.source.SourceIngredientHelper;
import sirttas.elementalcraft.interaction.jei.ingredient.source.SourceIngredientRenderer;
import sirttas.elementalcraft.interaction.mekanism.MekanismInteraction;
import sirttas.elementalcraft.item.ECItems;
import sirttas.elementalcraft.item.elemental.ElementalItem;
import sirttas.elementalcraft.jewel.JewelHelper;
import sirttas.elementalcraft.jewel.Jewels;
import sirttas.elementalcraft.recipe.ECRecipeTypes;
import sirttas.elementalcraft.recipe.instrument.infusion.ToolInfusionRecipe;
import sirttas.elementalcraft.spell.Spell;
import sirttas.elementalcraft.spell.SpellHelper;
import sirttas.elementalcraft.spell.Spells;
import sirttas.elementalcraft.tag.ECTags;

@JeiPlugin
public class ElementalCraftJEIPlugin
implements IModPlugin {
    private static final ResourceLocation ID = ElementalCraft.createRL("main");
    private final Supplier<HolderSet.Named<Item>> spellCastTools = () -> ECTags.Items.getTag(ECTags.Items.SPELL_CAST_TOOLS);
    private final Supplier<HolderSet.Named<Item>> jewelSocketalbes = () -> ECTags.Items.getTag(ECTags.Items.JEWEL_SOCKETABLES);

    @Nonnull
    public ResourceLocation getPluginUid() {
        return ID;
    }

    public void registerIngredients(IModIngredientRegistration registration) {
        registration.register(ECIngredientTypes.ELEMENT, IngredientElementType.all(), (IIngredientHelper)new ElementIngredientHelper(), (IIngredientRenderer)new ElementIngredientRenderer());
        registration.register(ECIngredientTypes.SOURCE, IngredientSource.all(), (IIngredientHelper)new SourceIngredientHelper(), (IIngredientRenderer)new SourceIngredientRenderer());
    }

    public void registerItemSubtypes(@Nonnull ISubtypeRegistration registry) {
        this.useNbtForSubtypes(registry, ECItems.SCROLL);
        this.useNbtForSubtypes(registry, ECItems.RECEPTACLE);
        this.useNbtForSubtypes(registry, ECItems.PURE_ORE);
        this.useNbtForSubtypes(registry, ECItems.RUNE);
        this.useNbtForSubtypes(registry, ECItems.JEWEL);
        this.useNbtForSubtypes(registry, ECBlocks.CONTAINER, ECBlocks.SMALL_CONTAINER, ECBlocks.CREATIVE_CONTAINER);
        this.useNbtForSubtypes(registry, ECBlocks.FIRE_RESERVOIR, ECBlocks.WATER_RESERVOIR, ECBlocks.EARTH_RESERVOIR, ECBlocks.AIR_RESERVOIR);
        this.useNbtForSubtypes(registry, ECItems.FIRE_HOLDER, ECItems.WATER_HOLDER, ECItems.EARTH_HOLDER, ECItems.AIR_HOLDER, ECItems.PURE_HOLDER);
        if (!ECinteractions.isBotaniaActive()) {
            this.excludeSubtypes(registry, ECBlocks.MANA_SYNTHESIZER, ECBlocks.MYSTICAL_GROVE_SHRINE_UPGRADE);
        }
    }

    @SafeVarargs
    private void excludeSubtypes(ISubtypeRegistration registry, RegistryObject<? extends ItemLike> ... items) {
        for (RegistryObject<? extends ItemLike> item : items) {
            registry.registerSubtypeInterpreter(VanillaTypes.ITEM_STACK, (Object)((ItemLike)item.get()).m_5456_(), (i, c) -> "");
        }
    }

    @SafeVarargs
    private void useNbtForSubtypes(ISubtypeRegistration registry, RegistryObject<? extends ItemLike> ... items) {
        for (RegistryObject<? extends ItemLike> item : items) {
            registry.useNbtForSubtypes(new Item[]{((ItemLike)item.get()).m_5456_()});
        }
    }

    public void registerCategories(IRecipeCategoryRegistration registry) {
        registry.addRecipeCategories(new IRecipeCategory[]{new ExtractionRecipeCategory(registry.getJeiHelpers().getGuiHelper())});
        registry.addRecipeCategories(new IRecipeCategory[]{new ImprovedExtractionRecipeCategory(registry.getJeiHelpers().getGuiHelper())});
        registry.addRecipeCategories(new IRecipeCategory[]{new EvaporationRecipeCategory(registry.getJeiHelpers().getGuiHelper())});
        registry.addRecipeCategories(new IRecipeCategory[]{new SolarSynthesisRecipeCategory(registry.getJeiHelpers().getGuiHelper())});
        registry.addRecipeCategories(new IRecipeCategory[]{new InfusionRecipeCategory(registry.getJeiHelpers().getGuiHelper())});
        registry.addRecipeCategories(new IRecipeCategory[]{new ToolInfusionRecipeCategory(registry.getJeiHelpers().getGuiHelper())});
        registry.addRecipeCategories(new IRecipeCategory[]{new BindingRecipeCategory(registry.getJeiHelpers().getGuiHelper())});
        registry.addRecipeCategories(new IRecipeCategory[]{new CrystallizationRecipeCategory(registry.getJeiHelpers().getGuiHelper())});
        registry.addRecipeCategories(new IRecipeCategory[]{new InscriptionRecipeCategory(registry.getJeiHelpers().getGuiHelper())});
        registry.addRecipeCategories(new IRecipeCategory[]{new PureInfusionRecipeCategory(registry.getJeiHelpers().getGuiHelper())});
        registry.addRecipeCategories(new IRecipeCategory[]{new PurificationRecipeCategory(registry.getJeiHelpers().getGuiHelper())});
        registry.addRecipeCategories(new IRecipeCategory[]{new GrindingRecipeCategory(registry.getJeiHelpers().getGuiHelper())});
        registry.addRecipeCategories(new IRecipeCategory[]{new SawingRecipeCategory(registry.getJeiHelpers().getGuiHelper())});
        registry.addRecipeCategories(new IRecipeCategory[]{new SpellCraftRecipeCategory(registry.getJeiHelpers().getGuiHelper())});
        registry.addRecipeCategories(new IRecipeCategory[]{new DisplacementRecipeCategory(registry.getJeiHelpers().getGuiHelper())});
        registry.addRecipeCategories(new IRecipeCategory[]{new BuddingShrineRecipeCategory(registry.getJeiHelpers().getGuiHelper())});
        registry.addRecipeCategories(new IRecipeCategory[]{new LavaShrineRecipeCategory(registry.getJeiHelpers().getGuiHelper())});
        registry.addRecipeCategories(new IRecipeCategory[]{new SpringShrineRecipeCategory(registry.getJeiHelpers().getGuiHelper())});
        registry.addRecipeCategories(new IRecipeCategory[]{new CrystalThrowingRecipeCategory(registry.getJeiHelpers().getGuiHelper())});
        registry.addRecipeCategories(new IRecipeCategory[]{new SourceBreedingRecipeCategory(registry.getJeiHelpers().getGuiHelper())});
    }

    public void registerRecipeCatalysts(IRecipeCatalystRegistration registry) {
        registry.addRecipeCatalyst(new ItemStack((ItemLike)ECBlocks.FIRE_FURNACE.get()), new RecipeType[]{RecipeTypes.SMELTING});
        registry.addRecipeCatalyst(new ItemStack((ItemLike)ECBlocks.FIRE_BLAST_FURNACE.get()), new RecipeType[]{RecipeTypes.BLASTING});
        registry.addRecipeCatalyst(new ItemStack((ItemLike)ECBlocks.EXTRACTOR.get()), new RecipeType[]{ECJEIRecipeTypes.EXTRACTION});
        registry.addRecipeCatalyst(new ItemStack((ItemLike)ECBlocks.EXTRACTOR_IMPROVED.get()), new RecipeType[]{ECJEIRecipeTypes.EXTRACTION_IMPROVED});
        registry.addRecipeCatalyst(new ItemStack((ItemLike)ECBlocks.EVAPORATOR.get()), new RecipeType[]{ECJEIRecipeTypes.EVAPORATION});
        registry.addRecipeCatalyst(new ItemStack((ItemLike)ECBlocks.SOLAR_SYNTHESIZER.get()), new RecipeType[]{ECJEIRecipeTypes.SOLAR_SYNTHESIS});
        registry.addRecipeCatalyst(new ItemStack((ItemLike)ECBlocks.INFUSER.get()), new RecipeType[]{ECJEIRecipeTypes.INFUSION, ECJEIRecipeTypes.TOOL_INFUSION});
        registry.addRecipeCatalyst(new ItemStack((ItemLike)ECBlocks.BINDER.get()), new RecipeType[]{ECJEIRecipeTypes.BINDING});
        registry.addRecipeCatalyst(new ItemStack((ItemLike)ECBlocks.BINDER_IMPROVED.get()), new RecipeType[]{ECJEIRecipeTypes.BINDING, ECJEIRecipeTypes.INFUSION, ECJEIRecipeTypes.TOOL_INFUSION});
        registry.addRecipeCatalyst(new ItemStack((ItemLike)ECBlocks.CRYSTALLIZER.get()), new RecipeType[]{ECJEIRecipeTypes.CRYSTALLIZATION});
        registry.addRecipeCatalyst(new ItemStack((ItemLike)ECBlocks.INSCRIBER.get()), new RecipeType[]{ECJEIRecipeTypes.INSCRIPTION});
        registry.addRecipeCatalyst(new ItemStack((ItemLike)ECItems.CHISEL.get()), new RecipeType[]{ECJEIRecipeTypes.INSCRIPTION});
        registry.addRecipeCatalyst(new ItemStack((ItemLike)ECBlocks.PURE_INFUSER.get()), new RecipeType[]{ECJEIRecipeTypes.PURE_INFUSION});
        registry.addRecipeCatalyst(new ItemStack((ItemLike)ECBlocks.FIRE_PEDESTAL.get()), new RecipeType[]{ECJEIRecipeTypes.PURE_INFUSION});
        registry.addRecipeCatalyst(new ItemStack((ItemLike)ECBlocks.WATER_PEDESTAL.get()), new RecipeType[]{ECJEIRecipeTypes.PURE_INFUSION});
        registry.addRecipeCatalyst(new ItemStack((ItemLike)ECBlocks.EARTH_PEDESTAL.get()), new RecipeType[]{ECJEIRecipeTypes.PURE_INFUSION});
        registry.addRecipeCatalyst(new ItemStack((ItemLike)ECBlocks.AIR_PEDESTAL.get()), new RecipeType[]{ECJEIRecipeTypes.PURE_INFUSION});
        registry.addRecipeCatalyst(new ItemStack((ItemLike)ECBlocks.PURIFIER.get()), new RecipeType[]{ECJEIRecipeTypes.PURIFICATION});
        registry.addRecipeCatalyst(new ItemStack((ItemLike)ECBlocks.AIR_MILL_GRINDSTONE.get()), new RecipeType[]{ECJEIRecipeTypes.GRINDING});
        registry.addRecipeCatalyst(new ItemStack((ItemLike)ECBlocks.WATER_MILL_WOOD_SAW.get()), new RecipeType[]{ECJEIRecipeTypes.SAWING});
        registry.addRecipeCatalyst(new ItemStack((ItemLike)ECBlocks.SPELL_DESK.get()), new RecipeType[]{ECJEIRecipeTypes.SPELL_CRAFTING});
        registry.addRecipeCatalyst(new ItemStack((ItemLike)ECBlocks.FIRE_SOURCE_DISPLACEMENT_PLATE.get()), new RecipeType[]{ECJEIRecipeTypes.DISPLACEMENT});
        registry.addRecipeCatalyst(new ItemStack((ItemLike)ECBlocks.WATER_SOURCE_DISPLACEMENT_PLATE.get()), new RecipeType[]{ECJEIRecipeTypes.DISPLACEMENT});
        registry.addRecipeCatalyst(new ItemStack((ItemLike)ECBlocks.EARTH_SOURCE_DISPLACEMENT_PLATE.get()), new RecipeType[]{ECJEIRecipeTypes.DISPLACEMENT});
        registry.addRecipeCatalyst(new ItemStack((ItemLike)ECBlocks.AIR_SOURCE_DISPLACEMENT_PLATE.get()), new RecipeType[]{ECJEIRecipeTypes.DISPLACEMENT});
        registry.addRecipeCatalyst(new ItemStack((ItemLike)ECBlocks.BUDDING_SHRINE.get()), new RecipeType[]{ECJEIRecipeTypes.BUDDING_SHRINE});
        registry.addRecipeCatalyst(new ItemStack((ItemLike)ECBlocks.LAVA_SHRINE.get()), new RecipeType[]{ECJEIRecipeTypes.LAVA_SHRINE});
        registry.addRecipeCatalyst(new ItemStack((ItemLike)ECBlocks.SPRING_SHRINE.get()), new RecipeType[]{ECJEIRecipeTypes.SPRING_SHRINE});
        registry.addRecipeCatalyst(new ItemStack((ItemLike)ECBlocks.SOURCE_BREEDER.get()), new RecipeType[]{ECJEIRecipeTypes.SOURCE_BREEDING});
        registry.addRecipeCatalyst(new ItemStack((ItemLike)ECBlocks.SOURCE_BREEDER_PEDESTAL.get()), new RecipeType[]{ECJEIRecipeTypes.SOURCE_BREEDING});
        registry.addRecipeCatalyst(new ItemStack((ItemLike)Blocks.f_50061_), new RecipeType[]{ECJEIRecipeTypes.CRYSTAL_THROWING});
        if (ECinteractions.isMekanismActive()) {
            MekanismInteraction.addAirMillToCrushing(registry);
        }
        if (ECinteractions.isImmersiveEngineeringActive()) {
            IEInteraction.addAirMillToCrushing(registry);
        }
    }

    public void registerRecipes(@Nonnull IRecipeRegistration registry) {
        RecipeManager recipeManager = Minecraft.m_91087_().f_91073_.m_7465_();
        registry.addRecipes(ECJEIRecipeTypes.EXTRACTION, ElementType.ALL_VALID);
        registry.addRecipes(ECJEIRecipeTypes.EXTRACTION_IMPROVED, ElementType.ALL_VALID);
        registry.addRecipes(ECJEIRecipeTypes.EVAPORATION, EvaporationRecipeCategory.getShards());
        registry.addRecipes(ECJEIRecipeTypes.SOLAR_SYNTHESIS, SolarSynthesisRecipeCategory.getLenses());
        registry.addRecipes(ECJEIRecipeTypes.INFUSION, recipeManager.m_44013_((net.minecraft.world.item.crafting.RecipeType)ECRecipeTypes.INFUSION.get()).stream().filter(r -> !(r instanceof ToolInfusionRecipe)).toList());
        registry.addRecipes(ECJEIRecipeTypes.TOOL_INFUSION, recipeManager.m_44013_((net.minecraft.world.item.crafting.RecipeType)ECRecipeTypes.INFUSION.get()).stream().filter(ToolInfusionRecipe.class::isInstance).toList());
        registry.addRecipes(ECJEIRecipeTypes.BINDING, recipeManager.m_44013_((net.minecraft.world.item.crafting.RecipeType)ECRecipeTypes.BINDING.get()));
        registry.addRecipes(ECJEIRecipeTypes.CRYSTALLIZATION, recipeManager.m_44013_((net.minecraft.world.item.crafting.RecipeType)ECRecipeTypes.CRYSTALLIZATION.get()));
        registry.addRecipes(ECJEIRecipeTypes.INSCRIPTION, recipeManager.m_44013_((net.minecraft.world.item.crafting.RecipeType)ECRecipeTypes.INSCRIPTION.get()));
        registry.addRecipes(ECJEIRecipeTypes.PURE_INFUSION, recipeManager.m_44013_((net.minecraft.world.item.crafting.RecipeType)ECRecipeTypes.PURE_INFUSION.get()));
        registry.addRecipes(ECJEIRecipeTypes.GRINDING, recipeManager.m_44013_((net.minecraft.world.item.crafting.RecipeType)ECRecipeTypes.GRINDING.get()));
        registry.addRecipes(ECJEIRecipeTypes.SAWING, recipeManager.m_44013_((net.minecraft.world.item.crafting.RecipeType)ECRecipeTypes.SAWING.get()));
        registry.addRecipes(ECJEIRecipeTypes.SPELL_CRAFTING, recipeManager.m_44013_((net.minecraft.world.item.crafting.RecipeType)ECRecipeTypes.SPELL_CRAFT.get()));
        registry.addRecipes(ECJEIRecipeTypes.PURIFICATION, ElementalCraft.PURE_ORE_MANAGER.getRecipes());
        registry.addRecipes(RecipeTypes.ANVIL, this.createCastToolsAnvilRecipes(registry.getVanillaRecipeFactory()));
        registry.addRecipes(RecipeTypes.ANVIL, this.createJewelsAnvilRecipes(registry.getVanillaRecipeFactory()));
        registry.addRecipes(ECJEIRecipeTypes.DISPLACEMENT, ElementType.ALL_VALID);
        registry.addRecipes(ECJEIRecipeTypes.BUDDING_SHRINE, List.of(BuddingShrineBlock.CrystalType.values()));
        registry.addRecipes(ECJEIRecipeTypes.LAVA_SHRINE, List.of((LavaShrineBlock)ECBlocks.LAVA_SHRINE.get()));
        registry.addRecipes(ECJEIRecipeTypes.SPRING_SHRINE, List.of((SpringShrineBlock)ECBlocks.SPRING_SHRINE.get()));
        registry.addRecipes(ECJEIRecipeTypes.CRYSTAL_THROWING, ElementType.ALL_VALID);
        registry.addRecipes(ECJEIRecipeTypes.SOURCE_BREEDING, List.of((ElementalItem)ECItems.ARTIFICIAL_FIRE_SOURCE_SEED.get(), (ElementalItem)ECItems.ARTIFICIAL_WATER_SOURCE_SEED.get(), (ElementalItem)ECItems.ARTIFICIAL_EARTH_SOURCE_SEED.get(), (ElementalItem)ECItems.ARTIFICIAL_AIR_SOURCE_SEED.get(), (ElementalItem)ECItems.NATURAL_FIRE_SOURCE_SEED.get(), (ElementalItem)ECItems.NATURAL_WATER_SOURCE_SEED.get(), (ElementalItem)ECItems.NATURAL_EARTH_SOURCE_SEED.get(), (ElementalItem)ECItems.NATURAL_AIR_SOURCE_SEED.get()));
    }

    private List<IJeiAnvilRecipe> createCastToolsAnvilRecipes(IVanillaRecipeFactory factory) {
        return Spells.REGISTRY.get().getValues().stream().filter(Spell::isVisible).mapMulti((spell, downstream) -> this.spellCastTools.get().forEach(item -> {
            ItemStack scroll = new ItemStack((ItemLike)ECItems.SCROLL.get());
            ItemStack stack = new ItemStack(item);
            SpellHelper.setSpell(scroll, spell);
            SpellHelper.addSpell(stack, spell);
            downstream.accept(factory.createAnvilRecipe(new ItemStack(item), List.of(scroll), List.of(stack)));
        })).toList();
    }

    private List<IJeiAnvilRecipe> createJewelsAnvilRecipes(IVanillaRecipeFactory factory) {
        return Jewels.REGISTRY.get().getValues().stream().flatMap(jewel -> this.jewelSocketalbes.get().m_203614_().map(item -> {
            ItemStack jewelItem = new ItemStack((ItemLike)ECItems.JEWEL.get());
            ItemStack stack = new ItemStack(item);
            JewelHelper.setJewel(jewelItem, jewel);
            JewelHelper.setJewel(stack, jewel);
            return factory.createAnvilRecipe(new ItemStack(item), List.of(jewelItem), List.of(stack));
        })).toList();
    }
}

