/*
 * Decompiled with CFR 0.152.
 */
package sirttas.elementalcraft.block.spelldesk;

import java.util.Collections;
import java.util.List;
import java.util.function.Predicate;
import javax.annotation.Nonnull;
import net.minecraft.world.Container;
import net.minecraft.world.SimpleContainer;
import net.minecraft.world.entity.player.Inventory;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.inventory.AbstractContainerMenu;
import net.minecraft.world.inventory.CraftingContainer;
import net.minecraft.world.inventory.DataSlot;
import net.minecraft.world.inventory.Slot;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.crafting.RecipeType;
import net.minecraft.world.level.Level;
import net.minecraftforge.common.Tags;
import sirttas.elementalcraft.container.menu.AbstractECMenu;
import sirttas.elementalcraft.container.menu.ECMenus;
import sirttas.elementalcraft.item.ECItems;
import sirttas.elementalcraft.recipe.ECRecipeTypes;
import sirttas.elementalcraft.tag.ECTags;

public class SpellDeskMenu
extends AbstractECMenu {
    private final Container input;
    private final Container output;
    private final Level level;
    private final DataSlot page = DataSlot.m_39401_();
    private final DataSlot pageCount = DataSlot.m_39401_();
    private List<ItemStack> stacks;

    public SpellDeskMenu(int id, Inventory player) {
        super(ECMenus.SPELL_DESK, id);
        this.level = player.f_35978_.m_9236_();
        this.input = new CraftingContainer((AbstractContainerMenu)this, 3, 1);
        this.output = new SimpleContainer(6);
        this.stacks = Collections.emptyList();
        this.m_38897_(new InputSlot(0, 32, 35, s -> s.m_150930_((Item)ECItems.SCROLL_PAPER.get())));
        this.m_38897_(new InputSlot(1, 23, 53, s -> s.m_204117_(Tags.Items.GEMS)));
        this.m_38897_(new InputSlot(2, 41, 53, s -> s.m_204117_(ECTags.Items.CRYSTALS)));
        this.m_38897_(new OutputSlot(0, 108, 35));
        this.m_38897_(new OutputSlot(1, 126, 35));
        this.m_38897_(new OutputSlot(2, 144, 35));
        this.m_38897_(new OutputSlot(3, 108, 53));
        this.m_38897_(new OutputSlot(4, 126, 53));
        this.m_38897_(new OutputSlot(5, 144, 53));
        this.addPlayerSlots(player, 84);
        this.m_38895_(this.page);
        this.m_38895_(this.pageCount);
    }

    @Nonnull
    public ItemStack m_7648_(@Nonnull Player player, int index) {
        Slot slot = (Slot)this.f_38839_.get(index);
        if (slot.m_6657_()) {
            ItemStack slotStack = slot.m_7993_();
            ItemStack stack = slotStack.m_41777_();
            if (index < 3) {
                if (!this.m_38903_(slotStack, 9, this.f_38839_.size(), true)) {
                    return ItemStack.f_41583_;
                }
            } else {
                if (index < 9) {
                    if (!this.m_38903_(slotStack.m_41777_(), 9, this.f_38839_.size(), true)) {
                        return ItemStack.f_41583_;
                    }
                    slot.m_142406_(player, slotStack);
                    return ItemStack.f_41583_;
                }
                if (!this.m_38903_(slotStack, 0, 3, false)) {
                    return ItemStack.f_41583_;
                }
            }
            if (slotStack.m_41619_()) {
                slot.m_5852_(ItemStack.f_41583_);
            } else {
                slot.m_6654_();
            }
            return stack;
        }
        return ItemStack.f_41583_;
    }

    private void updateRecipeList(Level level) {
        this.stacks = level.m_7465_().m_44056_((RecipeType)ECRecipeTypes.SPELL_CRAFT.get(), this.input, level).stream().map(r -> r.m_5874_(this.input)).toList();
        this.page.m_6422_(0);
        this.pageCount.m_6422_(Math.max(1, (int)Math.ceil((double)this.stacks.size() / 6.0)));
        this.setOutput();
    }

    private void setOutput() {
        this.output.m_6211_();
        int size = Math.min(this.stacks.size(), 6);
        int index = this.page.m_6501_() * 6;
        for (int i = 0; i < size; ++i) {
            this.output.m_6836_(i, this.stacks.get(i + index));
        }
        this.m_38946_();
    }

    public void m_6199_(@Nonnull Container container) {
        this.updateRecipeList(this.level);
    }

    @Override
    public void m_6877_(@Nonnull Player player) {
        super.m_6877_(player);
        this.m_150411_(player, this.input);
    }

    public int getPage() {
        return this.page.m_6501_();
    }

    public int getPageCount() {
        return this.pageCount.m_6501_();
    }

    public void nextPage() {
        this.page.m_6422_(Math.min(this.getPage() + 1, this.getPageCount() - 1));
        this.setOutput();
    }

    public void previousPage() {
        this.page.m_6422_(Math.max(this.getPage() - 1, 0));
        this.setOutput();
    }

    private class InputSlot
    extends Slot {
        private final Predicate<ItemStack> predicate;

        public InputSlot(int index, int xPosition, int yPosition, Predicate<ItemStack> predicate) {
            super(SpellDeskMenu.this.input, index, xPosition, yPosition);
            this.predicate = predicate;
        }

        public boolean m_5857_(@Nonnull ItemStack stack) {
            return this.predicate.test(stack);
        }
    }

    private class OutputSlot
    extends Slot {
        public OutputSlot(int index, int xPosition, int yPosition) {
            super(SpellDeskMenu.this.output, index, xPosition, yPosition);
        }

        public boolean m_5857_(@Nonnull ItemStack stack) {
            return false;
        }

        public void m_142406_(@Nonnull Player player, @Nonnull ItemStack stack) {
            this.m_5845_(stack);
            for (int i = 0; i < SpellDeskMenu.this.input.m_6643_(); ++i) {
                SpellDeskMenu.this.input.m_7407_(i, 1);
            }
            SpellDeskMenu.this.updateRecipeList(player.f_19853_);
        }
    }
}

