/*
 * Decompiled with CFR 0.152.
 */
package sirttas.elementalcraft.block.source;

import java.util.stream.Stream;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;
import net.minecraft.core.BlockPos;
import net.minecraft.world.InteractionHand;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.context.BlockPlaceContext;
import net.minecraft.world.level.BlockGetter;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.block.RenderShape;
import net.minecraft.world.level.block.entity.BlockEntity;
import net.minecraft.world.level.block.entity.BlockEntityTicker;
import net.minecraft.world.level.block.entity.BlockEntityType;
import net.minecraft.world.level.block.state.BlockBehaviour;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.level.block.state.StateDefinition;
import net.minecraft.world.level.block.state.properties.Property;
import net.minecraft.world.level.material.Material;
import net.minecraft.world.phys.shapes.CollisionContext;
import net.minecraft.world.phys.shapes.EntityCollisionContext;
import net.minecraft.world.phys.shapes.Shapes;
import net.minecraft.world.phys.shapes.VoxelShape;
import sirttas.elementalcraft.api.element.ElementType;
import sirttas.elementalcraft.api.source.ISourceInteractable;
import sirttas.elementalcraft.block.AbstractECEntityBlock;
import sirttas.elementalcraft.block.entity.BlockEntityHelper;
import sirttas.elementalcraft.block.entity.ECBlockEntityTypes;
import sirttas.elementalcraft.block.source.SourceBlockEntity;
import sirttas.elementalcraft.material.ECMaterials;

public class SourceBlock
extends AbstractECEntityBlock {
    private static final VoxelShape SHAPE = Block.m_49796_((double)4.0, (double)0.0, (double)4.0, (double)12.0, (double)8.0, (double)12.0);
    public static final String NAME = "source";

    public SourceBlock() {
        super(BlockBehaviour.Properties.m_60939_((Material)ECMaterials.SOURCE).m_60913_(-1.0f, 3600000.0f).m_60953_(s -> 7).m_60955_().m_222994_());
        this.m_49959_((BlockState)((BlockState)this.f_49792_.m_61090_()).m_61124_(ElementType.STATE_PROPERTY, (Comparable)((Object)ElementType.NONE)));
    }

    public BlockEntity m_142194_(@Nonnull BlockPos pos, @Nonnull BlockState state) {
        return new SourceBlockEntity(pos, state);
    }

    @Override
    @Nullable
    public <T extends BlockEntity> BlockEntityTicker<T> m_142354_(Level level, @Nonnull BlockState state, @Nonnull BlockEntityType<T> type) {
        return SourceBlock.createECServerTicker(level, type, ECBlockEntityTypes.SOURCE, SourceBlockEntity::serverTick);
    }

    protected void m_7926_(StateDefinition.Builder<Block, BlockState> container) {
        container.m_61104_(new Property[]{ElementType.STATE_PROPERTY});
    }

    @Override
    @Deprecated
    public boolean m_7923_(@Nonnull BlockState state) {
        return true;
    }

    @Nonnull
    @Deprecated
    public VoxelShape m_5940_(@Nonnull BlockState state, @Nonnull BlockGetter worldIn, @Nonnull BlockPos pos, @Nonnull CollisionContext context) {
        return this.showShape(state, context) ? SHAPE : Shapes.m_83040_();
    }

    @Nonnull
    @Deprecated
    public VoxelShape m_5939_(@Nonnull BlockState state, @Nonnull BlockGetter worldIn, @Nonnull BlockPos pos, @Nonnull CollisionContext context) {
        return Shapes.m_83040_();
    }

    private boolean showShape(BlockState state, CollisionContext context) {
        EntityCollisionContext entityContext;
        Entity entity;
        if (context instanceof EntityCollisionContext && (entity = (entityContext = (EntityCollisionContext)context).m_193113_()) instanceof LivingEntity) {
            LivingEntity e = (LivingEntity)entity;
            return Stream.of(e.m_21120_(InteractionHand.MAIN_HAND), e.m_21120_(InteractionHand.MAIN_HAND)).anyMatch(s -> {
                ISourceInteractable sourceInteractable;
                Item patt3480$temp = s.m_41720_();
                return patt3480$temp instanceof ISourceInteractable && (sourceInteractable = (ISourceInteractable)patt3480$temp).canInteractWithSource((ItemStack)s, state);
            });
        }
        return false;
    }

    @Deprecated
    public void m_6807_(@Nonnull BlockState state, @Nonnull Level level, @Nonnull BlockPos pos, @Nonnull BlockState oldState, boolean isMoving) {
        if (ElementType.getElementType(state) == ElementType.NONE) {
            level.m_46597_(pos, (BlockState)state.m_61124_(ElementType.STATE_PROPERTY, (Comparable)((Object)ElementType.random())));
        }
    }

    @Deprecated
    public boolean m_6864_(@Nonnull BlockState state, @Nonnull BlockPlaceContext context) {
        return super.m_6864_(state, context) && BlockEntityHelper.getBlockEntityAs((BlockGetter)context.m_43725_(), context.m_8083_(), SourceBlockEntity.class).map(s -> !s.isStabilized()).orElse(true) != false;
    }

    @Override
    @Nonnull
    @Deprecated
    public RenderShape m_7514_(@Nonnull BlockState state) {
        return RenderShape.INVISIBLE;
    }
}

