/*
 * Decompiled with CFR 0.152.
 */
package sirttas.elementalcraft.block.pipe.upgrade.pump;

import com.mojang.blaze3d.vertex.PoseStack;
import javax.annotation.Nonnull;
import net.minecraft.client.Minecraft;
import net.minecraft.client.renderer.MultiBufferSource;
import net.minecraft.client.resources.model.BakedModel;
import net.minecraft.client.resources.model.ModelManager;
import net.minecraft.resources.ResourceLocation;
import net.minecraftforge.common.capabilities.ICapabilityProvider;
import sirttas.elementalcraft.ElementalCraft;
import sirttas.elementalcraft.block.pipe.ElementPipeBlockEntity;
import sirttas.elementalcraft.block.pipe.upgrade.pump.ElementPumpPipeUpgrade;
import sirttas.elementalcraft.block.pipe.upgrade.renderer.IPipeUpgradeRenderer;
import sirttas.elementalcraft.renderer.ECRendererHelper;

public class ElementPumpPipeUpgradeRenderer
implements IPipeUpgradeRenderer<ElementPumpPipeUpgrade> {
    public static final ResourceLocation PUMP_LOCATION = ElementalCraft.createRL("elementalcraft/pipe_upgrade/element_pump_pump");
    private BakedModel pumpModel;

    @Override
    public void render(ElementPumpPipeUpgrade upgrade, ElementPipeBlockEntity pipe, float partialTicks, @Nonnull PoseStack poseStack, @Nonnull MultiBufferSource buffer, int light, int overlay) {
        if (this.pumpModel == null) {
            ModelManager modelManager = Minecraft.m_91087_().m_91304_();
            this.pumpModel = modelManager.getModel(PUMP_LOCATION);
        }
        float tick = ECRendererHelper.getClientTicks(partialTicks) % 30.0f;
        poseStack.m_85836_();
        if (tick < 10.0f && tick >= 0.0f) {
            poseStack.m_85837_(0.0, (double)((0.0f - tick) / 50.0f), 0.0);
        } else if (tick >= 10.0f && tick < 15.0f) {
            poseStack.m_85837_(0.0, (double)-0.2f, 0.0);
        } else if (tick >= 15.0f && tick < 25.0f) {
            poseStack.m_85837_(0.0, (double)(-0.2f + (tick - 15.0f) / 50.0f), 0.0);
        }
        ECRendererHelper.renderModel(this.pumpModel, poseStack, buffer, pipe, light, overlay);
        poseStack.m_85849_();
        poseStack.m_85837_(0.25, 0.5, 0.25);
        poseStack.m_85841_(0.5f, 0.5f, 0.5f);
        ECRendererHelper.renderRunes(poseStack, buffer, (ICapabilityProvider)upgrade, partialTicks, light, overlay);
    }
}

