/*
 * Decompiled with CFR 0.152.
 */
package sirttas.elementalcraft.block.evaporator;

import javax.annotation.Nonnull;
import net.minecraft.core.BlockPos;
import net.minecraft.world.Container;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.block.state.BlockState;
import sirttas.elementalcraft.api.element.ElementType;
import sirttas.elementalcraft.api.element.storage.IElementStorage;
import sirttas.elementalcraft.api.element.storage.single.ISingleElementStorage;
import sirttas.elementalcraft.api.element.storage.single.SingleElementStorage;
import sirttas.elementalcraft.api.rune.handler.RuneHandler;
import sirttas.elementalcraft.block.container.IContainerTopBlockEntity;
import sirttas.elementalcraft.block.entity.AbstractIERBlockEntity;
import sirttas.elementalcraft.block.entity.ECBlockEntityTypes;
import sirttas.elementalcraft.block.evaporator.EvaporatorBlock;
import sirttas.elementalcraft.config.ECConfig;
import sirttas.elementalcraft.container.SingleStackContainer;
import sirttas.elementalcraft.item.elemental.ShardItem;

public class EvaporatorBlockEntity
extends AbstractIERBlockEntity
implements IContainerTopBlockEntity {
    private final SingleStackContainer inventory = new SingleStackContainer(this::m_6596_);
    private final SingleElementStorage elementStorage;
    private final RuneHandler runeHandler;
    private ISingleElementStorage containerCache;

    public EvaporatorBlockEntity(BlockPos pos, BlockState state) {
        super(ECBlockEntityTypes.EVAPORATOR, pos, state);
        this.elementStorage = new SingleElementStorage((Integer)ECConfig.COMMON.shardElementAmount.get() * 20, this::m_6596_);
        this.runeHandler = new RuneHandler((Integer)ECConfig.COMMON.evaporatorMaxRunes.get(), this::m_6596_);
    }

    public static void serverTick(Level level, BlockPos pos, BlockState state, EvaporatorBlockEntity evaporator) {
        ItemStack stack = evaporator.inventory.m_8020_(0);
        Item item = stack.m_41720_();
        ElementType type = EvaporatorBlock.getShardElementType(stack);
        float extractionAmount = evaporator.runeHandler.getTransferSpeed(((Integer)ECConfig.COMMON.evaporatorExtractionAmount.get()).intValue());
        if (type != ElementType.NONE && (float)evaporator.elementStorage.getElementAmount() <= extractionAmount) {
            evaporator.elementStorage.insertElement(evaporator.getShardElementAmount((ShardItem)item), type, false);
            stack.m_41774_(1);
            if (stack.m_41619_()) {
                evaporator.inventory.m_6836_(0, ItemStack.f_41583_);
            }
        }
        if (evaporator.canExtract()) {
            evaporator.elementStorage.transferTo((IElementStorage)evaporator.getContainer(), extractionAmount, evaporator.runeHandler.getElementPreservation());
        }
    }

    public boolean canExtract() {
        ISingleElementStorage container = this.getContainer();
        return !this.elementStorage.isEmpty() && this.m_58898_() && container != null && (container.getElementAmount() < container.getElementCapacity() || container.getElementType() != this.elementStorage.getElementType());
    }

    private int getShardElementAmount(ShardItem item) {
        return Math.round((float)((Integer)ECConfig.COMMON.shardElementAmount.get() * item.getElementAmount()) * this.runeHandler.getElementPreservation());
    }

    @Override
    @Nonnull
    public Container getInventory() {
        return this.inventory;
    }

    @Override
    public ISingleElementStorage getElementStorage() {
        return this.elementStorage;
    }

    @Override
    public RuneHandler getRuneHandler() {
        return this.runeHandler;
    }

    @Override
    public ISingleElementStorage getContainer() {
        if (this.containerCache == null) {
            this.containerCache = IContainerTopBlockEntity.super.getContainer();
        }
        return this.containerCache;
    }
}

