/*
 * Decompiled with CFR 0.152.
 */
package com.supermartijn642.fusion.model.types.vanilla;

import com.google.gson.JsonElement;
import com.google.gson.JsonObject;
import com.google.gson.JsonParseException;
import com.supermartijn642.fusion.api.model.GatherTexturesContext;
import com.supermartijn642.fusion.api.model.ModelBakingContext;
import com.supermartijn642.fusion.api.model.ModelInstance;
import com.supermartijn642.fusion.api.model.ModelType;
import com.supermartijn642.fusion.api.model.SpriteIdentifier;
import com.supermartijn642.fusion.model.types.vanilla.VanillaModelSerializer;
import java.util.Collection;
import java.util.HashSet;
import java.util.LinkedHashSet;
import java.util.stream.Collectors;
import net.minecraft.client.renderer.block.model.BlockModel;
import net.minecraft.client.resources.model.BakedModel;
import net.minecraft.client.resources.model.ModelBakery;
import net.minecraft.resources.ResourceLocation;
import net.minecraftforge.client.model.ExtendedBlockModelDeserializer;
import org.jetbrains.annotations.Nullable;

public class VanillaModelType
implements ModelType<BlockModel> {
    @Override
    public Collection<ResourceLocation> getModelDependencies(BlockModel data) {
        return data.m_7970_();
    }

    @Override
    public Collection<SpriteIdentifier> getTextureDependencies(GatherTexturesContext context, BlockModel data) {
        VanillaModelType.resolveParents(context, data);
        HashSet errors = new HashSet();
        Collection materials = data.m_5500_(location -> context.getModel((ResourceLocation)location).getAsVanillaModel(), errors);
        return materials.stream().map(SpriteIdentifier::of).collect(Collectors.toList());
    }

    @Override
    public BakedModel bake(ModelBakingContext context, BlockModel data) {
        return data.m_7611_(context.getModelBakery(), material -> context.getTexture(SpriteIdentifier.of(material)), context.getTransformation(), context.getModelIdentifier());
    }

    @Override
    @Nullable
    public BlockModel getAsVanillaModel(BlockModel data) {
        return data;
    }

    @Override
    public BlockModel deserialize(JsonObject json) throws JsonParseException {
        return (BlockModel)ExtendedBlockModelDeserializer.INSTANCE.fromJson((JsonElement)json, BlockModel.class);
    }

    @Override
    public JsonObject serialize(BlockModel value) {
        return (JsonObject)VanillaModelSerializer.GSON.toJsonTree((Object)value);
    }

    private static void resolveParents(GatherTexturesContext context, BlockModel model) {
        LinkedHashSet<BlockModel> passedModels = new LinkedHashSet<BlockModel>();
        while (model.f_111419_ != null && model.f_111418_ == null) {
            passedModels.add(model);
            ModelInstance<?> modelInstance = context.getModel(model.f_111419_);
            BlockModel parent = modelInstance.getAsVanillaModel();
            if (parent == null) {
                BlockModel.f_111420_.warn("Vanilla model {} cannot have parent with model type {} for {}!", new Object[]{model, modelInstance.getModelType(), model.f_111419_});
            }
            if (passedModels.contains(parent)) {
                BlockModel.f_111420_.warn("Found 'parent' loop while loading model '{}' in chain: {} -> {}", new Object[]{model, passedModels.stream().map(Object::toString).collect(Collectors.joining(" -> ")), model.f_111419_});
                parent = null;
            }
            if (parent == null) {
                model.f_111419_ = ModelBakery.f_119230_;
                parent = context.getModel(model.f_111419_).getAsVanillaModel();
                if (parent == null) {
                    throw new RuntimeException("Got null for missing model request!");
                }
            }
            model.f_111418_ = parent;
            model = parent;
        }
    }
}

