/*
 * Decompiled with CFR 0.152.
 */
package com.supermartijn642.fusion.mixin.modernfix;

import com.google.common.collect.Lists;
import com.supermartijn642.fusion.api.texture.TextureType;
import com.supermartijn642.fusion.api.util.Pair;
import com.supermartijn642.fusion.extensions.TextureAtlasSpriteExtension;
import com.supermartijn642.fusion.texture.FusionMetadataSection;
import com.supermartijn642.fusion.texture.SpriteCreationContextImpl;
import com.supermartijn642.fusion.texture.SpritePreparationContextImpl;
import com.supermartijn642.fusion.texture.TextureTypeRegistryImpl;
import java.io.IOException;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Optional;
import java.util.Set;
import java.util.concurrent.CompletableFuture;
import net.minecraft.Util;
import net.minecraft.client.renderer.texture.Stitcher;
import net.minecraft.client.renderer.texture.TextureAtlas;
import net.minecraft.client.renderer.texture.TextureAtlasSprite;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.server.packs.metadata.MetadataSectionSerializer;
import net.minecraft.server.packs.resources.Resource;
import net.minecraft.server.packs.resources.ResourceManager;
import org.spongepowered.asm.mixin.Mixin;
import org.spongepowered.asm.mixin.Shadow;
import org.spongepowered.asm.mixin.Unique;
import org.spongepowered.asm.mixin.injection.At;
import org.spongepowered.asm.mixin.injection.Inject;
import org.spongepowered.asm.mixin.injection.callback.CallbackInfoReturnable;
import org.spongepowered.asm.mixin.injection.callback.LocalCapture;

@Mixin(value={TextureAtlas.class}, priority=900)
public class TextureAtlasMixinModernFix {
    @Unique
    private final Map<ResourceLocation, Pair<TextureType<Object>, Object>> fusionTextureMetadata = new HashMap<ResourceLocation, Pair<TextureType<Object>, Object>>();

    @Shadow
    private ResourceLocation m_118324_(ResourceLocation p_118325_) {
        throw new AssertionError();
    }

    @Inject(method={"getBasicSpriteInfos(Lnet/minecraft/server/packs/resources/ResourceManager;Ljava/util/Set;)Ljava/util/Collection;"}, at={@At(value="RETURN")})
    private void gatherMetadata(ResourceManager resourceManager, Set<ResourceLocation> sprites, CallbackInfoReturnable<Collection<TextureAtlasSprite.Info>> ci) {
        Collection spriteInfos = (Collection)ci.getReturnValue();
        ArrayList tasks = Lists.newArrayList();
        for (TextureAtlasSprite.Info info : spriteInfos) {
            tasks.add(CompletableFuture.runAsync(() -> {
                ResourceLocation location = this.m_118324_(info.m_118431_());
                Optional optional = resourceManager.m_213713_(location);
                if (optional.isPresent()) {
                    Pair metadata;
                    Resource resource = (Resource)optional.get();
                    try {
                        metadata = resource.m_215509_().m_214059_((MetadataSectionSerializer)FusionMetadataSection.INSTANCE).orElse(null);
                    }
                    catch (IOException e) {
                        throw new RuntimeException("Encountered an exception whilst reading metadata for '" + location + "'!", e);
                    }
                    if (metadata != null) {
                        Pair<Integer, Integer> newSize;
                        this.fusionTextureMetadata.put(info.m_118431_(), metadata);
                        try {
                            newSize = ((TextureType)metadata.left()).getFrameSize(new SpritePreparationContextImpl(info.m_118434_(), info.m_118437_(), info.m_118434_(), info.m_118437_(), info.m_118431_()), metadata.right());
                        }
                        catch (Exception e) {
                            throw new RuntimeException("Encountered an exception whilst getting frame size from texture type '" + TextureTypeRegistryImpl.getIdentifier((TextureType)metadata.left()) + "' for texture '" + location + "'!", e);
                        }
                        if (newSize == null) {
                            throw new RuntimeException("Received null frame size from texture type '" + TextureTypeRegistryImpl.getIdentifier((TextureType)metadata.left()) + "' for texture '" + location + "'!");
                        }
                        info.f_118423_ = newSize.left();
                        info.f_118424_ = newSize.right();
                    }
                }
            }, Util.m_183991_()));
        }
        CompletableFuture.allOf(tasks.toArray(new CompletableFuture[0])).join();
    }

    @Inject(method={"getLoadedSprites(Lnet/minecraft/server/packs/resources/ResourceManager;Lnet/minecraft/client/renderer/texture/Stitcher;I)Ljava/util/List;"}, at={@At(value="RETURN")}, locals=LocalCapture.CAPTURE_FAILHARD)
    private void getLoadedSprites(ResourceManager resourceManager, Stitcher stitcher, int i, CallbackInfoReturnable<List<TextureAtlasSprite>> ci) {
        List textures = (List)ci.getReturnValue();
        if (textures != null) {
            for (int index = 0; index < textures.size(); ++index) {
                TextureAtlasSprite newTexture;
                TextureAtlasSprite texture = (TextureAtlasSprite)textures.get(index);
                Pair<TextureType<Object>, Object> textureData = this.fusionTextureMetadata.get(texture.m_118413_());
                if (textureData == null) continue;
                try (SpriteCreationContextImpl context = new SpriteCreationContextImpl(texture);){
                    newTexture = textureData.left().createSprite(context, textureData.right());
                }
                catch (Exception e) {
                    throw new RuntimeException("Encountered an exception whilst initialising texture '" + texture.m_118413_() + "' for texture type '" + TextureTypeRegistryImpl.getIdentifier(textureData.left()) + "'!", e);
                }
                if (newTexture == null) {
                    throw new RuntimeException("Received null texture from texture type '" + TextureTypeRegistryImpl.getIdentifier(textureData.left()) + "' for texture '" + texture.m_118413_() + "'!");
                }
                ((TextureAtlasSpriteExtension)newTexture).setFusionTextureType(textureData.left());
                textures.set(index, newTexture);
            }
        }
        this.fusionTextureMetadata.clear();
    }
}

