/*
 * Decompiled with CFR 0.152.
 */
package shadows.wstweaks;

import java.util.ArrayList;
import net.minecraft.core.BlockPos;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.util.RandomSource;
import net.minecraft.world.InteractionHand;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.EntityType;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.Mob;
import net.minecraft.world.entity.item.ItemEntity;
import net.minecraft.world.entity.monster.AbstractSkeleton;
import net.minecraft.world.entity.monster.Skeleton;
import net.minecraft.world.entity.monster.WitherSkeleton;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.Items;
import net.minecraft.world.level.ItemLike;
import net.minecraft.world.level.Level;
import net.minecraftforge.event.ForgeEventFactory;
import net.minecraftforge.event.entity.EntityJoinLevelEvent;
import net.minecraftforge.event.entity.living.LivingDropsEvent;
import net.minecraftforge.event.entity.living.LivingSpawnEvent;
import net.minecraftforge.eventbus.api.SubscribeEvent;
import net.minecraftforge.fml.common.Mod;
import shadows.wstweaks.WSTConfig;

@Mod.EventBusSubscriber(modid="wstweaks")
public class WSTEvents {
    @SubscribeEvent
    public static void witherTransform(LivingSpawnEvent.SpecialSpawn event) {
        Skeleton skeleton;
        Mob mob = event.getEntity();
        if (mob instanceof Skeleton && !(skeleton = (Skeleton)mob).m_213877_()) {
            RandomSource rand = event.getLevel().m_213780_();
            if (!event.getLevel().m_5776_()) {
                double x = skeleton.m_20185_();
                double y = skeleton.m_20186_();
                double z = skeleton.m_20189_();
                if (skeleton.f_19853_.m_46472_() == Level.f_46429_ || WSTConfig.allBiomes && event.getLevel().m_45524_(new BlockPos(x, y, z), 0) < 9 && rand.m_188501_() < WSTConfig.allBiomesChance) {
                    event.setCanceled(true);
                    skeleton.getPersistentData().m_128379_("wst.removed", true);
                    WitherSkeleton witherSkel = (WitherSkeleton)skeleton.m_21406_(EntityType.f_20497_, true);
                    if (witherSkel == null) {
                        return;
                    }
                    witherSkel.m_7678_(x, y, z, 0.0f, 0.0f);
                    event.getLevel().m_7967_((Entity)witherSkel);
                    ForgeEventFactory.onLivingConvert((LivingEntity)skeleton, (LivingEntity)witherSkel);
                    if (WSTConfig.giveBows) {
                        witherSkel.m_21008_(InteractionHand.MAIN_HAND, new ItemStack((ItemLike)Items.f_42411_));
                    }
                }
            }
        }
    }

    @SubscribeEvent
    public static void join(EntityJoinLevelEvent e) {
        if (e.getEntity().getPersistentData().m_128471_("wst.removed")) {
            e.setCanceled(true);
        }
    }

    @SubscribeEvent
    public static void handleDropsEvent(LivingDropsEvent event) {
        WSTEvents.delSwords(event);
    }

    public static void delSwords(LivingDropsEvent event) {
        if (WSTConfig.delSwords && !event.getEntity().f_19853_.f_46443_ && event.getEntity() instanceof AbstractSkeleton) {
            ArrayList<ItemEntity> toRemove = new ArrayList<ItemEntity>();
            for (ItemEntity entity : event.getDrops()) {
                CompoundTag tag;
                ItemStack stack = entity.m_32055_();
                if (stack.m_41720_() != Items.f_42425_ && stack.m_41720_() != Items.f_42411_ || (tag = stack.m_41783_()) != null && (tag.m_128441_("Damage") && tag.m_128431_().size() > 2 || tag.m_128431_().size() > 1)) continue;
                toRemove.add(entity);
            }
            for (ItemEntity i : toRemove) {
                event.getDrops().remove(i);
            }
        }
    }
}

