/*
 * Decompiled with CFR 0.152.
 */
package cofh.lib.fluid;

import cofh.lib.util.DeferredRegisterCoFH;
import com.mojang.math.Vector3f;
import java.util.function.Supplier;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.world.item.Item;
import net.minecraft.world.level.block.LiquidBlock;
import net.minecraft.world.level.material.Fluid;
import net.minecraftforge.fluids.FluidType;
import net.minecraftforge.fluids.ForgeFlowingFluid;
import net.minecraftforge.registries.RegistryObject;

public abstract class FluidCoFH {
    public static final ResourceLocation WATER_OVERLAY = new ResourceLocation("block/water_overlay");
    public static final ResourceLocation UNDERWATER_LOCATION = new ResourceLocation("textures/misc/underwater.png");
    protected RegistryObject<ForgeFlowingFluid> stillFluid;
    protected RegistryObject<ForgeFlowingFluid> flowingFluid;
    protected RegistryObject<LiquidBlock> block;
    protected RegistryObject<Item> bucket;
    protected ForgeFlowingFluid.Properties properties;
    protected Vector3f particleColor = new Vector3f(1.0f, 1.0f, 1.0f);

    protected FluidCoFH() {
    }

    protected FluidCoFH(DeferredRegisterCoFH<Fluid> reg, String key) {
        this.stillFluid = reg.register(key, () -> new ForgeFlowingFluid.Source(this.fluidProperties()));
        this.flowingFluid = reg.register(FluidCoFH.flowing(key), () -> new ForgeFlowingFluid.Flowing(this.fluidProperties()));
    }

    protected ForgeFlowingFluid.Properties fluidProperties() {
        return new ForgeFlowingFluid.Properties(this.type(), this.stillFluid, this.flowingFluid);
    }

    protected abstract Supplier<FluidType> type();

    public Supplier<ForgeFlowingFluid> still() {
        return this.stillFluid;
    }

    public Supplier<ForgeFlowingFluid> flowing() {
        return this.flowingFluid;
    }

    public Supplier<LiquidBlock> block() {
        return this.block;
    }

    public Supplier<Item> bucket() {
        return this.bucket;
    }

    public static String fluid(String fluid) {
        return fluid + "_fluid";
    }

    public static String flowing(String fluid) {
        return fluid + "_flowing";
    }

    public static String bucket(String fluid) {
        return fluid + "_bucket";
    }
}

