/*
 * Decompiled with CFR 0.152.
 */
package cofh.lib.block;

import cofh.lib.block.DirectionalBlock4Way;
import cofh.lib.util.constants.BlockStatePropertiesCoFH;
import cofh.lib.util.helpers.MathHelper;
import com.mojang.datafixers.util.Pair;
import java.util.function.Supplier;
import javax.annotation.Nonnull;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Direction;
import net.minecraft.world.InteractionHand;
import net.minecraft.world.InteractionResult;
import net.minecraft.world.effect.MobEffectInstance;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.food.FoodProperties;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.Items;
import net.minecraft.world.level.BlockGetter;
import net.minecraft.world.level.ItemLike;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.LevelAccessor;
import net.minecraft.world.level.LevelReader;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.block.Blocks;
import net.minecraft.world.level.block.state.BlockBehaviour;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.level.block.state.StateDefinition;
import net.minecraft.world.level.block.state.properties.IntegerProperty;
import net.minecraft.world.level.block.state.properties.Property;
import net.minecraft.world.level.pathfinder.PathComputationType;
import net.minecraft.world.phys.BlockHitResult;
import net.minecraft.world.phys.shapes.CollisionContext;
import net.minecraft.world.phys.shapes.VoxelShape;

public class FeastBlock
extends DirectionalBlock4Way {
    protected static final VoxelShape[] SHAPE_BY_BITE = new VoxelShape[]{FeastBlock.m_49796_((double)0.0, (double)0.0, (double)0.0, (double)16.0, (double)16.0, (double)16.0), FeastBlock.m_49796_((double)0.0, (double)0.0, (double)0.0, (double)16.0, (double)14.0, (double)16.0), FeastBlock.m_49796_((double)0.0, (double)0.0, (double)0.0, (double)16.0, (double)12.0, (double)16.0), FeastBlock.m_49796_((double)0.0, (double)0.0, (double)0.0, (double)16.0, (double)10.0, (double)16.0), FeastBlock.m_49796_((double)0.0, (double)0.0, (double)0.0, (double)16.0, (double)8.0, (double)16.0), FeastBlock.m_49796_((double)0.0, (double)0.0, (double)0.0, (double)16.0, (double)6.0, (double)16.0), FeastBlock.m_49796_((double)0.0, (double)0.0, (double)0.0, (double)16.0, (double)4.0, (double)16.0), FeastBlock.m_49796_((double)0.0, (double)0.0, (double)0.0, (double)16.0, (double)2.0, (double)16.0)};
    protected final FoodProperties food;
    protected Supplier<Item> serving = () -> Items.f_41852_;

    public FeastBlock(BlockBehaviour.Properties properties, @Nonnull FoodProperties food) {
        super(properties);
        this.food = food;
    }

    public FeastBlock serving(Supplier<Item> serving) {
        this.serving = serving;
        return this;
    }

    protected ItemLike getServingItem() {
        return (ItemLike)this.serving.get();
    }

    public IntegerProperty getBitesProperty() {
        return BlockStatePropertiesCoFH.BITES_0_7;
    }

    protected int getMaxBites() {
        return this.getBitesProperty().m_6908_().size() - 1;
    }

    protected InteractionResult serve(Level world, BlockPos pos, BlockState state, Player player) {
        boolean takeServing;
        ItemStack servItem = new ItemStack(this.getServingItem());
        boolean bl = takeServing = !servItem.m_41619_() && !player.m_36341_();
        if (!player.m_36391_(takeServing)) {
            return InteractionResult.PASS;
        }
        if (takeServing) {
            player.m_36356_(servItem);
        } else {
            player.m_36324_().m_38707_(this.food.m_38744_(), this.food.m_38745_());
            for (Pair pair : this.food.m_38749_()) {
                if (world.f_46443_ || pair.getFirst() == null || !(world.f_46441_.m_188501_() < ((Float)pair.getSecond()).floatValue())) continue;
                player.m_7292_(new MobEffectInstance((MobEffectInstance)pair.getFirst()));
            }
        }
        int i = (Integer)state.m_61143_((Property)this.getBitesProperty());
        if (i < this.getMaxBites()) {
            world.m_7731_(pos, (BlockState)state.m_61124_((Property)this.getBitesProperty(), (Comparable)Integer.valueOf(i + 1)), 3);
        } else {
            world.m_7471_(pos, false);
        }
        return InteractionResult.SUCCESS;
    }

    @Override
    public InteractionResult m_6227_(BlockState state, Level worldIn, BlockPos pos, Player player, InteractionHand handIn, BlockHitResult hit) {
        if (worldIn.f_46443_) {
            ItemStack stack = player.m_21120_(handIn);
            if (this.serve(worldIn, pos, state, player).m_19077_()) {
                return InteractionResult.SUCCESS;
            }
            if (stack.m_41619_()) {
                return InteractionResult.CONSUME;
            }
        }
        return this.serve(worldIn, pos, state, player);
    }

    public VoxelShape m_5940_(BlockState state, BlockGetter world, BlockPos pos, CollisionContext context) {
        return SHAPE_BY_BITE[MathHelper.clamp((Integer)state.m_61143_((Property)this.getBitesProperty()), 0, SHAPE_BY_BITE.length - 1)];
    }

    public BlockState m_7417_(BlockState stateIn, Direction facing, BlockState facingState, LevelAccessor worldIn, BlockPos currentPos, BlockPos facingPos) {
        return facing == Direction.DOWN && !stateIn.m_60710_((LevelReader)worldIn, currentPos) ? Blocks.f_50016_.m_49966_() : super.m_7417_(stateIn, facing, facingState, worldIn, currentPos, facingPos);
    }

    public boolean m_7898_(BlockState stateIn, LevelReader worldIn, BlockPos pos) {
        return worldIn.m_8055_(pos.m_7495_()).m_60767_().m_76333_();
    }

    @Override
    protected void m_7926_(StateDefinition.Builder<Block, BlockState> builder) {
        super.m_7926_(builder);
        builder.m_61104_(new Property[]{this.getBitesProperty()});
    }

    public boolean m_7357_(BlockState stateIn, BlockGetter worldIn, BlockPos pos, PathComputationType type) {
        return false;
    }
}

