/*
 * Decompiled with CFR 0.152.
 */
package cofh.core.event;

import cofh.core.config.CoreCommonConfig;
import cofh.core.config.CoreEnchantConfig;
import cofh.core.init.CoreMobEffects;
import cofh.core.util.helpers.XpHelper;
import cofh.lib.util.Utils;
import java.util.Map;
import net.minecraft.world.effect.MobEffect;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.EquipmentSlot;
import net.minecraft.world.entity.ExperienceOrb;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.enchantment.Enchantments;
import net.minecraft.world.phys.Vec3;
import net.minecraftforge.common.util.FakePlayer;
import net.minecraftforge.event.TickEvent;
import net.minecraftforge.event.entity.living.LivingFallEvent;
import net.minecraftforge.event.entity.player.ItemFishedEvent;
import net.minecraftforge.event.entity.player.PlayerXpEvent;
import net.minecraftforge.event.level.BlockEvent;
import net.minecraftforge.event.level.SaplingGrowTreeEvent;
import net.minecraftforge.eventbus.api.Event;
import net.minecraftforge.eventbus.api.EventPriority;
import net.minecraftforge.eventbus.api.SubscribeEvent;
import net.minecraftforge.fml.common.Mod;

@Mod.EventBusSubscriber(modid="cofh_core")
public class CoreCommonEvents {
    private CoreCommonEvents() {
    }

    @SubscribeEvent
    public static void handleFarmlandTrampleEvent(BlockEvent.FarmlandTrampleEvent event) {
        int encFeatherFalling;
        if (event.isCanceled()) {
            return;
        }
        if (!CoreEnchantConfig.improvedFeatherFalling()) {
            return;
        }
        Entity entity = event.getEntity();
        if (entity instanceof LivingEntity && (encFeatherFalling = Utils.getMaxEquippedEnchantmentLevel((LivingEntity)entity, Enchantments.f_44967_)) > 0) {
            event.setCanceled(true);
        }
    }

    @SubscribeEvent
    public static void handleLivingFallEvent(LivingFallEvent event) {
        LivingEntity living;
        if (event.isCanceled()) {
            return;
        }
        if ((double)event.getDistance() >= 3.0 && (living = event.getEntity()).m_21023_((MobEffect)CoreMobEffects.SLIMED.get())) {
            Vec3 motion = living.m_20184_();
            living.m_20334_(motion.f_82479_, 0.08 * Math.sqrt((double)event.getDistance() / 0.08), motion.f_82481_);
            living.f_19864_ = true;
            event.setCanceled(true);
        }
    }

    @SubscribeEvent(priority=EventPriority.LOWEST)
    public static void handleItemFishedEvent(ItemFishedEvent event) {
        if (event.isCanceled()) {
            return;
        }
        if (!CoreCommonConfig.enableFishingExhaustion()) {
            return;
        }
        Entity player = event.getHookEntity().m_37282_();
        if (!(player instanceof Player) || player instanceof FakePlayer) {
            return;
        }
        ((Player)player).m_36399_(CoreCommonConfig.amountFishingExhaustion());
    }

    @SubscribeEvent(priority=EventPriority.LOW)
    public static void handlePickupXpEvent(PlayerXpEvent.PickupXp event) {
        if (event.isCanceled()) {
            return;
        }
        Player player = event.getEntity();
        ExperienceOrb orb = event.getOrb();
        if (CoreEnchantConfig.improvedMending()) {
            ItemStack itemstack;
            player.f_36101_ = 2;
            player.m_7938_((Entity)orb, 1);
            Map.Entry<EquipmentSlot, ItemStack> entry = CoreCommonEvents.getMostDamagedItem(player);
            if (entry != null && !(itemstack = entry.getValue()).m_41619_() && itemstack.m_41768_()) {
                int i = Math.min((int)((float)orb.f_20770_ * itemstack.getXpRepairRatio()), itemstack.m_41773_());
                orb.f_20770_ -= CoreCommonEvents.durabilityToXp(i);
                itemstack.m_41721_(itemstack.m_41773_() - i);
            }
            XpHelper.attemptStoreXP(player, orb);
            if (orb.f_20770_ > 0) {
                player.m_6756_(orb.f_20770_);
            }
            orb.m_146870_();
            event.setCanceled(true);
            return;
        }
        XpHelper.attemptStoreXP(player, orb);
    }

    @SubscribeEvent(priority=EventPriority.LOWEST)
    public static void handleSaplingGrowTreeEvent(SaplingGrowTreeEvent event) {
        if (event.isCanceled()) {
            return;
        }
        if (!CoreCommonConfig.enableSaplingGrowthMod()) {
            return;
        }
        if (event.getRandomSource().m_188503_(CoreCommonConfig.amountSaplingGrowthMod()) != 0) {
            event.setResult(Event.Result.DENY);
        }
    }

    @SubscribeEvent
    public static void serverTick(TickEvent.ServerTickEvent event) {
        if (event.phase == TickEvent.Phase.START) {
            Utils.tickTimeConstants();
        }
    }

    private static Map.Entry<EquipmentSlot, ItemStack> getMostDamagedItem(Player player) {
        Map map = Enchantments.f_44962_.m_44684_((LivingEntity)player);
        Map.Entry mostDamaged = null;
        if (map.isEmpty()) {
            return null;
        }
        double durability = 0.0;
        for (Map.Entry entry : map.entrySet()) {
            ItemStack stack = (ItemStack)entry.getValue();
            if (stack.m_41619_() || Utils.getItemEnchantmentLevel(Enchantments.f_44962_, stack) <= 0 || !(CoreCommonEvents.calcDurabilityRatio(stack) > durability)) continue;
            mostDamaged = entry;
            durability = CoreCommonEvents.calcDurabilityRatio(stack);
        }
        return mostDamaged;
    }

    private static int durabilityToXp(int durability) {
        return durability / 2;
    }

    private static int xpToDurability(int xp) {
        return xp * 2;
    }

    private static double calcDurabilityRatio(ItemStack stack) {
        return (double)stack.m_41773_() / (double)stack.m_41776_();
    }
}

