/*
 * Decompiled with CFR 0.152.
 */
package cofh.core.client.gui.element.panel;

import cofh.core.client.gui.CoreTextures;
import cofh.core.client.gui.IGuiAccess;
import cofh.core.client.gui.element.panel.PanelBase;
import cofh.core.util.helpers.RenderHelper;
import cofh.lib.api.control.IRedstoneControllable;
import cofh.lib.util.helpers.SoundHelper;
import cofh.lib.util.helpers.StringHelper;
import com.mojang.blaze3d.systems.RenderSystem;
import com.mojang.blaze3d.vertex.PoseStack;
import java.util.List;
import net.minecraft.ChatFormatting;
import net.minecraft.network.chat.Component;

public class RSControlPanel
extends PanelBase {
    public static int defaultSide = 1;
    public static int defaultHeaderColor = 14797103;
    public static int defaultSubHeaderColor = 11186104;
    public static int defaultTextColor = 0x101010;
    public static int defaultBackgroundColor = 13640458;
    private final IRedstoneControllable myRSControllable;

    public RSControlPanel(IGuiAccess gui, IRedstoneControllable rsControllable) {
        this(gui, defaultSide, rsControllable);
    }

    protected RSControlPanel(IGuiAccess gui, int sideIn, IRedstoneControllable rsControllable) {
        super(gui, sideIn);
        this.headerColor = defaultHeaderColor;
        this.subheaderColor = defaultSubHeaderColor;
        this.textColor = defaultTextColor;
        this.backgroundColor = defaultBackgroundColor;
        this.maxHeight = 92;
        this.maxWidth = 112;
        this.myRSControllable = rsControllable;
        this.setVisible(this.myRSControllable::isControllable);
    }

    @Override
    protected void drawForeground(PoseStack matrixStack) {
        this.drawPanelIcon(matrixStack, CoreTextures.ICON_REDSTONE_ON);
        if (!this.fullyOpen) {
            return;
        }
        this.fontRenderer().m_92750_(matrixStack, StringHelper.localize("info.cofh.redstone_control"), (float)(this.sideOffset() + 18), 6.0f, this.headerColor);
        this.fontRenderer().m_92750_(matrixStack, StringHelper.localize("info.cofh.control_status") + ":", (float)(this.sideOffset() + 6), 42.0f, this.subheaderColor);
        this.fontRenderer().m_92750_(matrixStack, StringHelper.localize("info.cofh.signal_required") + ":", (float)(this.sideOffset() + 6), 66.0f, this.subheaderColor);
        this.gui.drawIcon(matrixStack, CoreTextures.ICON_BUTTON, 28, 20);
        this.gui.drawIcon(matrixStack, CoreTextures.ICON_BUTTON, 48, 20);
        this.gui.drawIcon(matrixStack, CoreTextures.ICON_BUTTON, 68, 20);
        switch (this.myRSControllable.getMode()) {
            case DISABLED: {
                this.gui.drawIcon(matrixStack, CoreTextures.ICON_BUTTON_HIGHLIGHT, 28, 20);
                this.fontRenderer().m_92883_(matrixStack, StringHelper.localize("info.cofh.disabled"), (float)(this.sideOffset() + 14), 54.0f, this.textColor);
                this.fontRenderer().m_92883_(matrixStack, StringHelper.localize("info.cofh.ignored"), (float)(this.sideOffset() + 14), 78.0f, this.textColor);
                break;
            }
            case LOW: {
                this.gui.drawIcon(matrixStack, CoreTextures.ICON_BUTTON_HIGHLIGHT, 48, 20);
                this.fontRenderer().m_92883_(matrixStack, StringHelper.localize("info.cofh.enabled"), (float)(this.sideOffset() + 14), 54.0f, this.textColor);
                this.fontRenderer().m_92883_(matrixStack, StringHelper.localize("info.cofh.low"), (float)(this.sideOffset() + 14), 78.0f, this.textColor);
                break;
            }
            case HIGH: {
                this.gui.drawIcon(matrixStack, CoreTextures.ICON_BUTTON_HIGHLIGHT, 68, 20);
                this.fontRenderer().m_92883_(matrixStack, StringHelper.localize("info.cofh.enabled"), (float)(this.sideOffset() + 14), 54.0f, this.textColor);
                this.fontRenderer().m_92883_(matrixStack, StringHelper.localize("info.cofh.high"), (float)(this.sideOffset() + 14), 78.0f, this.textColor);
                break;
            }
        }
        this.gui.drawIcon(matrixStack, CoreTextures.ICON_REDSTONE_OFF, 28, 20);
        this.gui.drawIcon(matrixStack, CoreTextures.ICON_RS_TORCH_OFF, 48, 20);
        this.gui.drawIcon(matrixStack, CoreTextures.ICON_RS_TORCH_ON, 68, 20);
        RenderHelper.resetShaderColor();
    }

    @Override
    protected void drawBackground(PoseStack poseStack) {
        super.drawBackground(poseStack);
        if (!this.fullyOpen) {
            return;
        }
        float colorR = (float)(this.backgroundColor >> 16 & 0xFF) / 255.0f * 0.6f;
        float colorG = (float)(this.backgroundColor >> 8 & 0xFF) / 255.0f * 0.6f;
        float colorB = (float)(this.backgroundColor & 0xFF) / 255.0f * 0.6f;
        RenderHelper.setPosTexShader();
        RenderSystem.m_157429_((float)colorR, (float)colorG, (float)colorB, (float)1.0f);
        this.gui.drawTexturedModalRect(poseStack, 24, 16, 16, 20, 64, 24);
        RenderHelper.resetShaderColor();
    }

    @Override
    public void addTooltip(List<Component> tooltipList, int mouseX, int mouseY) {
        if (!this.fullyOpen) {
            tooltipList.add((Component)Component.m_237115_((String)"info.cofh.redstone_control"));
            switch (this.myRSControllable.getMode()) {
                case DISABLED: {
                    tooltipList.add((Component)Component.m_237115_((String)"info.cofh.disabled").m_130940_(ChatFormatting.YELLOW));
                    break;
                }
                case LOW: {
                    tooltipList.add((Component)Component.m_237115_((String)"info.cofh.low").m_130940_(ChatFormatting.YELLOW));
                    break;
                }
                case HIGH: {
                    tooltipList.add((Component)Component.m_237115_((String)"info.cofh.high").m_130940_(ChatFormatting.YELLOW));
                    break;
                }
            }
            tooltipList.add((Component)Component.m_237110_((String)"info.cofh.current_signal", (Object[])new Object[]{this.myRSControllable.getPower()}).m_130940_(this.myRSControllable.getMode() == IRedstoneControllable.ControlMode.DISABLED ? ChatFormatting.YELLOW : (this.myRSControllable.getState() ? ChatFormatting.GREEN : ChatFormatting.RED)));
            return;
        }
        int x = mouseX - this.posX();
        int y = mouseY - this.posY();
        if (28 <= x && x < 44 && 20 <= y && y < 36) {
            tooltipList.add((Component)Component.m_237115_((String)"info.cofh.ignored"));
        } else if (48 <= x && x < 64 && 20 <= y && y < 36) {
            tooltipList.add((Component)Component.m_237115_((String)"info.cofh.low"));
        } else if (68 <= x && x < 84 && 20 <= y && y < 36) {
            tooltipList.add((Component)Component.m_237115_((String)"info.cofh.high"));
        }
    }

    @Override
    public boolean mouseClicked(double mouseX, double mouseY, int mouseButton) {
        if (!this.fullyOpen) {
            return false;
        }
        double x = mouseX - (double)this.posX();
        double y = mouseY - (double)this.posY();
        if (x < 24.0 || x >= 88.0 || y < 16.0 || y >= 40.0) {
            return false;
        }
        if (28.0 <= x && x < 44.0 && 20.0 <= y && y < 36.0) {
            if (this.myRSControllable.getMode() != IRedstoneControllable.ControlMode.DISABLED) {
                this.myRSControllable.setControl(0, IRedstoneControllable.ControlMode.DISABLED);
                SoundHelper.playClickSound(0.4f);
            }
        } else if (48.0 <= x && x < 64.0 && 20.0 <= y && y < 36.0) {
            if (this.myRSControllable.getMode() != IRedstoneControllable.ControlMode.LOW) {
                this.myRSControllable.setControl(0, IRedstoneControllable.ControlMode.LOW);
                SoundHelper.playClickSound(0.6f);
            }
        } else if (68.0 <= x && x < 84.0 && 20.0 <= y && y < 36.0 && this.myRSControllable.getMode() != IRedstoneControllable.ControlMode.HIGH) {
            this.myRSControllable.setControl(0, IRedstoneControllable.ControlMode.HIGH);
            SoundHelper.playClickSound(0.8f);
        }
        return true;
    }
}

